/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public interface StreamChange {
    public void flushChanges(FaweOutputStream var1) throws IOException;

    public void undoChanges(FaweInputStream var1) throws IOException;

    public void redoChanges(FaweInputStream var1) throws IOException;

    default public void flushChanges(File file) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
             LZ4BlockOutputStream compressed = new LZ4BlockOutputStream(out);
             FaweOutputStream fos = new FaweOutputStream(compressed);){
            this.flushChanges(fos);
        }
    }

    default public void undoChanges(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
             LZ4BlockInputStream compressed = new LZ4BlockInputStream(in);
             FaweInputStream fis = new FaweInputStream(compressed);){
            this.undoChanges(fis);
        }
    }

    default public void redoChanges(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
             LZ4BlockInputStream compressed = new LZ4BlockInputStream(in);
             FaweInputStream fis = new FaweInputStream(compressed);){
            this.redoChanges(fis);
        }
    }
}

