/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.util.ExtentTraverser;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;

public class MutableTileChange
implements Change {
    public CompoundTag tag;
    public boolean create;
    private FaweQueue queue;
    private boolean checkedQueue;

    public MutableTileChange(CompoundTag tag, boolean create) {
        this.tag = tag;
        this.create = create;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        if (!this.create) {
            this.create(context);
        }
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        if (this.create) {
            this.create(context);
        }
    }

    public void create(UndoContext context) {
        if (this.queue != null) {
            this.perform(this.queue);
        }
        if (!this.checkedQueue) {
            this.checkedQueue = true;
            Extent extent = context.getExtent();
            ExtentTraverser<HasFaweQueue> found = new ExtentTraverser<Extent>(extent).find(HasFaweQueue.class);
            if (found != null) {
                this.queue = found.get().getQueue();
                this.perform(this.queue);
            } else {
                Fawe.debug("FAWE does not support: " + extent + " for " + this.getClass() + " (bug Empire92)");
            }
        }
    }

    public void perform(FaweQueue queue) {
        Object map = this.tag.getValue();
        int x = ((IntTag)map.get("x")).getValue();
        int y = ((IntTag)map.get("y")).getValue();
        int z = ((IntTag)map.get("z")).getValue();
        queue.setTile(x, y, z, this.tag);
    }
}

