/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.util.ExtentTraverser;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.extent.inventory.BlockBagException;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;

public class MutableFullBlockChange
implements Change {
    public int z;
    public int y;
    public int x;
    public int from;
    public int to;
    public BlockBag blockBag;
    public boolean allowFetch;
    public boolean allowStore;
    private FaweQueue queue;
    private boolean checkedQueue;

    public MutableFullBlockChange(BlockBag blockBag, int mode, boolean redo) {
        this.blockBag = blockBag;
        this.allowFetch = redo || mode == 1;
        this.allowStore = !redo || mode == 1;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        this.create(context);
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        this.create(context);
    }

    public void create(UndoContext context) {
        if (this.queue != null) {
            this.perform(this.queue);
        }
        if (!this.checkedQueue) {
            this.checkedQueue = true;
            Extent extent = context.getExtent();
            ExtentTraverser<HasFaweQueue> found = new ExtentTraverser<Extent>(extent).find(HasFaweQueue.class);
            if (found != null) {
                this.queue = found.get().getQueue();
                this.perform(this.queue);
            } else {
                Fawe.debug("FAWE does not support: " + extent + " for " + this.getClass() + " (bug Empire92)");
            }
        }
    }

    public void perform(FaweQueue queue) {
        BlockTypes idTo;
        BlockTypes idFrom = BlockTypes.getFromStateId(this.from);
        if (this.blockBag != null && idFrom != (idTo = BlockTypes.getFromStateId(this.to))) {
            if (this.allowFetch && this.from != 0) {
                try {
                    this.blockBag.fetchPlacedBlock(BlockState.getFromInternalId(this.from));
                }
                catch (BlockBagException e) {
                    return;
                }
            }
            if (this.allowStore && this.to != 0) {
                try {
                    this.blockBag.storeDroppedBlock(BlockState.getFromInternalId(this.to));
                }
                catch (BlockBagException blockBagException) {
                    // empty catch block
                }
            }
        }
        queue.setBlock(this.x, this.y, this.z, this.from);
    }
}

