/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.util.ExtentTraverser;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.world.block.BlockTypes;

public class MutableChunkChange
implements Change {
    private final boolean checkEmpty;
    public FaweChunk from;
    public FaweChunk to;
    private FaweQueue queue;
    private boolean checkedQueue;

    public MutableChunkChange(FaweChunk from, FaweChunk to, boolean checkEmpty) {
        this.from = from;
        this.to = to;
        this.checkEmpty = checkEmpty;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        this.create(context, true);
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        this.create(context, false);
    }

    public void create(UndoContext context, boolean undo) {
        if (this.queue != null) {
            this.perform(this.queue, undo);
        }
        if (!this.checkedQueue) {
            this.checkedQueue = true;
            Extent extent = context.getExtent();
            ExtentTraverser<HasFaweQueue> found = new ExtentTraverser<Extent>(extent).find(HasFaweQueue.class);
            if (found != null) {
                this.queue = found.get().getQueue();
                this.perform(this.queue, undo);
            } else {
                Fawe.debug("FAWE does not support: " + extent + " for " + this.getClass() + " (bug Empire92)");
            }
        }
    }

    public void perform(FaweQueue queue, boolean undo) {
        if (undo) {
            if (this.checkEmpty) {
                int[][] previousIds = this.from.getCombinedIdArrays();
                int[][] nextIds = this.to.getCombinedIdArrays();
                for (int i = 0; i < previousIds.length; ++i) {
                    if (previousIds[i] != null || nextIds[i] == null) continue;
                    this.from.fillCuboid(0, 15, i << 4, (i << 4) + 15, 0, 15, BlockTypes.AIR.getInternalId());
                }
            }
            queue.setChunk(this.from);
        } else {
            queue.setChunk(this.to);
        }
    }
}

