/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.visualization;

import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.collection.SparseBitSet;
import com.boydti.fawe.object.visitor.FaweChunkVisitor;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class VisualChunk
extends FaweChunk<FaweChunk> {
    public static BlockStateHolder VISUALIZE_BLOCK = BlockTypes.BLACK_STAINED_GLASS.getDefaultState();
    private SparseBitSet add;
    private SparseBitSet remove;

    public VisualChunk(int x, int z) {
        super(null, x, z);
        this.add = new SparseBitSet();
        this.remove = new SparseBitSet();
    }

    protected VisualChunk(int x, int z, SparseBitSet add, SparseBitSet remove) {
        super(null, x, z);
        this.add = add;
        this.remove = remove;
    }

    public int size() {
        return this.add.cardinality() + this.remove.cardinality();
    }

    private final int getIndex(int x, int y, int z) {
        return MathMan.tripleBlockCoordChar(x, y, z);
    }

    @Override
    public int getBitMask() {
        return 0;
    }

    @Override
    public int getBlockCombinedId(int x, int y, int z) {
        int index = this.getIndex(x, y, z);
        if (this.add.get(index)) {
            return VISUALIZE_BLOCK.getInternalId();
        }
        if (this.remove.get(index)) {
            return 1;
        }
        return 0;
    }

    @Override
    public void forEachQueuedBlock(FaweChunkVisitor onEach) {
        int z;
        int y;
        int x;
        int index = -1;
        while ((index = this.add.nextSetBit(index + 1)) != -1) {
            x = MathMan.untripleBlockCoordX(index);
            y = MathMan.untripleBlockCoordY(index);
            z = MathMan.untripleBlockCoordZ(index);
            onEach.run(x, y, z, VISUALIZE_BLOCK.getInternalId());
        }
        index = -1;
        while ((index = this.remove.nextSetBit(index + 1)) != -1) {
            x = MathMan.untripleBlockCoordX(index);
            y = MathMan.untripleBlockCoordY(index);
            z = MathMan.untripleBlockCoordZ(index);
            onEach.run(x, y, z, 1);
        }
    }

    @Override
    public byte[] getBiomeArray() {
        return new byte[256];
    }

    @Override
    public FaweChunk getChunk() {
        return this;
    }

    @Override
    public void setTile(int x, int y, int z, CompoundTag tile) {
    }

    @Override
    public void setEntity(CompoundTag entity) {
    }

    @Override
    public void removeEntity(UUID uuid) {
    }

    @Override
    public void setBlock(int x, int y, int z, int combinedId) {
        int index = this.getIndex(x, y, z);
        try {
            switch (BlockTypes.getFromStateId(combinedId)) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    this.add.clear(index);
                    this.remove.set(index);
                    break;
                }
                default: {
                    this.remove.clear(index);
                    this.add.set(index);
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void unset(int x, int y, int z) {
        int index = this.getIndex(x, y, z);
        this.remove.clear(index);
        this.add.clear(index);
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return new HashSet<CompoundTag>();
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return new HashSet<UUID>();
    }

    @Override
    public Map<Short, CompoundTag> getTiles() {
        return new HashMap<Short, CompoundTag>();
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        return null;
    }

    @Override
    public void setBiome(int x, int z, byte biome) {
    }

    @Override
    public FaweChunk copy(boolean shallow) {
        if (shallow) {
            return new VisualChunk(this.getX(), this.getZ(), this.add, this.remove);
        }
        return new VisualChunk(this.getX(), this.getZ(), this.add.clone(), this.remove.clone());
    }

    @Override
    public FaweChunk call() {
        return this;
    }
}

