/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FaweOutputStream
extends DataOutputStream {
    private final OutputStream parent;
    private NBTOutputStream nbtOut;

    public FaweOutputStream(OutputStream parent) {
        super(parent);
        this.parent = parent;
    }

    public OutputStream getParent() {
        return this.parent;
    }

    public void write(int b, int amount) throws IOException {
        for (int i = 0; i < amount; ++i) {
            this.write(b);
        }
    }

    public void writeShort(short s) throws IOException {
        this.write((byte)(s >>> 8));
        this.write((byte)s);
    }

    public void writeMedium(int m) throws IOException {
        this.write((byte)(m >>> 16));
        this.write((byte)(m >>> 8));
        this.write((byte)m);
    }

    public void writeVarInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte(i & 0x7F | 0x80);
            i >>>= 7;
        }
        this.writeByte(i);
    }

    public void write(long[] data) throws IOException {
        this.writeVarInt(data.length);
        for (int j = 0; j < data.length; ++j) {
            this.writeLong(data[j]);
        }
    }

    public void writeNBT(String name, Tag tag) throws IOException {
        if (this.nbtOut == null) {
            this.nbtOut = new NBTOutputStream(this.parent);
        }
        this.nbtOut.writeNamedTag(name, tag);
    }

    public void writePrimitive(Object value) throws IOException {
        Class<?> clazz = value.getClass();
        if (clazz == Long.TYPE || clazz == Long.class) {
            this.writeLong((Long)value);
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            this.writeDouble((Double)value);
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            this.writeFloat(((Float)value).floatValue());
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            this.writeInt((Integer)value);
        } else if (clazz == Short.TYPE || clazz == Short.class) {
            this.writeShort((Short)value);
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            this.writeChar(((Character)value).charValue());
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            this.writeByte(((Byte)value).byteValue());
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            this.writeBoolean((Boolean)value);
        } else {
            throw new UnsupportedOperationException("Unknown class " + clazz);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.nbtOut != null) {
            this.nbtOut.close();
        }
        this.parent.close();
    }
}

