/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.jnbt.anvil.MCAFilter;
import com.boydti.fawe.jnbt.anvil.MutableMCABackedBaseBlock;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.io.FastByteArrayOutputStream;
import com.boydti.fawe.object.number.MutableLong;
import com.boydti.fawe.util.ArrayUtil;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;

public class MCAChunk
extends FaweChunk<Void> {
    public byte[][] ids;
    public byte[][] data;
    public byte[][] skyLight;
    public byte[][] blockLight;
    public byte[] biomes;
    public Map<Short, CompoundTag> tiles = new HashMap<Short, CompoundTag>();
    public Map<UUID, CompoundTag> entities = new HashMap<UUID, CompoundTag>();
    private long inhabitedTime;
    private long lastUpdate;
    private int[] heightMap;
    private int modified;
    private boolean deleted;

    public MCAChunk(FaweQueue queue, int x, int z) {
        super(queue, x, z);
        this.ids = new byte[16][];
        this.data = new byte[16][];
        this.skyLight = new byte[16][];
        this.blockLight = new byte[16][];
        this.biomes = new byte[256];
        this.tiles = new HashMap<Short, CompoundTag>();
        this.entities = new HashMap<UUID, CompoundTag>();
        this.lastUpdate = System.currentTimeMillis();
        this.heightMap = new int[256];
        this.setModified();
    }

    public MCAChunk(MCAChunk parent, boolean shallow) {
        super(parent.getParent(), parent.getX(), parent.getZ());
        if (shallow) {
            this.ids = parent.ids;
            this.data = parent.data;
            this.skyLight = parent.skyLight;
            this.blockLight = parent.blockLight;
            this.biomes = parent.biomes;
            this.tiles = parent.tiles;
            this.entities = parent.entities;
            this.inhabitedTime = parent.inhabitedTime;
            this.lastUpdate = parent.lastUpdate;
            this.heightMap = parent.heightMap;
            this.modified = parent.modified;
            this.deleted = parent.deleted;
        } else {
            this.ids = (byte[][])MainUtil.copyNd(parent.ids);
            this.data = (byte[][])MainUtil.copyNd(parent.data);
            this.skyLight = (byte[][])MainUtil.copyNd(parent.skyLight);
            this.blockLight = (byte[][])MainUtil.copyNd(parent.blockLight);
            this.biomes = (byte[])parent.biomes.clone();
            this.tiles = new HashMap<Short, CompoundTag>(parent.tiles);
            this.entities = new HashMap<UUID, CompoundTag>(parent.entities);
            this.inhabitedTime = parent.inhabitedTime;
            this.lastUpdate = parent.lastUpdate;
            this.heightMap = (int[])parent.heightMap.clone();
            this.modified = parent.modified;
            this.deleted = parent.deleted;
        }
    }

    public void write(final NBTOutputStream nbtOut) throws IOException {
        nbtOut.writeNamedTagName("", 10);
        nbtOut.writeLazyCompoundTag("Level", new NBTOutputStream.LazyWrite(){

            @Override
            public void write(NBTOutputStream out) throws IOException {
                int layer;
                out.writeNamedTag("V", (byte)1);
                out.writeNamedTag("xPos", MCAChunk.this.getX());
                out.writeNamedTag("zPos", MCAChunk.this.getZ());
                out.writeNamedTag("LightPopulated", (byte)0);
                out.writeNamedTag("TerrainPopulated", (byte)1);
                if (MCAChunk.this.entities.isEmpty()) {
                    out.writeNamedEmptyList("Entities");
                } else {
                    out.writeNamedTag("Entities", new ListTag<CompoundTag>(CompoundTag.class, new ArrayList<CompoundTag>(MCAChunk.this.entities.values())));
                }
                if (MCAChunk.this.tiles.isEmpty()) {
                    out.writeNamedEmptyList("TileEntities");
                } else {
                    out.writeNamedTag("TileEntities", new ListTag<CompoundTag>(CompoundTag.class, new ArrayList<CompoundTag>(MCAChunk.this.tiles.values())));
                }
                out.writeNamedTag("InhabitedTime", MCAChunk.this.inhabitedTime);
                out.writeNamedTag("LastUpdate", MCAChunk.this.lastUpdate);
                if (MCAChunk.this.biomes != null) {
                    out.writeNamedTag("Biomes", MCAChunk.this.biomes);
                }
                out.writeNamedTag("HeightMap", MCAChunk.this.heightMap);
                out.writeNamedTagName("Sections", 9);
                nbtOut.getOutputStream().writeByte(10);
                int len = 0;
                for (layer = 0; layer < MCAChunk.this.ids.length; ++layer) {
                    if (MCAChunk.this.ids[layer] == null) continue;
                    ++len;
                }
                nbtOut.getOutputStream().writeInt(len);
                for (layer = 0; layer < MCAChunk.this.ids.length; ++layer) {
                    byte[] idLayer = MCAChunk.this.ids[layer];
                    if (idLayer == null) continue;
                    out.writeNamedTag("Y", (byte)layer);
                    out.writeNamedTag("BlockLight", MCAChunk.this.blockLight[layer]);
                    out.writeNamedTag("SkyLight", MCAChunk.this.skyLight[layer]);
                    out.writeNamedTag("Blocks", idLayer);
                    out.writeNamedTag("Data", MCAChunk.this.data[layer]);
                    out.writeEndTag();
                }
            }
        });
        nbtOut.writeEndTag();
    }

    public byte[] toBytes(byte[] buffer) throws IOException {
        if (buffer == null) {
            buffer = new byte[8192];
        }
        FastByteArrayOutputStream buffered = new FastByteArrayOutputStream(buffer);
        DataOutputStream dataOut = new DataOutputStream(buffered);
        try (NBTOutputStream nbtOut = new NBTOutputStream(dataOut);){
            this.write(nbtOut);
        }
        return buffered.toByteArray();
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setInhabitedTime(long inhabitedTime) {
        this.inhabitedTime = inhabitedTime;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void copyFrom(MCAChunk other, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, int offsetX, int offsetY, int offsetZ) {
        minY = Math.max(-offsetY - minY, minY);
        maxY = Math.min(255 - offsetY, maxY);
        minZ = Math.max(-offsetZ - minZ, minZ);
        maxZ = Math.min(15 - offsetZ, maxZ);
        if ((minX = Math.max(-offsetX - minX, minX)) > (maxX = Math.min(15 - offsetX, maxX)) || minZ > maxZ || minY > maxY) {
            return;
        }
        int startLayer = minY >> 4;
        int endLayer = maxY >> 4;
        int otherY = minY;
        int thisY = minY + offsetY;
        while (otherY <= maxY) {
            int indexY;
            int thisLayer = thisY >> 4;
            int otherLayer = otherY >> 4;
            byte[] thisIds = this.ids[thisLayer];
            byte[] otherIds = other.ids[otherLayer];
            if (otherIds == null) {
                if (thisIds != null) {
                    indexY = (thisY & 0xF) << 8;
                    byte[] thisData = this.data[thisLayer];
                    byte[] thisSkyLight = this.skyLight[thisLayer];
                    byte[] thisBlockLight = this.blockLight[thisLayer];
                    int otherZ = minZ;
                    int thisZ = minZ + offsetZ;
                    while (otherZ <= maxZ) {
                        int startIndex = indexY + (thisZ << 4) + minX + offsetX;
                        int endIndex = startIndex + maxX - minX;
                        ArrayUtil.fill(thisIds, startIndex, endIndex + 1, (byte)0);
                        int startIndexShift = startIndex >> 1;
                        int endIndexShift = endIndex >> 1;
                        if ((startIndex & 1) != 0) {
                            ++startIndexShift;
                            this.setNibble(startIndex, thisData, 0);
                            this.setNibble(startIndex, thisSkyLight, 0);
                            this.setNibble(startIndex, thisBlockLight, 0);
                        }
                        if ((endIndex & 1) != 1) {
                            --endIndexShift;
                            this.setNibble(endIndex, thisData, 0);
                            this.setNibble(endIndex, thisSkyLight, 0);
                            this.setNibble(endIndex, thisBlockLight, 0);
                        }
                        ArrayUtil.fill(thisData, startIndexShift, endIndexShift + 1, (byte)0);
                        ArrayUtil.fill(thisSkyLight, startIndexShift, endIndexShift + 1, (byte)0);
                        ArrayUtil.fill(thisBlockLight, startIndexShift, endIndexShift + 1, (byte)0);
                        ++otherZ;
                        ++thisZ;
                    }
                }
            } else {
                if (thisIds == null) {
                    thisIds = new byte[4096];
                    this.ids[thisLayer] = thisIds;
                    this.data[thisLayer] = new byte[2048];
                    this.skyLight[thisLayer] = new byte[2048];
                    this.blockLight[thisLayer] = new byte[2048];
                }
                indexY = (thisY & 0xF) << 8;
                int otherIndexY = (otherY & 0xF) << 8;
                byte[] thisData = this.data[thisLayer];
                byte[] thisSkyLight = this.skyLight[thisLayer];
                byte[] thisBlockLight = this.blockLight[thisLayer];
                byte[] otherData = other.data[otherLayer];
                byte[] otherSkyLight = other.skyLight[otherLayer];
                byte[] otherBlockLight = other.blockLight[otherLayer];
                int otherZ = minZ;
                int thisZ = minZ + offsetZ;
                while (otherZ <= maxZ) {
                    int startIndex = indexY + (thisZ << 4) + minX + offsetX;
                    int endIndex = startIndex + maxX - minX;
                    int otherStartIndex = otherIndexY + (otherZ << 4) + minX;
                    int otherEndIndex = otherStartIndex + maxX - minX;
                    System.arraycopy(otherIds, otherStartIndex, thisIds, startIndex, endIndex - startIndex + 1);
                    if ((startIndex & 1) == (otherStartIndex & 1)) {
                        int startIndexShift = startIndex >> 1;
                        int endIndexShift = endIndex >> 1;
                        int otherStartIndexShift = otherStartIndex >> 1;
                        int otherEndIndexShift = otherEndIndex >> 1;
                        if ((startIndex & 1) != 0) {
                            ++startIndexShift;
                            ++otherStartIndexShift;
                            this.setNibble(startIndex, thisData, this.getNibble(otherStartIndex, otherData));
                            this.setNibble(startIndex, thisSkyLight, this.getNibble(otherStartIndex, otherSkyLight));
                            this.setNibble(startIndex, thisBlockLight, this.getNibble(otherStartIndex, otherBlockLight));
                        }
                        if ((endIndex & 1) != 1) {
                            --endIndexShift;
                            --otherEndIndexShift;
                            this.setNibble(endIndex, thisData, this.getNibble(otherEndIndex, otherData));
                            this.setNibble(endIndex, thisSkyLight, this.getNibble(otherEndIndex, otherSkyLight));
                            this.setNibble(endIndex, thisBlockLight, this.getNibble(otherEndIndex, otherBlockLight));
                        }
                        System.arraycopy(otherData, otherStartIndexShift, thisData, startIndexShift, endIndexShift - startIndexShift + 1);
                        System.arraycopy(otherSkyLight, otherStartIndexShift, thisSkyLight, startIndexShift, endIndexShift - startIndexShift + 1);
                        System.arraycopy(otherBlockLight, otherStartIndexShift, thisBlockLight, startIndexShift, endIndexShift - startIndexShift + 1);
                    } else {
                        int thisIndex = startIndex;
                        int otherIndex = otherStartIndex;
                        while (thisIndex <= endIndex) {
                            this.setNibble(thisIndex, thisData, this.getNibble(otherIndex, otherData));
                            this.setNibble(thisIndex, thisSkyLight, this.getNibble(otherIndex, otherSkyLight));
                            this.setNibble(thisIndex, thisBlockLight, this.getNibble(otherIndex, otherBlockLight));
                            ++thisIndex;
                            ++otherIndex;
                        }
                    }
                    ++otherZ;
                    ++thisZ;
                }
            }
            ++otherY;
            ++thisY;
        }
        if (!other.tiles.isEmpty()) {
            for (Map.Entry<Short, CompoundTag> entry : other.tiles.entrySet()) {
                short key = entry.getKey();
                int x = MathMan.untripleBlockCoordX(key);
                int y = MathMan.untripleBlockCoordY(key);
                int z = MathMan.untripleBlockCoordZ(key);
                if (x < minX || x > maxX || z < minZ || z > maxZ || y < minY || y > maxY) continue;
                short pair = MathMan.tripleBlockCoord(x += offsetX, y += offsetY, z += offsetZ);
                CompoundTag tag = entry.getValue();
                Map map = ReflectionUtils.getMap(tag.getValue());
                map.put("x", new IntTag((x & 0xF) + (this.getX() << 4)));
                map.put("y", new IntTag(y));
                map.put("z", new IntTag((z & 0xF) + (this.getZ() << 4)));
                this.tiles.put(pair, tag);
            }
        }
    }

    public void copyFrom(MCAChunk other, int minY, int maxY, int offsetY) {
        byte[] otherIds;
        int thisLayer;
        if ((minY = Math.max(-offsetY - minY, minY)) > (maxY = Math.min(255 - offsetY, maxY))) {
            return;
        }
        if ((offsetY & 0xF) == 0) {
            int offsetLayer = offsetY >> 4;
            int startLayer = minY >> 4;
            int endLayer = maxY >> 4;
            thisLayer = startLayer + offsetLayer;
            int otherLayer = startLayer;
            while (thisLayer <= endLayer) {
                otherIds = other.ids[otherLayer];
                byte[] currentIds = this.ids[thisLayer];
                int by = otherLayer << 4;
                int ty = by + 15;
                if (by >= minY && ty <= maxY) {
                    if (otherIds != null) {
                        this.ids[thisLayer] = otherIds;
                        this.data[thisLayer] = other.data[otherLayer];
                        this.skyLight[thisLayer] = other.skyLight[otherLayer];
                        this.blockLight[thisLayer] = other.blockLight[otherLayer];
                    } else {
                        this.ids[thisLayer] = null;
                    }
                } else {
                    by = Math.max(by, minY) & 0xF;
                    ty = Math.min(ty, maxY) & 0xF;
                    int indexStart = by << 8;
                    int indexEnd = 256 + (ty << 8);
                    int indexStartShift = indexStart >> 1;
                    int indexEndShift = indexEnd >> 1;
                    if (otherIds == null) {
                        if (currentIds != null) {
                            ArrayUtil.fill(currentIds, indexStart, indexEnd, (byte)0);
                            ArrayUtil.fill(this.data[thisLayer], indexStartShift, indexEndShift, (byte)0);
                            ArrayUtil.fill(this.skyLight[thisLayer], indexStartShift, indexEndShift, (byte)0);
                            ArrayUtil.fill(this.blockLight[thisLayer], indexStartShift, indexEndShift, (byte)0);
                        }
                    } else {
                        if (currentIds == null) {
                            this.ids[thisLayer] = new byte[4096];
                            currentIds = this.ids[thisLayer];
                            this.data[thisLayer] = new byte[2048];
                            this.skyLight[thisLayer] = new byte[2048];
                            this.blockLight[thisLayer] = new byte[2048];
                        }
                        System.arraycopy(other.ids[otherLayer], indexStart, currentIds, indexStart, indexEnd - indexStart);
                        System.arraycopy(other.data[otherLayer], indexStartShift, this.data[thisLayer], indexStartShift, indexEndShift - indexStartShift);
                        System.arraycopy(other.skyLight[otherLayer], indexStartShift, this.skyLight[thisLayer], indexStartShift, indexEndShift - indexStartShift);
                        System.arraycopy(other.blockLight[otherLayer], indexStartShift, this.blockLight[thisLayer], indexStartShift, indexEndShift - indexStartShift);
                    }
                }
                ++thisLayer;
                ++otherLayer;
            }
        } else {
            int otherY = minY;
            int thisY = minY + offsetY;
            while (otherY <= maxY) {
                int otherLayer = otherY >> 4;
                thisLayer = thisY >> 4;
                byte[] thisIds = this.ids[thisLayer];
                otherIds = other.ids[otherLayer];
                int thisStartIndex = (thisY & 0xF) << 8;
                int thisStartIndexShift = thisStartIndex >> 1;
                if (otherIds == null) {
                    if (thisIds != null) {
                        ArrayUtil.fill(thisIds, thisStartIndex, thisStartIndex + 256, (byte)0);
                        ArrayUtil.fill(this.data[thisLayer], thisStartIndexShift, thisStartIndexShift + 128, (byte)0);
                        ArrayUtil.fill(this.skyLight[thisLayer], thisStartIndexShift, thisStartIndexShift + 128, (byte)0);
                        ArrayUtil.fill(this.blockLight[thisLayer], thisStartIndexShift, thisStartIndexShift + 128, (byte)0);
                    }
                } else {
                    if (thisIds == null) {
                        thisIds = new byte[4096];
                        this.ids[thisLayer] = thisIds;
                        this.data[thisLayer] = new byte[2048];
                        this.skyLight[thisLayer] = new byte[2048];
                        this.blockLight[thisLayer] = new byte[2048];
                    }
                    int otherStartIndex = (otherY & 0xF) << 8;
                    int otherStartIndexShift = otherStartIndex >> 1;
                    System.arraycopy(other.ids[otherLayer], otherStartIndex, thisIds, thisStartIndex, 256);
                    System.arraycopy(other.data[otherLayer], otherStartIndexShift, this.data[thisLayer], thisStartIndexShift, 128);
                    System.arraycopy(other.skyLight[otherLayer], otherStartIndexShift, this.skyLight[thisLayer], thisStartIndexShift, 128);
                    System.arraycopy(other.blockLight[otherLayer], otherStartIndexShift, this.blockLight[thisLayer], thisStartIndexShift, 128);
                }
                ++otherY;
                ++thisY;
            }
        }
        int thisMinY = minY + offsetY;
        int thisMaxY = maxY + offsetY;
        if (!this.tiles.isEmpty()) {
            Iterator<Map.Entry<Short, CompoundTag>> iter = this.tiles.entrySet().iterator();
            while (iter.hasNext()) {
                int y = MathMan.untripleBlockCoordY(iter.next().getKey().shortValue());
                if (y < thisMinY || y > thisMaxY) continue;
                iter.remove();
            }
        }
        if (!other.tiles.isEmpty()) {
            for (Map.Entry<Short, CompoundTag> entry : other.tiles.entrySet()) {
                short key = entry.getKey();
                int y = MathMan.untripleBlockCoordY(key);
                if (y < minY || y > maxY) continue;
                this.tiles.put((short)(key + offsetY), entry.getValue());
            }
        }
        if (!other.entities.isEmpty()) {
            for (Map.Entry<UUID, CompoundTag> entry : other.entities.entrySet()) {
            }
        }
    }

    public int getMinLayer() {
        for (int layer = 0; layer < this.ids.length; ++layer) {
            if (this.ids[layer] == null) continue;
            return layer;
        }
        return Integer.MAX_VALUE;
    }

    public int getMaxLayer() {
        for (int layer = this.ids.length - 1; layer >= 0; --layer) {
            if (this.ids[layer] == null) continue;
            return layer;
        }
        return Integer.MIN_VALUE;
    }

    @Deprecated
    public CompoundTag toTag() {
        if (this.deleted) {
            return null;
        }
        HashMap<String, Object> level = new HashMap<String, Object>();
        level.put("Entities", new ListTag<CompoundTag>(CompoundTag.class, new ArrayList<CompoundTag>(this.entities.values())));
        level.put("TileEntities", new ListTag<CompoundTag>(CompoundTag.class, new ArrayList<CompoundTag>(this.tiles.values())));
        level.put("InhabitedTime", this.inhabitedTime);
        level.put("LastUpdate", this.lastUpdate);
        level.put("LightPopulated", (byte)0);
        level.put("TerrainPopulated", (byte)1);
        level.put("V", (byte)1);
        level.put("xPos", this.getX());
        level.put("zPos", this.getZ());
        if (this.biomes != null) {
            level.put("Biomes", this.biomes);
        }
        level.put("HeightMap", this.heightMap);
        ArrayList sections = new ArrayList();
        for (int layer = 0; layer < this.ids.length; ++layer) {
            byte[] idLayer = this.ids[layer];
            if (idLayer == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Y", (byte)layer);
            map.put("BlockLight", this.blockLight[layer]);
            map.put("SkyLight", this.skyLight[layer]);
            map.put("Blocks", idLayer);
            map.put("Data", this.data[layer]);
            sections.add(map);
        }
        level.put("Sections", sections);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("Level", level);
        return FaweCache.asTag(root);
    }

    public MCAChunk(NBTInputStream nis, FaweQueue parent, int x, int z, boolean readPos) throws IOException {
        super(parent, x, z);
        this.ids = new byte[16][];
        this.data = new byte[16][];
        this.skyLight = new byte[16][];
        this.blockLight = new byte[16][];
        NBTStreamer streamer = new NBTStreamer(nis);
        streamer.addReader(".Level.InhabitedTime", new BiConsumer<Integer, Long>(){

            @Override
            public void accept(Integer index, Long value) {
                MCAChunk.this.inhabitedTime = value;
            }
        });
        streamer.addReader(".Level.LastUpdate", new BiConsumer<Integer, Long>(){

            @Override
            public void accept(Integer index, Long value) {
                MCAChunk.this.lastUpdate = value;
            }
        });
        streamer.addReader(".Level.Sections.#", new BiConsumer<Integer, CompoundTag>(){

            @Override
            public void accept(Integer index, CompoundTag tag) {
                byte layer = tag.getByte("Y");
                MCAChunk.this.ids[layer] = tag.getByteArray("Blocks");
                MCAChunk.this.data[layer] = tag.getByteArray("Data");
                MCAChunk.this.skyLight[layer] = tag.getByteArray("SkyLight");
                MCAChunk.this.blockLight[layer] = tag.getByteArray("BlockLight");
            }
        });
        streamer.addReader(".Level.TileEntities.#", new BiConsumer<Integer, CompoundTag>(){

            @Override
            public void accept(Integer index, CompoundTag tile) {
                int x = tile.getInt("x") & 0xF;
                int y = tile.getInt("y");
                int z = tile.getInt("z") & 0xF;
                short pair = MathMan.tripleBlockCoord(x, y, z);
                MCAChunk.this.tiles.put(pair, tile);
            }
        });
        streamer.addReader(".Level.Entities.#", new BiConsumer<Integer, CompoundTag>(){

            @Override
            public void accept(Integer index, CompoundTag entityTag) {
                if (MCAChunk.this.entities == null) {
                    MCAChunk.this.entities = new HashMap<UUID, CompoundTag>();
                }
                long least = entityTag.getLong("UUIDLeast");
                long most = entityTag.getLong("UUIDMost");
                MCAChunk.this.entities.put(new UUID(most, least), entityTag);
            }
        });
        streamer.addReader(".Level.Biomes", new BiConsumer<Integer, byte[]>(){

            @Override
            public void accept(Integer index, byte[] value) {
                MCAChunk.this.biomes = value;
            }
        });
        streamer.addReader(".Level.HeightMap", new BiConsumer<Integer, int[]>(){

            @Override
            public void accept(Integer index, int[] value) {
                MCAChunk.access$202(MCAChunk.this, value);
            }
        });
        if (readPos) {
            streamer.addReader(".Level.xPos", new BiConsumer<Integer, Integer>(){

                @Override
                public void accept(Integer index, Integer value) {
                    MCAChunk.this.setLoc(MCAChunk.this.getParent(), value, MCAChunk.this.getZ());
                }
            });
            streamer.addReader(".Level.zPos", new BiConsumer<Integer, Integer>(){

                @Override
                public void accept(Integer index, Integer value) {
                    MCAChunk.this.setLoc(MCAChunk.this.getParent(), MCAChunk.this.getX(), value);
                }
            });
        }
        streamer.readFully();
    }

    public long filterBlocks(MutableMCABackedBaseBlock mutableBlock, MCAFilter filter) {
        MutableLong result = new MutableLong();
        mutableBlock.setChunk(this);
        int bx = this.getX() << 4;
        int bz = this.getZ() << 4;
        int tx = bx + 15;
        int tz = bz + 15;
        for (int layer = 0; layer < this.ids.length; ++layer) {
            if (!this.doesSectionExist(layer)) continue;
            mutableBlock.setArrays(layer);
            int yStart = layer << 4;
            int yEnd = yStart + 15;
            int y = yStart;
            int y0 = yStart & 0xF;
            while (y <= yEnd) {
                int yIndex = y0 << 8;
                mutableBlock.setY(y);
                int z = bz;
                int z0 = bz & 0xF;
                while (z <= tz) {
                    int zIndex = yIndex + (z0 << 4);
                    mutableBlock.setZ(z);
                    int x = bx;
                    int x0 = bx & 0xF;
                    while (x <= tx) {
                        int xIndex = zIndex + x0;
                        mutableBlock.setX(x);
                        mutableBlock.setIndex(xIndex);
                        filter.applyBlock(x, y, z, mutableBlock, result);
                        ++x;
                        ++x0;
                    }
                    ++z;
                    ++z0;
                }
                ++y;
                ++y0;
            }
        }
        return result.get();
    }

    public int[] getHeightMapArray() {
        return this.heightMap;
    }

    public void setDeleted(boolean deleted) {
        this.setModified();
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isModified() {
        return this.modified != 0;
    }

    public int getModified() {
        return this.modified;
    }

    @Deprecated
    public final void setModified() {
        ++this.modified;
    }

    @Override
    public int getBitMask() {
        int bitMask = 0;
        for (int section = 0; section < this.ids.length; ++section) {
            if (this.ids[section] == null) continue;
            bitMask += 1 << section;
        }
        return bitMask;
    }

    @Override
    public void setTile(int x, int y, int z, CompoundTag tile) {
        this.setModified();
        short pair = MathMan.tripleBlockCoord(x, y, z);
        if (tile != null) {
            this.tiles.put(pair, tile);
        } else {
            this.tiles.remove(pair);
        }
    }

    @Override
    public void setEntity(CompoundTag entityTag) {
        this.setModified();
        long least = entityTag.getLong("UUIDLeast");
        long most = entityTag.getLong("UUIDMost");
        this.entities.put(new UUID(most, least), entityTag);
    }

    @Override
    public void setBiome(int x, int z, byte biome) {
        this.setModified();
        this.biomes[x + (z << 4)] = biome;
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return new HashSet<CompoundTag>(this.entities.values());
    }

    @Override
    public Map<Short, CompoundTag> getTiles() {
        return this.tiles == null ? new HashMap() : this.tiles;
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        if (this.tiles == null || this.tiles.isEmpty()) {
            return null;
        }
        short pair = MathMan.tripleBlockCoord(x, y, z);
        return this.tiles.get(pair);
    }

    public boolean doesSectionExist(int cy) {
        return this.ids[cy] != null;
    }

    @Override
    public FaweChunk<Void> copy(boolean shallow) {
        return new MCAChunk(this, shallow);
    }

    @Override
    public int getBlockCombinedId(int x, int y, int z) {
        return 0;
    }

    @Override
    public byte[] getBiomeArray() {
        return this.biomes;
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        return new HashSet<UUID>();
    }

    public void setSkyLight(int x, int y, int z, int value) {
        this.setModified();
        int layer = y >> 4;
        byte[] skyLayer = this.skyLight[layer];
        if (skyLayer == null) {
            return;
        }
        short index = FaweCache.CACHE_J[y][z & 0xF][x & 0xF];
        this.setNibble(index, skyLayer, value);
    }

    public void setBlockLight(int x, int y, int z, int value) {
        this.setModified();
        int layer = y >> 4;
        byte[] blockLayer = this.blockLight[layer];
        if (blockLayer == null) {
            return;
        }
        short index = FaweCache.CACHE_J[y][z & 0xF][x & 0xF];
        this.setNibble(index, blockLayer, value);
    }

    public int getSkyLight(int x, int y, int z) {
        int layer = y >> 4;
        byte[] skyLayer = this.skyLight[layer];
        if (skyLayer == null) {
            return 0;
        }
        short index = FaweCache.CACHE_J[y][z & 0xF][x & 0xF];
        return this.getNibble(index, skyLayer);
    }

    public int getBlockLight(int x, int y, int z) {
        int layer = y >> 4;
        byte[] blockLayer = this.blockLight[layer];
        if (blockLayer == null) {
            return 0;
        }
        short index = FaweCache.CACHE_J[y][z & 0xF][x & 0xF];
        return this.getNibble(index, blockLayer);
    }

    public void setFullbright() {
        this.setModified();
        for (byte[] array : this.skyLight) {
            if (array == null) continue;
            Arrays.fill(array, (byte)-1);
        }
    }

    public void removeLight() {
        for (int i = 0; i < this.skyLight.length; ++i) {
            this.removeLight(i);
        }
    }

    public void removeLight(int i) {
        byte[] array1 = this.skyLight[i];
        if (array1 == null) {
            return;
        }
        byte[] array2 = this.blockLight[i];
        Arrays.fill(array1, (byte)0);
        Arrays.fill(array2, (byte)0);
    }

    public int getNibble(int index, byte[] array) {
        int indexShift = index >> 1;
        if ((index & 1) == 0) {
            return array[indexShift] & 0xF;
        }
        return array[indexShift] >> 4 & 0xF;
    }

    public void setNibble(int index, byte[] array, int value) {
        int indexShift = index >> 1;
        byte existing = array[indexShift];
        int valueShift = value << 4;
        if (existing == value + valueShift) {
            return;
        }
        array[indexShift] = (index & 1) == 0 ? (byte)(existing & 0xF0 | value) : (byte)(existing & 0xF | valueShift);
    }

    public void setIdUnsafe(byte[] idsLayer, int index, byte id) {
        idsLayer[index] = id;
    }

    public void setBlockUnsafe(byte[] idsLayer, byte[] dataLayer, int index, byte id, int data) {
        idsLayer[index] = id;
        this.setNibble(index, dataLayer, data);
    }

    @Override
    public void setBlock(int x, int y, int z, int combinedId) {
    }

    @Override
    public void setBiome(byte biome) {
        Arrays.fill(this.biomes, biome);
    }

    @Override
    public void removeEntity(UUID uuid) {
        this.setModified();
        this.entities.remove(uuid);
    }

    private final boolean idsEqual(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        for (int i = 0; i < 4096; i = (int)((char)(i + 1))) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private final boolean idsEqual(byte[][] a, byte[][] b, boolean matchNullToAir) {
        int i;
        for (i = 0; i < 16; i = (int)((byte)(i + 1))) {
            if (a[i] == null == (b[i] == null)) continue;
            if (matchNullToAir) {
                if (b[i] != null) {
                    for (byte c : b[i]) {
                        if (c == 0) continue;
                        return false;
                    }
                } else if (a[i] != null) {
                    for (byte c : a[i]) {
                        if (c == 0) continue;
                        return false;
                    }
                }
            }
            return false;
        }
        for (i = 4; i < 8; i = (int)((byte)(i + 1))) {
            if (this.idsEqual(a[i], b[i])) continue;
            return false;
        }
        for (i = 3; i >= 0; i = (int)((byte)(i - 1))) {
            if (this.idsEqual(a[i], b[i])) continue;
            return false;
        }
        for (i = 8; i < 16; i = (int)((byte)(i + 1))) {
            if (this.idsEqual(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public boolean idsEqual(MCAChunk other, boolean matchNullToAir) {
        return this.idsEqual(other.ids, this.ids, matchNullToAir);
    }

    @Override
    public Void getChunk() {
        throw new UnsupportedOperationException("Not applicable for this");
    }

    @Override
    public FaweChunk call() {
        throw new UnsupportedOperationException("Not supported");
    }

    static /* synthetic */ int[] access$202(MCAChunk x0, int[] x1) {
        x0.heightMap = x1;
        return x1;
    }
}

