/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.example;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.DefaultFaweQueueMap;
import com.boydti.fawe.example.IFaweQueueMap;
import com.boydti.fawe.example.WeakFaweQueueMap;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.IntegerPair;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.RunnableVal2;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.extent.LightingExtent;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;

public abstract class MappedFaweQueue<WORLD, CHUNK, CHUNKSECTIONS, SECTION>
implements LightingExtent,
FaweQueue {
    private WORLD impWorld;
    private IFaweQueueMap map;
    public int lastSectionX = Integer.MIN_VALUE;
    public int lastSectionZ = Integer.MIN_VALUE;
    public int lastSectionY = Integer.MIN_VALUE;
    public CHUNK lastChunk;
    public CHUNKSECTIONS lastChunkSections;
    public SECTION lastSection;
    private World weWorld;
    private String world;
    private ConcurrentLinkedDeque<EditSession> sessions;
    private long modified = System.currentTimeMillis();
    private RunnableVal2<FaweChunk, FaweChunk> changeTask;
    private RunnableVal2<FaweQueue.ProgressType, Integer> progressTask;
    private SetQueue.QueueStage stage;
    private Settings settings = Settings.IMP;
    public ConcurrentLinkedDeque<Runnable> tasks = new ConcurrentLinkedDeque();
    private CHUNK cachedLoadChunk;
    public final RunnableVal<IntegerPair> loadChunk = new RunnableVal<IntegerPair>(){
        {
            this.value = new IntegerPair(0, 0);
        }

        @Override
        public void run(IntegerPair coord) {
            MappedFaweQueue.this.cachedLoadChunk = MappedFaweQueue.this.loadChunk(MappedFaweQueue.this.getWorld(), coord.x, coord.z, true);
        }
    };

    public MappedFaweQueue(World world) {
        this(world, null);
    }

    public MappedFaweQueue(String world) {
        this.world = world;
        this.map = this.getSettings().PREVENT_CRASHES ? new WeakFaweQueueMap(this) : new DefaultFaweQueueMap(this);
    }

    public MappedFaweQueue(String world, IFaweQueueMap map) {
        this.world = world;
        if (map == null) {
            map = this.getSettings().PREVENT_CRASHES ? new WeakFaweQueueMap(this) : new DefaultFaweQueueMap(this);
        }
        this.map = map;
    }

    public MappedFaweQueue(World world, IFaweQueueMap map) {
        this.weWorld = world;
        if (world != null) {
            this.world = Fawe.imp().getWorldName(world);
        }
        if (map == null) {
            map = this.getSettings().PREVENT_CRASHES ? new WeakFaweQueueMap(this) : new DefaultFaweQueueMap(this);
        }
        this.map = map;
    }

    @Override
    public int getMaxY() {
        return this.weWorld == null ? 255 : this.weWorld.getMaxY();
    }

    public IFaweQueueMap getFaweQueueMap() {
        return this.map;
    }

    @Override
    public Collection<FaweChunk> getFaweChunks() {
        return this.map.getFaweCunks();
    }

    @Override
    public void optimize() {
        final ForkJoinPool pool = TaskManager.IMP.getPublicForkJoinPool();
        this.map.forEachChunk(new RunnableVal<FaweChunk>(){

            @Override
            public void run(final FaweChunk chunk) {
                pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        chunk.optimize();
                    }
                });
            }
        });
        pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public abstract WORLD getImpWorld();

    public abstract boolean regenerateChunk(WORLD var1, int var2, int var3, BaseBiome var4, Long var5);

    @Override
    public abstract FaweChunk getFaweChunk(int var1, int var2);

    public abstract CHUNK loadChunk(WORLD var1, int var2, int var3, boolean var4);

    public abstract CHUNKSECTIONS getSections(CHUNK var1);

    public abstract CHUNKSECTIONS getCachedSections(WORLD var1, int var2, int var3);

    public abstract CHUNK getCachedChunk(WORLD var1, int var2, int var3);

    public WORLD getWorld() {
        if (this.impWorld != null) {
            return this.impWorld;
        }
        this.impWorld = this.getImpWorld();
        return this.impWorld;
    }

    @Override
    public boolean regenerateChunk(int x, int z, BaseBiome biome, Long seed) {
        return this.regenerateChunk(this.getWorld(), x, z, biome, seed);
    }

    @Override
    public void addNotifyTask(int x, int z, Runnable runnable) {
        FaweChunk chunk = this.map.getFaweChunk(x, z);
        chunk.addNotifyTask(runnable);
    }

    @Override
    public boolean setBlock(int x, int y, int z, int id) {
        int cx = x >> 4;
        int cz = z >> 4;
        FaweChunk chunk = this.map.getFaweChunk(cx, cz);
        chunk.setBlock(x & 0xF, y, z & 0xF, id);
        return true;
    }

    @Override
    public void setTile(int x, int y, int z, CompoundTag tag) {
        if (y >= FaweChunk.HEIGHT || y < 0) {
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        FaweChunk chunk = this.map.getFaweChunk(cx, cz);
        chunk.setTile(x & 0xF, y, z & 0xF, tag);
    }

    @Override
    public void setEntity(int x, int y, int z, CompoundTag tag) {
        if (y >= FaweChunk.HEIGHT || y < 0) {
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        FaweChunk chunk = this.map.getFaweChunk(cx, cz);
        chunk.setEntity(tag);
    }

    @Override
    public void removeEntity(int x, int y, int z, UUID uuid) {
        if (y >= FaweChunk.HEIGHT || y < 0) {
            return;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        FaweChunk chunk = this.map.getFaweChunk(cx, cz);
        chunk.removeEntity(uuid);
    }

    @Override
    public boolean setBiome(int x, int z, BaseBiome biome) {
        int cx = x >> 4;
        int cz = z >> 4;
        FaweChunk chunk = this.map.getFaweChunk(cx, cz);
        chunk.setBiome(x & 0xF, z & 0xF, biome);
        return true;
    }

    @Override
    public boolean next(int amount, long time) {
        return this.map.next(amount, time);
    }

    public void start(FaweChunk chunk) {
        chunk.start();
    }

    public void end(FaweChunk chunk) {
        if (this.getProgressTask() != null) {
            this.getProgressTask().run(FaweQueue.ProgressType.DISPATCH, this.size() + 1);
        }
        chunk.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTasks() {
        MappedFaweQueue mappedFaweQueue = this;
        synchronized (mappedFaweQueue) {
            this.notifyAll();
        }
        if (this.getProgressTask() != null) {
            try {
                this.getProgressTask().run(FaweQueue.ProgressType.DONE, 1);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        while (!this.tasks.isEmpty()) {
            Runnable task = this.tasks.poll();
            if (task == null) continue;
            try {
                task.run();
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
        if (this.getProgressTask() != null) {
            try {
                this.getProgressTask().run(FaweQueue.ProgressType.DONE, 1);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        ArrayDeque<Runnable> tmp = new ArrayDeque<Runnable>(this.tasks);
        this.tasks.clear();
        for (Runnable run : tmp) {
            try {
                run.run();
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        }
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings == null ? Settings.IMP : settings;
    }

    @Override
    public void setWorld(String world) {
        this.world = world;
        this.weWorld = null;
    }

    @Override
    public World getWEWorld() {
        return this.weWorld != null ? this.weWorld : (this.weWorld = FaweAPI.getWorld(this.world));
    }

    @Override
    public String getWorldName() {
        return this.world;
    }

    @Override
    public Collection<EditSession> getEditSessions() {
        AbstractCollection tmp = this.sessions;
        if (tmp == null) {
            tmp = new HashSet();
        }
        return tmp;
    }

    @Override
    public void addEditSession(EditSession session) {
        ConcurrentLinkedDeque<EditSession> tmp = this.sessions;
        if (tmp == null) {
            tmp = new ConcurrentLinkedDeque();
        }
        tmp.add(session);
        this.sessions = tmp;
    }

    @Override
    public boolean supports(FaweQueue.Capability capability) {
        switch (capability) {
            case CHANGE_TASKS: {
                return true;
            }
        }
        return false;
    }

    public void setSessions(ConcurrentLinkedDeque<EditSession> sessions) {
        this.sessions = sessions;
    }

    @Override
    public long getModified() {
        return this.modified;
    }

    @Override
    public void setModified(long modified) {
        this.modified = modified;
    }

    @Override
    public RunnableVal2<FaweQueue.ProgressType, Integer> getProgressTask() {
        return this.progressTask;
    }

    @Override
    public void setProgressTask(RunnableVal2<FaweQueue.ProgressType, Integer> progressTask) {
        this.progressTask = progressTask;
    }

    @Override
    public void setChangeTask(RunnableVal2<FaweChunk, FaweChunk> changeTask) {
        this.changeTask = changeTask;
    }

    @Override
    public RunnableVal2<FaweChunk, FaweChunk> getChangeTask() {
        return this.changeTask;
    }

    @Override
    public SetQueue.QueueStage getStage() {
        return this.stage;
    }

    @Override
    public void setStage(SetQueue.QueueStage stage) {
        this.stage = stage;
    }

    @Override
    public void addNotifyTask(Runnable runnable) {
        this.tasks.add(runnable);
    }

    @Override
    public void addTask(Runnable whenFree) {
        this.tasks.add(whenFree);
    }

    @Override
    public int size() {
        int size = this.map.size();
        if (size == 0 && this.getStage() == SetQueue.QueueStage.NONE) {
            this.runTasks();
        }
        return size;
    }

    @Override
    public void clear() {
        this.lastSectionX = Integer.MIN_VALUE;
        this.lastSectionZ = Integer.MIN_VALUE;
        this.lastSectionY = -1;
        this.lastChunk = null;
        this.lastChunkSections = null;
        this.map.clear();
        this.runTasks();
    }

    @Override
    public void setChunk(FaweChunk chunk) {
        this.map.add(chunk);
    }

    public SECTION getCachedSection(CHUNKSECTIONS chunk, int cy) {
        return (SECTION)this.lastChunkSections;
    }

    public abstract int getCombinedId4Data(SECTION var1, int var2, int var3, int var4);

    public int getLocalCombinedId4Data(CHUNK chunk, int x, int y, int z) {
        CHUNKSECTIONS sections = this.getSections(this.lastChunk);
        SECTION section = this.getCachedSection(sections, y >> 4);
        if (section == null) {
            return BlockTypes.AIR.getInternalId();
        }
        return this.getCombinedId4Data(this.lastSection, x, y, z);
    }

    public abstract int getBiome(CHUNK var1, int var2, int var3);

    public abstract CompoundTag getTileEntity(CHUNK var1, int var2, int var3, int var4);

    public CHUNK ensureChunkLoaded(int cx, int cz) throws FaweException.FaweChunkLoadException {
        CHUNK chunk = this.getCachedChunk(this.getWorld(), cx, cz);
        if (chunk != null) {
            return chunk;
        }
        boolean sync = Fawe.isMainThread();
        if (sync) {
            return this.loadChunk(this.getWorld(), cx, cz, true);
        }
        if (this.getSettings().HISTORY.CHUNK_WAIT_MS > 0) {
            this.cachedLoadChunk = null;
            ((IntegerPair)this.loadChunk.value).x = cx;
            ((IntegerPair)this.loadChunk.value).z = cz;
            TaskManager.IMP.syncWhenFree(this.loadChunk, this.getSettings().HISTORY.CHUNK_WAIT_MS);
            return this.cachedLoadChunk;
        }
        return null;
    }

    public boolean queueChunkLoad(final int cx, final int cz) {
        CHUNK chunk = this.getCachedChunk(this.getWorld(), cx, cz);
        if (chunk == null) {
            SetQueue.IMP.addTask(new Runnable(){

                @Override
                public void run() {
                    MappedFaweQueue.this.loadChunk(MappedFaweQueue.this.getWorld(), cx, cz, true);
                }
            });
            return true;
        }
        return false;
    }

    public boolean queueChunkLoad(final int cx, final int cz, final RunnableVal<CHUNK> operation) {
        operation.value = this.getCachedChunk(this.getWorld(), cx, cz);
        if (operation.value == null) {
            SetQueue.IMP.addTask(new Runnable(){

                @Override
                public void run() {
                    operation.value = MappedFaweQueue.this.loadChunk(MappedFaweQueue.this.getWorld(), cx, cz, true);
                    if (operation.value != null) {
                        TaskManager.IMP.async(operation);
                    }
                }
            });
            return true;
        }
        TaskManager.IMP.async(operation);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasBlock(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return false;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return false;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return false;
        }
        return this.hasBlock(this.lastSection, x, y, z);
    }

    public boolean hasBlock(SECTION section, int x, int y, int z) {
        return this.getCombinedId4Data(this.lastSection, x, y, z) != 0;
    }

    public int getOpacity(SECTION section, int x, int y, int z) {
        int combined = this.getCombinedId4Data(section, x, y, z);
        if (combined == 0) {
            return 0;
        }
        return Math.min(15, BlockTypes.getFromStateId(combined).getMaterial().getLightOpacity());
    }

    public int getBrightness(SECTION section, int x, int y, int z) {
        int combined = this.getCombinedId4Data(section, x, y, z);
        if (combined == 0) {
            return 0;
        }
        return Math.min(15, BlockTypes.getFromStateId(combined).getMaterial().getLightValue());
    }

    public int getOpacityBrightnessPair(SECTION section, int x, int y, int z) {
        return MathMan.pair16(Math.min(15, this.getOpacity(section, x, y, z)), this.getBrightness(section, x, y, z));
    }

    public abstract int getSkyLight(SECTION var1, int var2, int var3, int var4);

    public abstract int getEmmittedLight(SECTION var1, int var2, int var3, int var4);

    public int getLight(SECTION sections, int x, int y, int z) {
        if (!this.hasSky()) {
            return this.getEmmittedLight(sections, x, y, z);
        }
        return Math.max(this.getSkyLight(sections, x, y, z), this.getEmmittedLight(sections, x, y, z));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getLight(int x, int y, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return 0;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return 0;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return 0;
        }
        return this.getLight(this.lastSection, x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getSkyLight(int x, int y, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return 0;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return 0;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            if (this.lastChunkSections == null) {
                return 0;
            }
            int max = FaweChunk.HEIGHT >> 4;
            do {
                if (++cy >= max) {
                    return 15;
                }
                this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
            } while (this.lastSection == null);
        }
        if (this.lastSection == null) {
            return this.getSkyLight(x, y + 16, z);
        }
        return this.getSkyLight(this.lastSection, x, y, z);
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.getEmmittedLight(x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getEmmittedLight(int x, int y, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return 0;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return 0;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return 0;
        }
        return this.getEmmittedLight(this.lastSection, x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getOpacity(int x, int y, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return 0;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return 0;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return 0;
        }
        return this.getOpacity(this.lastSection, x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getOpacityBrightnessPair(int x, int y, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return 0;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return 0;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return 0;
        }
        return this.getOpacityBrightnessPair(this.lastSection, x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getBrightness(int x, int y, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return 0;
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return 0;
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return 0;
        }
        return this.getBrightness(this.lastSection, x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getCachedCombinedId4Data(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        int combined;
        int cx = x >> 4;
        int cz = z >> 4;
        FaweChunk fc = this.map.getCachedFaweChunk(cx, cz);
        if (fc != null && (combined = fc.getBlockCombinedId(x & 0xF, y, z & 0xF)) != 0) {
            return combined;
        }
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return BlockTypes.AIR.getInternalId();
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return BlockTypes.AIR.getInternalId();
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return BlockTypes.AIR.getInternalId();
        }
        return this.getCombinedId4Data(this.lastSection, x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getCombinedId4Data(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        int cx = x >> 4;
        int cz = z >> 4;
        int cy = y >> 4;
        if (cx != this.lastSectionX || cz != this.lastSectionZ) {
            this.lastSectionX = cx;
            this.lastSectionZ = cz;
            this.lastChunk = this.ensureChunkLoaded(cx, cz);
            if (this.lastChunk == null) {
                this.lastChunkSections = null;
                return BlockTypes.AIR.getInternalId();
            }
            this.lastChunkSections = this.getSections(this.lastChunk);
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        } else if (cy != this.lastSectionY) {
            if (this.lastChunkSections == null) {
                return BlockTypes.AIR.getInternalId();
            }
            this.lastSection = this.getCachedSection(this.lastChunkSections, cy);
        }
        if (this.lastSection == null) {
            return BlockTypes.AIR.getInternalId();
        }
        return this.getCombinedId4Data(this.lastSection, x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getBiomeId(int x, int z) throws FaweException.FaweChunkLoadException {
        int cx = x >> 4;
        int cz = z >> 4;
        this.lastSectionY = -1;
        if (cx == this.lastSectionX && cz == this.lastSectionZ) {
            if (this.lastChunk != null) return this.getBiome(this.lastChunk, x, z) & 0xFF;
            return 0;
        }
        this.lastSectionX = cx;
        this.lastSectionZ = cz;
        this.lastChunk = this.ensureChunkLoaded(cx, cz);
        if (this.lastChunk != null) {
            this.lastChunkSections = this.getSections(this.lastChunk);
            return this.getBiome(this.lastChunk, x, z) & 0xFF;
        }
        this.lastChunkSections = null;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CompoundTag getTileEntity(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        int cx = x >> 4;
        int cz = z >> 4;
        this.lastSectionY = -1;
        if (cx == this.lastSectionX && cz == this.lastSectionZ) {
            if (this.lastChunk != null) return this.getTileEntity(this.lastChunk, x, y, z);
            return null;
        }
        this.lastSectionX = cx;
        this.lastSectionZ = cz;
        this.lastChunk = this.ensureChunkLoaded(cx, cz);
        if (this.lastChunk != null) {
            this.lastChunkSections = this.getSections(this.lastChunk);
            return this.getTileEntity(this.lastChunk, x, y, z);
        }
        this.lastChunkSections = null;
        return null;
    }
}

