/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.wrapper;

import com.boydti.fawe.FaweCache;
import com.boydti.fawe.bukkit.wrapper.AsyncBlockState;
import com.boydti.fawe.bukkit.wrapper.AsyncChunk;
import com.boydti.fawe.bukkit.wrapper.AsyncWorld;
import com.boydti.fawe.bukkit.wrapper.state.AsyncSign;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class AsyncBlock
implements Block {
    public int z;
    public int y;
    public int x;
    public final FaweQueue queue;
    public final AsyncWorld world;

    public AsyncBlock(AsyncWorld world, FaweQueue queue, int x, int y, int z) {
        this.world = world;
        this.queue = queue;
        this.x = x;
        this.y = Math.max(0, Math.min(255, y));
        this.z = z;
    }

    public void setPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Deprecated
    public byte getData() {
        return (byte)(this.queue.getCachedCombinedId4Data(this.x, this.y, this.z, BlockTypes.AIR.getInternalId()) & 0xF);
    }

    public int getPropertyId() {
        return this.queue.getCachedCombinedId4Data(this.x, this.y, this.z, BlockTypes.AIR.getInternalId()) >> BlockTypes.BIT_OFFSET;
    }

    public int getCombinedId() {
        return this.queue.getCachedCombinedId4Data(this.x, this.y, this.z, BlockTypes.AIR.getInternalId());
    }

    public int getTypeId() {
        return this.queue.getCachedCombinedId4Data(this.x, this.y, this.z, BlockTypes.AIR.getInternalId()) & BlockTypes.BIT_MASK;
    }

    public AsyncBlock getRelative(int modX, int modY, int modZ) {
        return new AsyncBlock(this.world, this.queue, this.x + modX, this.y + modY, this.z + modZ);
    }

    public AsyncBlock getRelative(BlockFace face) {
        return this.getRelative(face.getModX(), face.getModY(), face.getModZ());
    }

    public AsyncBlock getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public Material getType() {
        return this.getBlockData().getMaterial();
    }

    public BlockData getBlockData() {
        return BukkitAdapter.getBlockData(this.queue.getCachedCombinedId4Data(this.x, this.y, this.z, BlockTypes.AIR.getInternalId()));
    }

    @Deprecated
    public boolean setTypeIdAndPropertyId(int id, int propertyId, boolean physics) {
        return this.setTypeIdAndPropertyId(id, propertyId);
    }

    @Deprecated
    public boolean setCombinedId(int combinedId) {
        return this.queue.setBlock(this.x, this.y, this.z, combinedId);
    }

    @Deprecated
    public boolean setTypeIdAndPropertyId(int id, int propertyId) {
        return this.setCombinedId(id + (propertyId << BlockTypes.BIT_OFFSET));
    }

    @Deprecated
    public boolean setTypeId(int typeId) {
        return this.queue.setBlock(this.x, this.y, this.z, BlockTypes.get(typeId).getDefaultState());
    }

    @Deprecated
    public boolean setPropertyId(int propertyId) {
        return this.setTypeIdAndPropertyId(this.getTypeId(), propertyId);
    }

    public byte getLightLevel() {
        return (byte)this.queue.getLight(this.x, this.y, this.z);
    }

    public byte getLightFromSky() {
        return (byte)this.queue.getSkyLight(this.x, this.y, this.z);
    }

    public byte getLightFromBlocks() {
        return (byte)this.queue.getEmmittedLight(this.x, this.y, this.z);
    }

    public AsyncWorld getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Location getLocation() {
        return new Location((World)this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld((World)this.getWorld());
            loc.setX((double)this.x);
            loc.setY((double)this.y);
            loc.setZ((double)this.z);
        }
        return loc;
    }

    public AsyncChunk getChunk() {
        return this.world.getChunkAt(this.x >> 4, this.z >> 4);
    }

    public void setBlockData(BlockData blockData) {
        try {
            this.queue.setBlock(this.x, this.y, this.z, BukkitAdapter.adapt(blockData));
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBlockData(BlockData blockData, boolean b) {
        this.setBlockData(blockData);
    }

    public void setType(Material type) {
        try {
            this.queue.setBlock(this.x, this.y, this.z, BukkitAdapter.adapt(type).getDefaultState());
        }
        catch (WorldEditException e) {
            throw new RuntimeException(e);
        }
    }

    public void setType(Material type, boolean applyPhysics) {
        this.setType(type);
    }

    public BlockFace getFace(Block block) {
        BlockFace[] directions = BlockFace.values();
        for (int i = 0; i < directions.length; ++i) {
            BlockFace face = directions[i];
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public AsyncBlockState getState() {
        int combined = this.queue.getCombinedId4Data(this.x, this.y, this.z, 0);
        BlockTypes type = BlockTypes.getFromStateId(combined);
        switch (type) {
            case SIGN: 
            case WALL_SIGN: {
                return new AsyncSign(this, combined);
            }
        }
        return new AsyncBlockState(this, combined);
    }

    public AsyncBlockState getState(boolean useSnapshot) {
        return this.getState();
    }

    public Biome getBiome() {
        return this.world.getAdapter().getBiome(this.queue.getBiomeId(this.x, this.z));
    }

    public void setBiome(Biome bio) {
        int id = this.world.getAdapter().getBiomeId(bio);
        this.queue.setBiome(this.x, this.z, FaweCache.getBiome(id));
    }

    public boolean isBlockPowered() {
        return false;
    }

    public boolean isBlockIndirectlyPowered() {
        return false;
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return false;
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        return false;
    }

    public int getBlockPower(BlockFace face) {
        return 0;
    }

    public int getBlockPower() {
        return 0;
    }

    public boolean isEmpty() {
        switch (this.getType()) {
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: {
                return true;
            }
        }
        return false;
    }

    public boolean isLiquid() {
        int combined = this.queue.getCombinedId4Data(this.x, this.y, this.z, 0);
        BlockTypes type = BlockTypes.getFromStateId(combined);
        return type.getMaterial().isLiquid();
    }

    public double getTemperature() {
        return this.getWorld().getTemperature(this.getX(), this.getZ());
    }

    public double getHumidity() {
        return this.getWorld().getHumidity(this.getX(), this.getZ());
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return null;
    }

    @Deprecated
    private Block getUnsafeBlock() {
        return this.world.getBukkitWorld().getBlockAt(this.x, this.y, this.z);
    }

    public boolean breakNaturally() {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().breakNaturally());
    }

    public boolean breakNaturally(ItemStack tool) {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().breakNaturally(tool));
    }

    public Collection<ItemStack> getDrops() {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().getDrops());
    }

    public Collection<ItemStack> getDrops(ItemStack tool) {
        return TaskManager.IMP.sync(() -> this.getUnsafeBlock().getDrops(tool));
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.getUnsafeBlock().setMetadata(metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.getUnsafeBlock().getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.getUnsafeBlock().hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.getUnsafeBlock().removeMetadata(metadataKey, owningPlugin);
    }
}

