/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.v0;

import com.boydti.fawe.bukkit.v0.BukkitChunk_All;
import com.boydti.fawe.bukkit.v0.BukkitQueue_All;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.ChunkSnapshot;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;

public class BukkitChunk_All_ReadonlySnapshot
extends FaweChunk {
    private final ChunkSnapshot snapshot;
    private final boolean hasBiomes;
    private final BukkitChunk_All next;
    private Set<CompoundTag> entities = new HashSet<CompoundTag>();
    private Map<Short, CompoundTag> tiles = new HashMap<Short, CompoundTag>();

    public BukkitChunk_All_ReadonlySnapshot(BukkitQueue_All parent, BukkitChunk_All next, ChunkSnapshot snapshot, boolean biomes) {
        super(parent, snapshot.getX(), snapshot.getZ());
        this.next = next;
        this.snapshot = snapshot;
        this.hasBiomes = biomes;
    }

    public void setTiles(Map<Short, CompoundTag> tiles) {
        this.tiles = tiles;
    }

    public void setEntities(Set<CompoundTag> entities) {
        this.entities = entities;
    }

    @Override
    public BukkitQueue_All getParent() {
        return (BukkitQueue_All)super.getParent();
    }

    @Override
    public int getBitMask() {
        return 65535;
    }

    @Override
    public int getBlockCombinedId(int x, int y, int z) {
        BlockData blockData = this.snapshot.getBlockData(x, y, z);
        return BukkitAdapter.adapt(blockData).getInternalId();
    }

    @Override
    public byte[] getBiomeArray() {
        if (!this.hasBiomes || this.next.biomes == null) {
            return null;
        }
        this.getParent();
        BukkitImplAdapter adapter = BukkitQueue_All.getAdapter();
        byte[] biomes = Arrays.copyOf(this.next.biomes, this.next.biomes.length);
        int index = 0;
        for (int z = 0; z < 16; ++z) {
            int x = 0;
            while (x < 16) {
                if (biomes[index] != 0) {
                    Biome biome = this.snapshot.getBiome(x, z);
                    biomes[index] = (byte)adapter.getBiomeId(biome);
                }
                ++x;
                ++index;
            }
        }
        return biomes;
    }

    @Override
    @Nullable
    public int[] getIdArray(int layer) {
        int[] nextLayer = this.next.ids[layer];
        if (nextLayer == null) {
            return null;
        }
        int[] ids = Arrays.copyOf(nextLayer, nextLayer.length);
        int index = 0;
        int by = layer << 4;
        for (int y = 0; y < 16; ++y) {
            int yy = by + y;
            for (int z = 0; z < 16; ++z) {
                int x = 0;
                while (x < 16) {
                    if (ids[index] != 0) {
                        ids[index] = this.getBlockCombinedId(x, yy, z);
                    }
                    ++x;
                    ++index;
                }
            }
        }
        return ids;
    }

    public Object getChunk() {
        return this.snapshot;
    }

    @Override
    public void setTile(int x, int y, int z, CompoundTag tile) {
        this.tiles.put(MathMan.tripleBlockCoord(x, y, z), tile);
    }

    @Override
    public void setEntity(CompoundTag entity) {
        this.entities.add(entity);
    }

    @Override
    public void removeEntity(UUID uuid) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public void setBlock(int x, int y, int z, int combinedId) {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public Set<CompoundTag> getEntities() {
        return this.entities;
    }

    @Override
    public Set<UUID> getEntityRemoves() {
        throw new UnsupportedOperationException("Read only");
    }

    @Override
    public Map<Short, CompoundTag> getTiles() {
        return this.tiles;
    }

    @Override
    public CompoundTag getTile(int x, int y, int z) {
        if (this.tiles == null) {
            return null;
        }
        short pair = MathMan.tripleBlockCoord(x, y, z);
        return this.tiles.get(pair);
    }

    @Override
    public void setBiome(int x, int z, byte biome) {
        throw new UnsupportedOperationException("Read only");
    }

    public FaweChunk copy(boolean shallow) {
        return null;
    }

    @Override
    public FaweChunk call() {
        return null;
    }
}

