/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.v0;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.bukkit.v0.BukkitChunk_All_ReadonlySnapshot;
import com.boydti.fawe.bukkit.v0.BukkitQueue_0;
import com.boydti.fawe.bukkit.v0.BukkitQueue_All;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.IntFaweChunk;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;

public class BukkitChunk_All
extends IntFaweChunk<Chunk, BukkitQueue_All> {
    private int layer = -1;
    private int index;
    private boolean place = true;

    public BukkitChunk_All(FaweQueue parent, int x, int z) {
        super(parent, x, z);
    }

    public BukkitChunk_All(FaweQueue parent, int x, int z, int[][] ids, short[] count, short[] air, byte[] heightMap) {
        super(parent, x, z, ids, count, air, heightMap);
    }

    @Override
    public IntFaweChunk copy(boolean shallow) {
        BukkitChunk_All copy;
        if (shallow) {
            copy = new BukkitChunk_All((FaweQueue)this.getParent(), this.getX(), this.getZ(), this.ids, this.count, this.air, this.heightMap);
            copy.biomes = this.biomes;
        } else {
            copy = new BukkitChunk_All((FaweQueue)this.getParent(), this.getX(), this.getZ(), (int[][])MainUtil.copyNd(this.ids), (short[])this.count.clone(), (short[])this.air.clone(), (byte[])this.heightMap.clone());
            copy.biomes = this.biomes != null ? (byte[])this.biomes.clone() : null;
        }
        copy.chunk = this.chunk;
        return copy;
    }

    @Override
    public Chunk getNewChunk() {
        return Bukkit.getWorld((String)((BukkitQueue_All)this.getParent()).getWorldName()).getChunkAt(this.getX(), this.getZ());
    }

    @Override
    public void start() {
        ((Chunk)this.getChunk()).load(true);
    }

    private static boolean canTick(BlockType type) {
        return type.getMaterial().isTicksRandomly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public FaweChunk call() {
        start = System.currentTimeMillis();
        recommended = 25 + Settings.IMP.QUEUE.EXTRA_TIME_MS;
        more = true;
        parent = (BukkitQueue_All)this.getParent();
        adapter = BukkitQueue_0.getAdapter();
        chunk = (Chunk)this.getChunk();
        disableResult = parent.disableLighting(chunk);
        world = chunk.getWorld();
        sections = this.getCombinedIdArrays();
        bx = this.getX() << 4;
        bz = this.getZ() << 4;
        v0 = update = adapter != null ? adapter.isChunkInUse(chunk) : true;
        if (this.layer == -1) {
            if (adapter != null) {
                task = parent.getChangeTask();
                if (task != null) {
                    snapshot = (ChunkSnapshot)parent.ensureChunkLoaded(this.getX(), this.getZ());
                    previous = new BukkitChunk_All_ReadonlySnapshot(parent, this, snapshot, this.biomes != null);
                    for (BlockState tile : chunk.getTileEntities()) {
                        x = tile.getX();
                        if (this.getBlockCombinedId(x & 15, y = tile.getY(), (z = tile.getZ()) & 15) == 0 || (nbt = adapter.getBlock(new Location(world, (double)x, (double)y, (double)z)).getNbtData()) == null) continue;
                        previous.setTile(x & 15, y, z & 15, nbt);
                    }
                } else {
                    previous = null;
                }
                if (adapter != null) {
                    entitiesToSpawn = this.getEntities();
                    if (!entitiesToSpawn.isEmpty()) {
                        for (CompoundTag tag : entitiesToSpawn) {
                            id = tag.getString("Id");
                            posTag = tag.getListTag("Pos");
                            rotTag = tag.getListTag("Rotation");
                            if (id == null || posTag == null || rotTag == null) {
                                Fawe.debug("Unknown entity tag: " + tag);
                                continue;
                            }
                            x = posTag.getDouble(0);
                            loc = new Location(world, x, y = posTag.getDouble(1), z = posTag.getDouble(2), yaw = rotTag.getFloat(0), pitch = rotTag.getFloat(1));
                            created = adapter.createEntity(loc, new BaseEntity(EntityTypes.get(id), tag));
                            if (created == null) continue;
                            uuid = created.getUniqueId();
                            map = ReflectionUtils.getMap(tag.getValue());
                            map.put("UUIDLeast", new LongTag(uuid.getLeastSignificantBits()));
                            map.put("UUIDMost", new LongTag(uuid.getMostSignificantBits()));
                        }
                    }
                    if (!(entsToRemove = this.getEntityRemoves()).isEmpty()) {
                        for (Entity entity : chunk.getEntities()) {
                            if (!entsToRemove.contains(entity.getUniqueId())) continue;
                            entity.remove();
                        }
                    }
                }
                if (previous != null) {
                    task.run(previous, this);
                }
            }
            if ((biomes = this.getBiomeArray()) != null) {
                index = 0;
                for (z = 0; z < 16; ++z) {
                    zz = bz + z;
                    x = 0;
                    while (x < 16) {
                        xx = bx + x;
                        biome = biomes[index] & 255;
                        if (biome != 0) {
                            if (biome == 255) {
                                biome = 0;
                            }
                            if ((bukkitBiome = adapter.getBiome(biome)) != null) {
                                world.setBiome(xx, zz, bukkitBiome);
                            }
                        }
                        ++x;
                        ++index;
                    }
                }
            }
        } else if (this.index != 0) {
            this.layer = this.place ? --this.layer : ++this.layer;
        }
        block25: do {
            if (this.place) {
                if (++this.layer >= sections.length) {
                    this.place = false;
                    this.layer = sections.length - 1;
                }
            } else if (--this.layer < 0) {
                more = false;
                break;
            }
            try {
                changes = this.getCount(this.layer);
                if (changes == 0 || (newArray = sections[this.layer]) == null) continue;
                cacheX = FaweCache.CACHE_X[this.layer];
                cacheY = FaweCache.CACHE_Y[this.layer];
                cacheZ = FaweCache.CACHE_Z[this.layer];
                checkTime = this.getAir(this.layer) != 4096 && (this.getCount(this.layer) != 4096 || this.getAir(this.layer) != 0) && this.getCount(this.layer) != this.getAir(this.layer);
                mutableLoc = new Location(world, 0.0, 0.0, 0.0);
                if (!checkTime) {
                    index = 0;
                    for (y = 0; y < 16; ++y) {
                        yy = (this.layer << 4) + y;
                        for (z = 0; z < 16; ++z) {
                            zz = bz + z;
                            x = 0;
                            while (x < 16) {
                                combined = newArray[index];
                                if (combined != 0) {
                                    xx = bx + x;
                                    type = BlockTypes.getFromStateId(combined);
                                    if (type != BlockTypes.__RESERVED__) {
                                        switch (1.$SwitchMap$com$sk89q$worldedit$world$block$BlockTypes[type.ordinal()]) {
                                            case 1: 
                                            case 2: 
                                            case 3: {
                                                if (this.place) break;
                                                mutableLoc.setX((double)xx);
                                                mutableLoc.setY((double)yy);
                                                mutableLoc.setZ((double)zz);
                                                this.setBlock(adapter, chunk, mutableLoc, combined, update);
                                                break;
                                            }
                                            default: {
                                                if (!this.place) break;
                                                if (type.getMaterial().hasContainer() && adapter != null && (nbt = this.getTile(x, yy, z)) != null) {
                                                    var31_58 = this;
                                                    synchronized (var31_58) {
                                                        state = BaseBlock.getFromInternalId(combined, (CompoundTag)nbt);
                                                        adapter.setBlock(chunk, xx, yy, zz, state, update);
                                                        break;
                                                    }
                                                }
                                                if (type.getMaterial().isTicksRandomly()) {
                                                    nbt = this;
                                                    synchronized (nbt) {
                                                        this.setBlock(adapter, chunk, mutableLoc, combined, update);
                                                        break;
                                                    }
                                                }
                                                mutableLoc.setX((double)xx);
                                                mutableLoc.setY((double)yy);
                                                mutableLoc.setZ((double)zz);
                                                this.setBlock(adapter, chunk, mutableLoc, combined, update);
                                                break;
                                            }
                                        }
                                    }
                                }
                                ++x;
                                ++index;
                            }
                        }
                    }
                    continue;
                }
                while (this.index < 4096) {
                    block60: {
                        j = this.place != false ? this.index : 4095 - this.index;
                        combined = newArray[j];
                        type = BlockTypes.getFromStateId(combined);
                        if (type == BlockTypes.__RESERVED__) break block60;
                        switch (1.$SwitchMap$com$sk89q$worldedit$world$block$BlockTypes[type.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (this.place) break;
                                x = cacheX[j];
                                z = cacheZ[j];
                                y = cacheY[j];
                                mutableLoc.setX((double)(bx + x));
                                mutableLoc.setY((double)y);
                                mutableLoc.setZ((double)(bz + z));
                                this.setBlock(adapter, chunk, mutableLoc, combined, update);
                                break;
                            }
                            default: {
                                v1 = light = type.getMaterial().getLightValue() > 0;
                                if (!light) ** GOTO lbl167
                                if (this.place) break block60;
                                v2 = light = light != false && ((BukkitQueue_All)this.getParent()).getSettings().LIGHTING.MODE != 0;
                                if (light) {
                                    parent.enableLighting(disableResult);
                                }
                                ** GOTO lbl168
lbl167:
                                // 1 sources

                                if (!this.place) break block60;
lbl168:
                                // 2 sources

                                x = cacheX[j];
                                z = cacheZ[j];
                                y = cacheY[j];
                                if (type.getMaterial().hasContainer() && adapter != null && (tile = this.getTile(x, y, z)) != null) {
                                    var29_56 = this;
                                    synchronized (var29_56) {
                                        state = BaseBlock.getFromInternalId(combined, tile);
                                        adapter.setBlock(chunk, bx + x, y, bz + z, state, update);
                                        break;
                                    }
                                }
                                if (type.getMaterial().isTicksRandomly()) {
                                    var28_53 = this;
                                    synchronized (var28_53) {
                                        mutableLoc.setX((double)(bx + x));
                                        mutableLoc.setY((double)y);
                                        mutableLoc.setZ((double)(bz + z));
                                        this.setBlock(adapter, chunk, mutableLoc, combined, update);
                                    }
                                } else {
                                    mutableLoc.setX((double)(bx + x));
                                    mutableLoc.setY((double)y);
                                    mutableLoc.setZ((double)(bz + z));
                                    this.setBlock(adapter, chunk, mutableLoc, combined, update);
                                }
                                if (!light) break;
                                parent.disableLighting(disableResult);
                            }
                        }
                        if (System.currentTimeMillis() - start > (long)recommended) {
                            ++this.index;
                            break block25;
                        }
                    }
                    ++this.index;
                }
                this.index = 0;
            }
            catch (Throwable e) {
                MainUtil.handleError(e);
            }
        } while (System.currentTimeMillis() - start < (long)recommended);
        if (more || this.place) {
            this.addToQueue();
        }
        parent.resetLighting(disableResult);
        return this;
    }

    public void setBlock(BukkitImplAdapter adapter, Chunk chunk, Location location, int combinedId, boolean update) {
        com.sk89q.worldedit.world.block.BlockState state = com.sk89q.worldedit.world.block.BlockState.getFromInternalId(combinedId);
        if (adapter != null) {
            adapter.setBlock(chunk, (int)location.getX(), (int)location.getY(), (int)location.getZ(), state, update);
        } else {
            Block block = location.getWorld().getBlockAt(location);
            block.setBlockData(BukkitAdapter.adapt(state), false);
        }
    }
}

