/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.util;

import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Server;

public class BukkitReflectionUtils {
    private static volatile String preClassB = null;
    private static volatile String preClassM = null;
    private static boolean forge = false;

    public static void init() {
        if (Bukkit.getServer() != null) {
            Server server;
            Class<?> bukkitServerClass;
            String[] pas;
            if (Bukkit.getVersion().contains("MCPC") || Bukkit.getVersion().contains("Forge")) {
                forge = true;
            }
            if ((pas = (bukkitServerClass = (server = Bukkit.getServer()).getClass()).getName().split("\\.")).length == 5) {
                String verB = pas[3];
                preClassB = "org.bukkit.craftbukkit." + verB;
            }
            try {
                Method getHandle = bukkitServerClass.getDeclaredMethod("getHandle", new Class[0]);
                Object handle = getHandle.invoke((Object)server, new Object[0]);
                Class<?> handleServerClass = handle.getClass();
                pas = handleServerClass.getName().split("\\.");
                if (pas.length == 5) {
                    String verM = pas[3];
                    preClassM = "net.minecraft.server." + verM;
                }
            }
            catch (Exception ignored) {
                MainUtil.handleError(ignored);
            }
        }
    }

    public static boolean isForge() {
        return forge;
    }

    public static ReflectionUtils.RefClass getRefClass(String ... classes) throws RuntimeException {
        if (preClassM == null) {
            BukkitReflectionUtils.init();
        }
        for (String className : classes) {
            try {
                className = className.replace("{cb}", preClassB).replace("{nms}", preClassM).replace("{nm}", "net.minecraft");
                return ReflectionUtils.getRefClass(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new RuntimeException("no class found: " + classes[0].replace("{cb}", preClassB).replace("{nms}", preClassM).replace("{nm}", "net.minecraft"));
    }

    public static Class<?> getNmsClass(String name) {
        String className = "net.minecraft.server." + BukkitReflectionUtils.getVersion() + "." + name;
        return ReflectionUtils.getClass(className);
    }

    public static Class<?> getCbClass(String name) {
        String className = "org.bukkit.craftbukkit." + BukkitReflectionUtils.getVersion() + "." + name;
        return ReflectionUtils.getClass(className);
    }

    public static Class<?> getUtilClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            try {
                return Class.forName("net.minecraft.util." + name);
            }
            catch (ClassNotFoundException ex2) {
                return null;
            }
        }
    }

    public static String getVersion() {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }
}

