/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.filter.WorldGuardFilter;
import com.boydti.fawe.bukkit.regions.BukkitMask;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.regions.general.RegionFilter;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Worldguard
extends BukkitMaskManager
implements Listener {
    WorldGuardPlugin worldguard = this.getWorldGuard();
    FaweBukkit plugin;

    private WorldGuardPlugin getWorldGuard() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }

    public Worldguard(Plugin p2, FaweBukkit p3) {
        super(p2.getName());
        this.plugin = p3;
    }

    public ProtectedRegion getRegion(LocalPlayer player, Location loc) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        if (container == null) {
            System.out.println("Region capability is not enabled for WorldGuard.");
            return null;
        }
        RegionManager manager = container.get(FaweAPI.getWorld(loc.getWorld().getName()));
        if (manager == null) {
            System.out.println("Region capability is not enabled for that world.");
            return null;
        }
        ProtectedRegion global = manager.getRegion("__global__");
        if (global != null && this.isAllowed(player, global)) {
            return global;
        }
        ApplicableRegionSet regions = manager.getApplicableRegions(new Vector(loc.getX(), loc.getY(), loc.getZ()));
        for (ProtectedRegion region : regions) {
            if (!this.isAllowed(player, region)) continue;
            return region;
        }
        return null;
    }

    public boolean isAllowed(LocalPlayer localplayer, ProtectedRegion region) {
        if (region.isOwner(localplayer) || region.isOwner(localplayer.getName())) {
            return true;
        }
        if (region.getId().toLowerCase().equals(localplayer.getName().toLowerCase())) {
            return true;
        }
        if (region.getId().toLowerCase().contains(localplayer.getName().toLowerCase() + "//")) {
            return true;
        }
        if (region.isOwner("*")) {
            return true;
        }
        if (localplayer.hasPermission("fawe.worldguard.member")) {
            if (region.isMember(localplayer) || region.isMember(localplayer.getName())) {
                return true;
            }
            if (region.isMember("*")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public FaweMask getMask(FawePlayer<Player> fp, FaweMaskManager.MaskType type) {
        Location location;
        Player player = (Player)fp.parent;
        LocalPlayer localplayer = this.worldguard.wrapPlayer(player);
        final ProtectedRegion myregion = this.getRegion(localplayer, location = player.getLocation());
        if (myregion != null) {
            Location pos2;
            Location pos1;
            if (myregion.getId().equals("__global__")) {
                pos1 = new Location(location.getWorld(), -2.147483648E9, 0.0, -2.147483648E9);
                pos2 = new Location(location.getWorld(), 2.147483647E9, 255.0, 2.147483647E9);
            } else if (myregion instanceof ProtectedCuboidRegion) {
                pos1 = new Location(location.getWorld(), (double)myregion.getMinimumPoint().getBlockX(), (double)myregion.getMinimumPoint().getBlockY(), (double)myregion.getMinimumPoint().getBlockZ());
                pos2 = new Location(location.getWorld(), (double)myregion.getMaximumPoint().getBlockX(), (double)myregion.getMaximumPoint().getBlockY(), (double)myregion.getMaximumPoint().getBlockZ());
            } else {
                return new FaweMask(Worldguard.adapt(myregion), myregion.getId()){

                    @Override
                    public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                        return Worldguard.this.isAllowed(Worldguard.this.worldguard.wrapPlayer((Player)player.parent), myregion);
                    }
                };
            }
            return new BukkitMask(pos1, pos2){

                @Override
                public String getName() {
                    return myregion.getId();
                }

                @Override
                public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                    return Worldguard.this.isAllowed(Worldguard.this.worldguard.wrapPlayer((Player)player.parent), myregion);
                }
            };
        }
        return null;
    }

    @Override
    public RegionFilter getFilter(String world) {
        return new WorldGuardFilter(Bukkit.getWorld((String)world));
    }

    private static Region adapt(ProtectedRegion region) {
        if (region instanceof ProtectedCuboidRegion) {
            return new CuboidRegion(region.getMinimumPoint(), region.getMaximumPoint());
        }
        if (region instanceof GlobalProtectedRegion) {
            return RegionWrapper.GLOBAL();
        }
        if (region instanceof ProtectedPolygonalRegion) {
            ProtectedPolygonalRegion casted = (ProtectedPolygonalRegion)region;
            BlockVector max = region.getMaximumPoint();
            BlockVector min = region.getMinimumPoint();
            return new Polygonal2DRegion(null, casted.getPoints(), min.getBlockY(), max.getBlockY());
        }
        return new AdaptedRegion(region);
    }

    private static class AdaptedRegion
    extends AbstractRegion {
        private final ProtectedRegion region;

        public AdaptedRegion(ProtectedRegion region) {
            super(null);
            this.region = region;
        }

        @Override
        public Vector getMinimumPoint() {
            return this.region.getMinimumPoint();
        }

        @Override
        public Vector getMaximumPoint() {
            return this.region.getMaximumPoint();
        }

        @Override
        public void expand(Vector ... changes) {
            throw new UnsupportedOperationException("Region is immutable");
        }

        @Override
        public void contract(Vector ... changes) {
            throw new UnsupportedOperationException("Region is immutable");
        }

        @Override
        public boolean contains(Vector position) {
            return this.region.contains(position);
        }
    }
}

