/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.filter.GriefPreventionFilter;
import com.boydti.fawe.bukkit.regions.BukkitMask;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.regions.general.RegionFilter;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GriefPreventionFeature
extends BukkitMaskManager
implements Listener {
    FaweBukkit plugin;
    Plugin griefprevention;

    public GriefPreventionFeature(Plugin griefpreventionPlugin, FaweBukkit p3) {
        super(griefpreventionPlugin.getName());
        this.griefprevention = griefpreventionPlugin;
        this.plugin = p3;
    }

    public boolean isAllowed(Player player, Claim claim, FaweMaskManager.MaskType type) {
        return claim != null && (claim.getOwnerName().equalsIgnoreCase(player.getName()) || claim.getOwnerName().equals(player.getUniqueId()) || type == FaweMaskManager.MaskType.MEMBER && claim.allowBuild(player, Material.AIR) == null);
    }

    public BukkitMask getMask(FawePlayer<Player> fp, FaweMaskManager.MaskType type) {
        Player player = (Player)fp.parent;
        Location location = player.getLocation();
        final Claim claim = GriefPrevention.instance.dataStore.getClaimAt(location, true, null);
        if (claim != null) {
            String uuid = player.getUniqueId().toString();
            if (this.isAllowed(player, claim, type)) {
                claim.getGreaterBoundaryCorner().getBlockX();
                Location pos1 = new Location(location.getWorld(), (double)claim.getLesserBoundaryCorner().getBlockX(), 0.0, (double)claim.getLesserBoundaryCorner().getBlockZ());
                Location pos2 = new Location(location.getWorld(), (double)claim.getGreaterBoundaryCorner().getBlockX(), 256.0, (double)claim.getGreaterBoundaryCorner().getBlockZ());
                return new BukkitMask(pos1, pos2){

                    @Override
                    public String getName() {
                        return "CLAIM:" + claim.toString();
                    }

                    @Override
                    public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                        return GriefPreventionFeature.this.isAllowed((Player)player.parent, claim, type);
                    }
                };
            }
        }
        return null;
    }

    @Override
    public RegionFilter getFilter(String world) {
        return new GriefPreventionFilter(Bukkit.getWorld((String)world));
    }
}

