/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.filter;

import com.boydti.fawe.regions.general.CuboidRegionFilter;
import com.google.common.base.Preconditions;
import com.intellectualcrafters.plot.object.RunnableVal;
import com.intellectualcrafters.plot.util.TaskManager;
import com.sk89q.worldedit.BlockVector2D;
import java.util.ArrayDeque;
import java.util.Collection;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.World;

public class GriefPreventionFilter
extends CuboidRegionFilter {
    private final Collection<Claim> claims;
    private final World world;

    public GriefPreventionFilter(World world) {
        Preconditions.checkNotNull((Object)world);
        this.claims = (Collection)TaskManager.IMP.sync((RunnableVal)new RunnableVal<Collection<Claim>>(){

            public void run(Collection<Claim> claims) {
                this.value = new ArrayDeque(GriefPrevention.instance.dataStore.getClaims());
            }
        });
        this.world = world;
    }

    @Override
    public void calculateRegions() {
        for (Claim claim : this.claims) {
            Location bot = claim.getGreaterBoundaryCorner();
            if (!this.world.equals(bot.getWorld())) continue;
            Location top = claim.getGreaterBoundaryCorner();
            BlockVector2D pos1 = new BlockVector2D(bot.getBlockX(), bot.getBlockZ());
            BlockVector2D pos2 = new BlockVector2D(top.getBlockX(), top.getBlockZ());
            this.add(pos1, pos2);
        }
    }
}

