/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.chat;

import com.boydti.fawe.bukkit.chat.ArrayWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

public final class Reflection {
    private static final Map<String, Class<?>> _loadedNMSClasses = new HashMap();
    private static final Map<String, Class<?>> _loadedOBCClasses = new HashMap();
    private static final Map<Class<?>, Map<String, Field>> _loadedFields = new HashMap();
    private static final Map<Class<?>, Map<String, Map<ArrayWrapper<Class<?>>, Method>>> _loadedMethods = new HashMap();
    private static String _versionString;

    private Reflection() {
    }

    public static synchronized String getVersion() {
        if (_versionString == null) {
            if (Bukkit.getServer() == null) {
                return null;
            }
            String name = Bukkit.getServer().getClass().getPackage().getName();
            _versionString = name.substring(name.lastIndexOf(46) + 1) + ".";
        }
        return _versionString;
    }

    public static synchronized Class<?> getNMSClass(String className) {
        Class<?> clazz;
        if (_loadedNMSClasses.containsKey(className)) {
            return _loadedNMSClasses.get(className);
        }
        String fullName = "net.minecraft.server." + Reflection.getVersion() + className;
        try {
            clazz = Class.forName(fullName);
        }
        catch (ClassNotFoundException e) {
            _loadedNMSClasses.put(className, null);
            throw new RuntimeException(e);
        }
        _loadedNMSClasses.put(className, clazz);
        return clazz;
    }

    public static synchronized Class<?> getOBCClass(String className) {
        Class<?> clazz;
        if (_loadedOBCClasses.containsKey(className)) {
            return _loadedOBCClasses.get(className);
        }
        String fullName = "org.bukkit.craftbukkit." + Reflection.getVersion() + className;
        try {
            clazz = Class.forName(fullName);
        }
        catch (ClassNotFoundException e) {
            _loadedOBCClasses.put(className, null);
            throw new RuntimeException(e);
        }
        _loadedOBCClasses.put(className, clazz);
        return clazz;
    }

    public static synchronized Object getHandle(Object obj) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        return Reflection.getMethod(obj.getClass(), "getHandle", new Class[0]).invoke(obj, new Object[0]);
    }

    public static synchronized Field getField(Class<?> clazz, String name) {
        Map<Object, Object> loaded;
        if (!_loadedFields.containsKey(clazz)) {
            loaded = new HashMap();
            _loadedFields.put(clazz, loaded);
        } else {
            loaded = _loadedFields.get(clazz);
        }
        if (loaded.containsKey(name)) {
            return (Field)loaded.get(name);
        }
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            loaded.put(name, field);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            loaded.put(name, null);
            return null;
        }
    }

    public static synchronized Method getMethod(Class<?> clazz, String name, Class<?> ... args) {
        ArrayWrapper wrappedArg;
        Map<ArrayWrapper<Class<?>>, Method> loadedSignatures;
        Map<String, Map<ArrayWrapper<Class<?>>, Method>> loadedMethodNames;
        if (!_loadedMethods.containsKey(clazz)) {
            _loadedMethods.put(clazz, new HashMap());
        }
        if (!(loadedMethodNames = _loadedMethods.get(clazz)).containsKey(name)) {
            loadedMethodNames.put(name, new HashMap());
        }
        if ((loadedSignatures = loadedMethodNames.get(name)).containsKey(wrappedArg = new ArrayWrapper(args))) {
            return loadedSignatures.get(wrappedArg);
        }
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(name) || !Arrays.equals(args, m.getParameterTypes())) continue;
            m.setAccessible(true);
            loadedSignatures.put(wrappedArg, m);
            return m;
        }
        loadedSignatures.put(wrappedArg, null);
        return null;
    }
}

