/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.expression;

import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.lexer.Lexer;
import com.sk89q.worldedit.internal.expression.lexer.tokens.Token;
import com.sk89q.worldedit.internal.expression.parser.Parser;
import com.sk89q.worldedit.internal.expression.runtime.Constant;
import com.sk89q.worldedit.internal.expression.runtime.EvaluationException;
import com.sk89q.worldedit.internal.expression.runtime.ExpressionEnvironment;
import com.sk89q.worldedit.internal.expression.runtime.Functions;
import com.sk89q.worldedit.internal.expression.runtime.RValue;
import com.sk89q.worldedit.internal.expression.runtime.ReturnException;
import com.sk89q.worldedit.internal.expression.runtime.Variable;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Expression {
    private static final ThreadLocal<ArrayDeque<Expression>> instance = ThreadLocal.withInitial(ArrayDeque::new);
    private final Map<String, RValue> variables = new HashMap<String, RValue>();
    private final String[] variableNames;
    private Variable[] variableArray;
    private RValue root;
    private final Functions functions = new Functions();
    private ExpressionEnvironment environment;

    public static Expression compile(String expression, String ... variableNames) throws ExpressionException {
        return new Expression(expression, variableNames);
    }

    public Expression(double constant) {
        this.variableNames = null;
        this.root = new Constant(0, constant);
    }

    private Expression(String expression, String ... variableNames) throws ExpressionException {
        this(Lexer.tokenize(expression), variableNames);
    }

    private Expression(List<Token> tokens, String ... variableNames) throws ExpressionException {
        this.variables.put("e", new Constant(-1, Math.E));
        this.variables.put("pi", new Constant(-1, Math.PI));
        this.variables.put("true", new Constant(-1, 1.0));
        this.variables.put("false", new Constant(-1, 0.0));
        this.variableNames = variableNames;
        this.variableArray = new Variable[variableNames.length];
        for (int i = 0; i < variableNames.length; ++i) {
            String variableName = variableNames[i];
            if (this.variables.containsKey(variableName)) {
                throw new ExpressionException(-1, "Tried to overwrite identifier '" + variableName + "'");
            }
            Variable var = new Variable(0.0);
            this.variables.put(variableName, var);
            this.variableArray[i] = var;
        }
        this.root = Parser.parse(tokens, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double evaluate(double ... values) throws EvaluationException {
        if (this.root instanceof Constant) {
            return this.root.getValue();
        }
        for (int i = 0; i < values.length; ++i) {
            Variable var = this.variableArray[i];
            var.value = values[i];
        }
        this.pushInstance();
        try {
            double i = this.root.getValue();
            return i;
        }
        catch (ReturnException e) {
            double d = e.getValue();
            return d;
        }
        finally {
            this.popInstance();
        }
    }

    public void optimize() throws EvaluationException {
        this.root = this.root.optimize();
    }

    public RValue getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }

    public RValue getVariable(String name, boolean create) {
        RValue variable = this.variables.get(name);
        if (variable == null && create) {
            variable = new Variable(0.0);
            this.variables.put(name, variable);
        }
        return variable;
    }

    public static Expression getInstance() {
        return instance.get().peek();
    }

    private void pushInstance() {
        ArrayDeque<Expression> foo = instance.get();
        foo.push(this);
    }

    private void popInstance() {
        ArrayDeque<Expression> foo = instance.get();
        foo.pop();
    }

    public Functions getFunctions() {
        return this.functions;
    }

    public ExpressionEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ExpressionEnvironment environment) {
        this.environment = environment;
    }
}

