/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.block;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.LayerFunction;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.world.block.BlockTypes;

public class Naturalizer
implements LayerFunction {
    private final EditSession editSession;
    private final Mask mask;
    private int affected = 0;

    public Naturalizer(EditSession editSession) {
        Preconditions.checkNotNull((Object)editSession);
        this.editSession = editSession;
        this.mask = new BlockTypeMask((Extent)editSession, BlockTypes.GRASS_BLOCK, BlockTypes.DIRT, BlockTypes.STONE);
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public boolean isGround(Vector position) {
        return this.mask.test(position);
    }

    @Override
    public boolean apply(Vector position, int depth) throws WorldEditException {
        if (this.mask.test(position)) {
            ++this.affected;
            switch (depth) {
                case 0: {
                    this.editSession.setBlock(position, BlockTypes.GRASS_BLOCK);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.editSession.setBlock(position, BlockTypes.DIRT);
                    break;
                }
                default: {
                    this.editSession.setBlock(position, BlockTypes.STONE);
                }
            }
        }
        return true;
    }
}

