/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.util.IOUtil;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.StringTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class SpongeSchematicWriter
implements ClipboardWriter {
    private static final int MAX_SIZE = 65535;
    private final NBTOutputStream outputStream;

    public SpongeSchematicWriter(NBTOutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream);
        this.outputStream = outputStream;
    }

    @Override
    public void write(Clipboard clipboard) throws IOException {
        this.write1(clipboard);
    }

    public void write1(Clipboard clipboard) throws IOException {
        Region region = clipboard.getRegion();
        Vector origin = clipboard.getOrigin();
        BlockVector min = region.getMinimumPoint().toBlockVector();
        Vector offset = min.subtract(origin);
        int width = region.getWidth();
        int height = region.getHeight();
        int length = region.getLength();
        if (width > 65535) {
            throw new IllegalArgumentException("Width of region too large for a .schematic");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("Height of region too large for a .schematic");
        }
        if (length > 65535) {
            throw new IllegalArgumentException("Length of region too large for a .schematic");
        }
        DataOutput rawStream = this.outputStream.getOutputStream();
        this.outputStream.writeLazyCompoundTag("Schematic", out -> {
            out.writeNamedTag("Version", 1);
            out.writeNamedTag("Width", (short)width);
            out.writeNamedTag("Height", (short)height);
            out.writeNamedTag("Length", (short)length);
            out.writeNamedTag("Offset", new int[]{min.getBlockX(), min.getBlockY(), min.getBlockZ()});
            out.writeLazyCompoundTag("Metadata", out1 -> {
                out1.writeNamedTag("WEOffsetX", offset.getBlockX());
                out1.writeNamedTag("WEOffsetY", offset.getBlockY());
                out1.writeNamedTag("WEOffsetZ", offset.getBlockZ());
            });
            ByteArrayOutputStream blocksCompressed = new ByteArrayOutputStream();
            final DataOutputStream blocksOut = new DataOutputStream(new LZ4BlockOutputStream(blocksCompressed));
            ByteArrayOutputStream tilesCompressed = new ByteArrayOutputStream();
            final NBTOutputStream tilesOut = new NBTOutputStream(new LZ4BlockOutputStream(tilesCompressed));
            final int[] numTiles = new int[]{0};
            final ArrayList paletteList = new ArrayList();
            final char[] palette = new char[BlockTypes.states.length];
            Arrays.fill(palette, '\uffff');
            final int[] paletteMax = new int[]{0};
            FaweClipboard.BlockReader reader = new FaweClipboard.BlockReader(){

                @Override
                public void run(int x, int y, int z, BlockState block) {
                    try {
                        int ordinal;
                        char value;
                        CompoundTag tile = block.getNbtData();
                        if (tile != null) {
                            Object values = tile.getValue();
                            values.remove("id");
                            values.remove("x");
                            values.remove("y");
                            values.remove("z");
                            if (!values.containsKey("Id")) {
                                values.put("Id", new StringTag(block.getNbtId()));
                            }
                            values.put("Pos", new IntArrayTag(new int[]{x, y, z}));
                            numTiles[0] = numTiles[0] + 1;
                            tilesOut.writeTagPayload(tile);
                        }
                        if ((value = palette[ordinal = block.getOrdinal()]) == '\uffff') {
                            int n = paletteMax[0];
                            paletteMax[0] = n + 1;
                            int size = n;
                            palette[ordinal] = value = (char)size;
                            paletteList.add(ordinal);
                        }
                        while ((value & 0xFFFFFF80) != 0) {
                            blocksOut.write(value & 0x7F | 0x80);
                            value = (char)(value >>> 7);
                        }
                        blocksOut.write(value);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            if (clipboard instanceof BlockArrayClipboard) {
                ((BlockArrayClipboard)clipboard).IMP.forEach(reader, true);
            } else {
                for (Vector pt : region) {
                    BlockState block = clipboard.getBlock(pt);
                    int x = pt.getBlockX() - min.getBlockX();
                    int y = pt.getBlockY() - min.getBlockY();
                    int z = pt.getBlockZ() - min.getBlockY();
                    reader.run(x, y, z, block);
                }
            }
            tilesOut.close();
            blocksOut.close();
            out.writeNamedTag("PaletteMax", paletteMax[0]);
            out.writeLazyCompoundTag("Palette", out12 -> {
                for (int i = 0; i < paletteList.size(); ++i) {
                    int stateOrdinal = (Integer)paletteList.get(i);
                    BlockState state = BlockTypes.states[stateOrdinal];
                    out12.writeNamedTag(state.getAsString(), i);
                }
            });
            out.writeNamedTagName("BlockData", 7);
            rawStream.writeInt(blocksOut.size());
            try (LZ4BlockInputStream in = new LZ4BlockInputStream(new ByteArrayInputStream(blocksCompressed.toByteArray()));){
                IOUtil.copy((InputStream)in, rawStream);
            }
            if (numTiles[0] != 0) {
                out.writeNamedTagName("TileEntities", 9);
                rawStream.write(10);
                rawStream.writeInt(numTiles[0]);
                in = new LZ4BlockInputStream(new ByteArrayInputStream(tilesCompressed.toByteArray()));
                var20_20 = null;
                try {
                    IOUtil.copy((InputStream)in, rawStream);
                }
                catch (Throwable throwable) {
                    var20_20 = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (var20_20 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                var20_20.addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            } else {
                out.writeNamedEmptyList("TileEntities");
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

