/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.clipboard.CPUOptimizedClipboard;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.MemoryOptimizedClipboard;
import com.boydti.fawe.object.io.FastByteArrayOutputStream;
import com.boydti.fawe.object.io.FastByteArraysInputStream;
import com.boydti.fawe.util.IOUtil;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.StringTag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.NBTSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.legacycompat.NBTCompatibilityHandler;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityType;
import com.sk89q.worldedit.world.entity.EntityTypes;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class SpongeSchematicReader
extends NBTSchematicReader {
    private static final List<NBTCompatibilityHandler> COMPATIBILITY_HANDLERS = new ArrayList<NBTCompatibilityHandler>();
    private static final Logger log = Logger.getLogger(SpongeSchematicReader.class.getCanonicalName());
    private final NBTInputStream inputStream;
    private int width;
    private int height;
    private int length;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    private char[] palette;
    private Vector min;
    private FaweClipboard fc;

    public SpongeSchematicReader(NBTInputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        this.inputStream = inputStream;
    }

    @Override
    public Clipboard read() throws IOException {
        return this.read(UUID.randomUUID());
    }

    @Override
    public Clipboard read(UUID uuid) throws IOException {
        return this.readVersion1(uuid);
    }

    private FaweClipboard setupClipboard(int size, UUID uuid) {
        if (this.fc != null) {
            if (this.fc.getDimensions().getX() == 0.0) {
                this.fc.setDimensions(new Vector(size, 1, 1));
            }
            return this.fc;
        }
        if (Settings.IMP.CLIPBOARD.USE_DISK) {
            this.fc = new DiskOptimizedClipboard(size, 1, 1, uuid);
            return this.fc;
        }
        if (Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL == 0) {
            this.fc = new CPUOptimizedClipboard(size, 1, 1);
            return this.fc;
        }
        this.fc = new MemoryOptimizedClipboard(size, 1, 1);
        return this.fc;
    }

    private Clipboard readVersion1(final UUID uuid) throws IOException {
        int index;
        int volume2;
        Throwable throwable;
        FaweInputStream fis;
        CuboidRegion region;
        this.offsetZ = Integer.MIN_VALUE;
        this.offsetY = Integer.MIN_VALUE;
        this.offsetX = Integer.MIN_VALUE;
        this.length = Integer.MIN_VALUE;
        this.height = Integer.MIN_VALUE;
        this.width = Integer.MIN_VALUE;
        final BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)new CuboidRegion(new Vector(0, 0, 0), new Vector(0, 0, 0)), this.fc);
        final FastByteArrayOutputStream blocksOut = new FastByteArrayOutputStream();
        final FastByteArrayOutputStream biomesOut = new FastByteArrayOutputStream();
        NBTStreamer streamer = new NBTStreamer(this.inputStream);
        streamer.addReader("Schematic.Width", (i, v) -> {
            this.width = v.shortValue();
        });
        streamer.addReader("Schematic.Height", (i, v) -> {
            this.height = v.shortValue();
        });
        streamer.addReader("Schematic.Length", (i, v) -> {
            this.length = v.shortValue();
        });
        streamer.addReader("Schematic.Offset", (i, v) -> {
            this.min = new BlockVector(v[0], v[1], v[2]);
        });
        streamer.addReader("Schematic.Metadata.WEOffsetX", (i, v) -> {
            this.offsetX = v;
        });
        streamer.addReader("Schematic.Metadata.WEOffsetY", (i, v) -> {
            this.offsetY = v;
        });
        streamer.addReader("Schematic.Metadata.WEOffsetZ", (i, v) -> {
            this.offsetZ = v;
        });
        streamer.addReader("Schematic.Palette", (i, v) -> {
            this.palette = new char[v.size()];
            for (Map.Entry entry : v.entrySet()) {
                BlockState state = BlockState.get((String)entry.getKey());
                int index = ((IntTag)entry.getValue()).getValue();
                this.palette[index] = (char)state.getOrdinal();
            }
        });
        streamer.addReader("Schematic.BlockData.#", new NBTStreamer.LazyReader(){

            @Override
            public void accept(Integer arrayLen, DataInputStream dis) {
                try (FaweOutputStream blocks = new FaweOutputStream(new LZ4BlockOutputStream(blocksOut));){
                    IOUtil.copy(dis, blocks, arrayLen);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        streamer.addReader("Schematic.Biomes.#", new NBTStreamer.LazyReader(){

            @Override
            public void accept(Integer arrayLen, DataInputStream dis) {
                try (FaweOutputStream biomes = new FaweOutputStream(new LZ4BlockOutputStream(biomesOut));){
                    IOUtil.copy(dis, biomes, arrayLen);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        streamer.addReader("Schematic.TileEntities.#", new BiConsumer<Integer, CompoundTag>(){

            @Override
            public void accept(Integer index, CompoundTag value) {
                if (SpongeSchematicReader.this.fc == null) {
                    SpongeSchematicReader.this.setupClipboard(0, uuid);
                }
                int[] pos = value.getIntArray("Pos");
                int x = pos[0];
                int y = pos[1];
                int z = pos[2];
                SpongeSchematicReader.this.fc.setTile(x, y, z, value);
            }
        });
        streamer.addReader("Schematic.Entities.#", new BiConsumer<Integer, CompoundTag>(){

            @Override
            public void accept(Integer index, CompoundTag compound) {
                String id;
                if (SpongeSchematicReader.this.fc == null) {
                    SpongeSchematicReader.this.setupClipboard(0, uuid);
                }
                if ((id = compound.getString("id")).isEmpty()) {
                    return;
                }
                ListTag positionTag = compound.getListTag("Pos");
                ListTag directionTag = compound.getListTag("Rotation");
                EntityType type = EntityTypes.parse(id);
                if (type != null) {
                    compound.getValue().put("Id", new StringTag(type.getId()));
                    BaseEntity state = new BaseEntity(type, compound);
                    SpongeSchematicReader.this.fc.createEntity(clipboard, positionTag.asDouble(0), positionTag.asDouble(1), positionTag.asDouble(2), (float)directionTag.asDouble(0), (float)directionTag.asDouble(1), state);
                } else {
                    Fawe.debug("Invalid entity: " + id);
                }
            }
        });
        streamer.readFully();
        if (this.fc == null) {
            this.setupClipboard(this.length * this.width * this.height, uuid);
        } else {
            this.fc.setDimensions(new Vector(this.width, this.height, this.length));
        }
        Vector origin = this.min;
        if (this.offsetX != Integer.MIN_VALUE && this.offsetY != Integer.MIN_VALUE && this.offsetZ != Integer.MIN_VALUE) {
            origin = origin.subtract(new Vector(this.offsetX, this.offsetY, this.offsetZ));
            region = new CuboidRegion(this.min, this.min.add(this.width, this.height, this.length).subtract(Vector.ONE));
        } else {
            region = new CuboidRegion(this.min, this.min.add(this.width, this.height, this.length).subtract(Vector.ONE));
        }
        if (blocksOut.getSize() != 0) {
            fis = new FaweInputStream(new LZ4BlockInputStream(new FastByteArraysInputStream(blocksOut.toByteArrays())));
            throwable = null;
            try {
                BlockState state;
                volume2 = this.width * this.height * this.length;
                if (this.palette.length < 128) {
                    for (index = 0; index < volume2; ++index) {
                        state = BlockTypes.states[this.palette[fis.read()]];
                        this.fc.setBlock(index, state);
                    }
                } else {
                    for (index = 0; index < volume2; ++index) {
                        state = BlockTypes.states[this.palette[fis.readVarInt()]];
                        this.fc.setBlock(index, state);
                    }
                }
            }
            catch (Throwable volume2) {
                throwable = volume2;
                throw volume2;
            }
            finally {
                if (fis != null) {
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable volume2) {
                            throwable.addSuppressed(volume2);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        if (biomesOut.getSize() != 0) {
            fis = new FaweInputStream(new LZ4BlockInputStream(new FastByteArraysInputStream(biomesOut.toByteArrays())));
            throwable = null;
            try {
                volume2 = this.width * this.length;
                for (index = 0; index < volume2; ++index) {
                    this.fc.setBiome(index, fis.read());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fis != null) {
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        clipboard.init(region, this.fc);
        clipboard.setOrigin(origin);
        return clipboard;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

