/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.wrappers.LocationMaskedPlayerWrapper;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.scripting.RhinoCraftScriptEngine;
import com.sk89q.worldedit.session.request.Request;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import org.mozilla.javascript.NativeJavaObject;

@Command(aliases={}, desc="Run craftscripts: [More Info](https://goo.gl/dHDxLG)")
public class ScriptingCommands {
    private final WorldEdit worldEdit;

    public ScriptingCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(aliases={"setupdispatcher"}, desc="", usage="", min=1, max=1)
    public void setupdispatcher(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        CommandManager.getInstance().setupDispatcher();
    }

    public static <T> T runScript(Player player, File f, String[] args) throws WorldEditException {
        return ScriptingCommands.runScript(player, f, args, null);
    }

    public static <T> T runScript(Actor actor, File f, String[] args, @Nullable Function<String, String> processor) throws WorldEditException {
        String script;
        Request.reset();
        String filename = f.getPath();
        int index = filename.lastIndexOf(".");
        String ext = filename.substring(index + 1, filename.length());
        if (!ext.equalsIgnoreCase("js")) {
            actor.printError("Only .js scripts are currently supported");
            return null;
        }
        try {
            InputStream file;
            if (!f.exists()) {
                file = WorldEdit.class.getResourceAsStream("craftscripts/" + filename);
                if (file == null) {
                    actor.printError("Script does not exist: " + filename);
                    return null;
                }
            } else {
                file = new FileInputStream(f);
            }
            DataInputStream in = new DataInputStream(file);
            byte[] data = new byte[in.available()];
            in.readFully(data);
            in.close();
            script = new String(data, 0, data.length, "utf-8");
        }
        catch (IOException e) {
            actor.printError("Script read error: " + e.getMessage());
            return null;
        }
        if (processor != null) {
            script = processor.apply(script);
        }
        WorldEdit worldEdit = WorldEdit.getInstance();
        LocalSession session = worldEdit.getSessionManager().get(actor);
        RhinoCraftScriptEngine engine = null;
        Object result = null;
        try {
            engine = new RhinoCraftScriptEngine();
        }
        catch (NoClassDefFoundError e) {
            actor.printError("Failed to find an installed script engine.");
            actor.printError("Download: https://github.com/downloads/mozilla/rhino/rhino1_7R4.zip");
            actor.printError("Extract: `js.jar` to `plugins` or `mods` directory`");
            actor.printError("More info: https://github.com/boy0001/CraftScripts/");
            return null;
        }
        engine.setTimeLimit(worldEdit.getConfiguration().scriptTimeout);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("argv", args);
        vars.put("actor", actor);
        try {
            result = engine.evaluate(script, filename, vars);
        }
        catch (ScriptException e) {
            e.printStackTrace();
            actor.printError("Failed to execute:");
            actor.printRaw(e.getMessage());
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (WorldEditException e) {
            throw e;
        }
        catch (Throwable e) {
            actor.printError("Failed to execute (see console):");
            actor.printRaw(e.getClass().getCanonicalName());
        }
        if (result instanceof NativeJavaObject) {
            return (T)((NativeJavaObject)result).unwrap();
        }
        return (T)result;
    }

    @Command(aliases={"cs"}, usage="<filename> [args...]", desc="Execute a CraftScript", min=1, max=-1)
    @CommandPermissions(value={"worldedit.scripting.execute"})
    @Logging(value=Logging.LogMode.ALL)
    public void execute(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        String[] scriptArgs = args.getSlice(1);
        String name = args.getString(0);
        if (!player.hasPermission("worldedit.scripting.execute." + name)) {
            player.printError("You don't have permission to use that script.");
            return;
        }
        session.setLastScript(name);
        File dir = this.worldEdit.getWorkingDirectoryFile(this.worldEdit.getConfiguration().scriptsDir);
        File f = this.worldEdit.getSafeOpenFile(player, dir, name, "js", "js");
        try {
            new RhinoCraftScriptEngine();
        }
        catch (NoClassDefFoundError e) {
            player.printError("Failed to find an installed script engine.");
            player.printError("Download: https://github.com/downloads/mozilla/rhino/rhino1_7R4.zip");
            player.printError("Extract: `js.jar` to `plugins` or `mods` directory`");
            player.printError("More info: https://github.com/boy0001/CraftScripts/");
            return;
        }
        this.worldEdit.runScript(LocationMaskedPlayerWrapper.unwrap(player), f, scriptArgs);
    }

    @Command(aliases={".s"}, usage="[args...]", desc="Execute last CraftScript", min=0, max=-1)
    @CommandPermissions(value={"worldedit.scripting.execute"})
    @Logging(value=Logging.LogMode.ALL)
    public void executeLast(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        String lastScript = session.getLastScript();
        if (!player.hasPermission("worldedit.scripting.execute." + lastScript)) {
            player.printError("You don't have permission to use that script.");
            return;
        }
        if (lastScript == null) {
            player.printError("Use /cs with a script name first.");
            return;
        }
        String[] scriptArgs = args.getSlice(0);
        File dir = this.worldEdit.getWorkingDirectoryFile(this.worldEdit.getConfiguration().scriptsDir);
        File f = this.worldEdit.getSafeOpenFile(player, dir, lastScript, "js", "js");
        try {
            this.worldEdit.runScript(LocationMaskedPlayerWrapper.unwrap(player), f, scriptArgs);
        }
        catch (WorldEditException ex) {
            player.printError("Error while executing CraftScript.");
        }
    }
}

