/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.example.NMSMappedFaweQueue;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.FaweLocation;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.visitor.Fast2DIterator;
import com.boydti.fawe.util.MathMan;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.function.GroundFunction;
import com.sk89q.worldedit.function.generator.FloraGenerator;
import com.sk89q.worldedit.function.generator.ForestGenerator;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.NoiseFilter2D;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.LayerVisitor;
import com.sk89q.worldedit.internal.annotation.Direction;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.math.convolution.GaussianKernel;
import com.sk89q.worldedit.math.convolution.HeightMap;
import com.sk89q.worldedit.math.convolution.HeightMapFilter;
import com.sk89q.worldedit.math.noise.RandomNoise;
import com.sk89q.worldedit.regions.ConvexPolyhedralRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.Regions;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.command.binding.Range;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.binding.Text;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.biome.Biomes;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.registry.BiomeRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Command(aliases={}, desc="Commands that operate on regions: [More Info](http://wiki.sk89q.com/wiki/WorldEdit/Region_operations)")
public class RegionCommands
extends MethodCommands {
    private final WorldEdit worldEdit;

    public RegionCommands(WorldEdit worldEdit) {
        super(worldEdit);
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(aliases={"/fixlighting"}, desc="Get the light at a position", min=0, max=0)
    @CommandPermissions(value={"worldedit.light.fix"})
    public void fixlighting(Player player) throws WorldEditException {
        FawePlayer fp = FawePlayer.wrap(player);
        FaweLocation loc = fp.getLocation();
        Region selection = fp.getSelection();
        if (selection == null) {
            int cx = loc.x >> 4;
            int cz = loc.z >> 4;
            selection = new CuboidRegion(new Vector(cx - 8, 0, cz - 8).multiply(16), new Vector(cx + 8, 0, cz + 8).multiply(16));
        }
        int count = FaweAPI.fixLighting(loc.world, selection, FaweQueue.RelightMode.ALL);
        BBC.LIGHTING_PROPOGATE_SELECTION.send(fp, count);
    }

    @Command(aliases={"/getlighting"}, desc="Get the light at a position", min=0, max=0)
    @CommandPermissions(value={"worldedit.light.fix"})
    public void getlighting(Player player) throws WorldEditException {
        FawePlayer fp = FawePlayer.wrap(player);
        FaweLocation loc = fp.getLocation();
        FaweQueue queue = fp.getFaweQueue(false);
        fp.sendMessage("Light: " + queue.getEmmittedLight(loc.x, loc.y, loc.z) + " | " + queue.getSkyLight(loc.x, loc.y, loc.z));
    }

    @Command(aliases={"/removelight", "/removelighting"}, desc="Removing lighting in a selection", min=0, max=0)
    @CommandPermissions(value={"worldedit.light.remove"})
    public void removelighting(Player player) {
        FawePlayer fp = FawePlayer.wrap(player);
        FaweLocation loc = fp.getLocation();
        Region selection = fp.getSelection();
        if (selection == null) {
            int cx = loc.x >> 4;
            int cz = loc.z >> 4;
            selection = new CuboidRegion(new Vector(cx - 8, 0, cz - 8).multiply(16), new Vector(cx + 8, 0, cz + 8).multiply(16));
        }
        int count = FaweAPI.fixLighting(loc.world, selection, FaweQueue.RelightMode.NONE);
        BBC.UPDATED_LIGHTING_SELECTION.send(fp, count);
    }

    @Command(aliases={"/nbtinfo", "/nbt"}, desc="View nbt info for a block")
    @CommandPermissions(value={"worldedit.nbtinfo"})
    public void nbtinfo(Player player, EditSession editSession) {
        Location pos = player.getBlockTrace(128);
        if (pos == null) {
            BBC.NO_BLOCK.send(player, new Object[0]);
            return;
        }
        CompoundTag nbt = editSession.getBlock(pos.toVector()).getNbtData();
        if (nbt != null) {
            player.print(nbt.getValue().toString());
        } else {
            BBC.NO_BLOCK.send(player, new Object[0]);
        }
    }

    @Command(aliases={"/setblocklight", "/setlight"}, desc="Set block lighting in a selection", min=1, max=1)
    @CommandPermissions(value={"worldedit.light.set"})
    public void setlighting(Player player, @Selection Region region, @Range(min=0.0, max=15.0) int value) {
        FawePlayer fp = FawePlayer.wrap(player);
        FaweLocation loc = fp.getLocation();
        int cx = loc.x >> 4;
        int cz = loc.z >> 4;
        NMSMappedFaweQueue queue = (NMSMappedFaweQueue)fp.getFaweQueue(false);
        for (Vector pt : region) {
            queue.setBlockLight((int)pt.getX(), (int)pt.getY(), (int)pt.getZ(), value);
        }
        int count = 0;
        for (Vector2D chunk : region.getChunks()) {
            queue.sendChunk(queue.getFaweChunk(chunk.getBlockX(), chunk.getBlockZ()));
            ++count;
        }
        BBC.UPDATED_LIGHTING_SELECTION.send(fp, count);
    }

    @Command(aliases={"/setskylight"}, desc="Set sky lighting in a selection", min=1, max=1)
    @CommandPermissions(value={"worldedit.light.set"})
    public void setskylighting(Player player, @Selection Region region, @Range(min=0.0, max=15.0) int value) {
        FawePlayer fp = FawePlayer.wrap(player);
        FaweLocation loc = fp.getLocation();
        int cx = loc.x >> 4;
        int cz = loc.z >> 4;
        NMSMappedFaweQueue queue = (NMSMappedFaweQueue)fp.getFaweQueue(false);
        for (Vector pt : region) {
            queue.setSkyLight((int)pt.getX(), (int)pt.getY(), (int)pt.getZ(), value);
        }
        int count = 0;
        for (Vector2D chunk : region.getChunks()) {
            queue.sendChunk(queue.getFaweChunk(chunk.getBlockX(), chunk.getBlockZ()));
            ++count;
        }
        BBC.UPDATED_LIGHTING_SELECTION.send(fp, count);
    }

    @Command(aliases={"/line"}, usage="<pattern> [thickness]", desc="Draws a line segment between cuboid selection corners", help="Draws a line segment between cuboid selection corners.\nCan only be used with cuboid selections.\nFlags:\n  -h generates only a shell", flags="h", min=1, max=2)
    @CommandPermissions(value={"worldedit.region.line"})
    @Logging(value=Logging.LogMode.REGION)
    public void line(Player player, EditSession editSession, @Selection Region region, Pattern pattern, @Optional(value={"0"}) @Range(min=0.0) int thickness, @Switch(value=104) boolean shell) throws WorldEditException {
        if (!(region instanceof CuboidRegion)) {
            player.printError("//line only works with cuboid selections");
            return;
        }
        CuboidRegion cuboidregion = (CuboidRegion)region;
        Vector pos1 = cuboidregion.getPos1();
        Vector pos2 = cuboidregion.getPos2();
        int blocksChanged = editSession.drawLine(pattern, pos1, pos2, thickness, !shell);
        BBC.VISITOR_BLOCK.send(player, blocksChanged);
    }

    @Command(aliases={"/curve", "/spline"}, usage="<pattern> [thickness]", desc="Draws a spline through selected points", help="Draws a spline through selected points.\nCan only be used with convex polyhedral selections.\nFlags:\n  -h generates only a shell", flags="h", min=1, max=2)
    @CommandPermissions(value={"worldedit.region.curve"})
    @Logging(value=Logging.LogMode.REGION)
    public void curve(FawePlayer player, EditSession editSession, @Selection Region region, Pattern pattern, @Optional(value={"0"}) @Range(min=0.0) int thickness, @Switch(value=104) boolean shell, CommandContext context) throws WorldEditException {
        if (!(region instanceof ConvexPolyhedralRegion)) {
            player.sendMessage(BBC.getPrefix() + "//curve only works with convex polyhedral selections");
            return;
        }
        this.worldEdit.checkMaxRadius(thickness);
        player.checkConfirmationRegion(() -> {
            ConvexPolyhedralRegion cpregion = (ConvexPolyhedralRegion)region;
            ArrayList<Vector> vectors = new ArrayList<Vector>(cpregion.getVertices());
            int blocksChanged = editSession.drawSpline(pattern, vectors, 0.0, 0.0, 0.0, 10.0, thickness, !shell);
            BBC.VISITOR_BLOCK.send(player, blocksChanged);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/replace", "/re", "/rep", "/r"}, usage="[from-mask] <to-pattern>", desc="Replace all blocks in the selection with another", flags="f", min=1, max=2)
    @CommandPermissions(value={"worldedit.region.replace"})
    @Logging(value=Logging.LogMode.REGION)
    public void replace(FawePlayer player, EditSession editSession, @Selection Region region, @Optional Mask from, Pattern to, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.replaceBlocks(region, from == null ? new ExistingBlockMask(editSession) : from, to);
            BBC.VISITOR_BLOCK.send(player, affected);
            if (!player.hasPermission("fawe.tips")) {
                BBC.TIP_REPLACE_ID.or(BBC.TIP_REPLACE_LIGHT, BBC.TIP_REPLACE_MARKER, BBC.TIP_TAB_COMPLETE, BBC.TIP_REPLACE_REGEX, BBC.TIP_REPLACE_REGEX_2, BBC.TIP_REPLACE_REGEX_3, BBC.TIP_REPLACE_REGEX_4, BBC.TIP_REPLACE_REGEX_5).send(player, new Object[0]);
            }
        }, this.getArguments(context), region, context);
    }

    @Deprecated
    public void set(Player player, LocalSession session, EditSession editSession, Pattern pattern) throws WorldEditException {
        this.set(FawePlayer.wrap(player), session, editSession, session.getSelection(player.getWorld()), pattern, null);
    }

    @Command(aliases={"/set", "/s"}, usage="[pattern]", desc="Set all blocks within selection", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.set"})
    @Logging(value=Logging.LogMode.REGION)
    public void set(FawePlayer player, LocalSession session, EditSession editSession, @Selection Region selection, Pattern to, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.setBlocks(selection, to);
            if (affected != 0) {
                BBC.OPERATION.send(player, affected);
                if (!player.hasPermission("fawe.tips")) {
                    BBC.TIP_FAST.or(BBC.TIP_CANCEL, BBC.TIP_MASK, BBC.TIP_MASK_ANGLE, BBC.TIP_SET_LINEAR, BBC.TIP_SURFACE_SPREAD, BBC.TIP_SET_HAND).send(player, new Object[0]);
                }
            }
        }, this.getArguments(context), selection, context);
    }

    @Command(aliases={"/overlay"}, usage="<pattern>", desc="Set a block on top of blocks in the region", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.overlay"})
    @Logging(value=Logging.LogMode.REGION)
    public void overlay(FawePlayer player, EditSession editSession, @Selection Region region, Pattern pattern, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.overlayCuboidBlocks(region, pattern);
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/lay"}, usage="<pattern>", desc="Set the top block in the region", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.overlay"})
    @Logging(value=Logging.LogMode.REGION)
    public void lay(FawePlayer player, EditSession editSession, @Selection Region region, Pattern pattern, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            int maxY = max.getBlockY();
            int width = region.getWidth();
            int height = region.getLength();
            int bx = min.getBlockX();
            int bz = min.getBlockZ();
            Iterable<Vector2D> flat = Regions.asFlatRegion(region).asFlatRegion();
            Iterator<Vector2D> iter = new Fast2DIterator(flat, editSession).iterator();
            int y = 0;
            int affected = 0;
            MutableBlockVector mutable = new MutableBlockVector();
            while (iter.hasNext()) {
                Vector2D pos = iter.next();
                int x = pos.getBlockX();
                int z = pos.getBlockZ();
                y = editSession.getNearestSurfaceTerrainBlock(x, z, y, 0, maxY);
                editSession.setBlock(x, y, z, pattern);
                ++affected;
            }
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/center", "/middle"}, usage="<pattern>", desc="Set the center block(s)", min=1, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.region.center"})
    public void center(Player player, EditSession editSession, @Selection Region region, Pattern pattern) throws WorldEditException {
        int affected = editSession.center(region, pattern);
        BBC.VISITOR_BLOCK.send(player, affected);
    }

    @Command(aliases={"/naturalize"}, usage="", desc="3 layers of dirt on top then rock below", min=0, max=0)
    @CommandPermissions(value={"worldedit.region.naturalize"})
    @Logging(value=Logging.LogMode.REGION)
    public void naturalize(FawePlayer player, EditSession editSession, @Selection Region region, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.naturalizeCuboidBlocks(region);
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/walls"}, usage="<pattern>", desc="Build the four sides of the selection", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.walls"})
    @Logging(value=Logging.LogMode.REGION)
    public void walls(FawePlayer player, EditSession editSession, @Selection Region region, Pattern pattern, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.makeWalls(region, pattern);
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/faces", "/outline"}, usage="<pattern>", desc="Build the walls, ceiling, and floor of a selection", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.faces"})
    @Logging(value=Logging.LogMode.REGION)
    public void faces(FawePlayer player, EditSession editSession, @Selection Region region, Pattern pattern, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.makeCuboidFaces(region, pattern);
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/smooth"}, usage="[iterations]", flags="n", desc="Smooth the elevation in the selection", help="Smooths the elevation in the selection.\nThe -n flag makes it only consider naturally occuring blocks.\nThe -s flag makes it only consider snow.", min=0, max=2)
    @CommandPermissions(value={"worldedit.region.smoothsnow"})
    @Logging(value=Logging.LogMode.REGION)
    public void smooth(FawePlayer player, EditSession editSession, @Selection Region region, @Optional(value={"1"}) int iterations, @Switch(value=110) boolean affectNatural, @Switch(value=115) boolean snow, CommandContext context) throws WorldEditException {
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        long volume = ((long)max.getX() - (long)min.getX() + 1L) * ((long)max.getY() - (long)min.getY() + 1L) * ((long)max.getZ() - (long)min.getZ() + 1L);
        FaweLimit limit = FawePlayer.wrap(player).getLimit();
        if (volume >= (long)limit.MAX_CHECKS) {
            throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_MAX_CHECKS);
        }
        player.checkConfirmationRegion(() -> {
            try {
                HeightMap heightMap = new HeightMap(editSession, region, affectNatural, snow);
                HeightMapFilter filter = (HeightMapFilter)HeightMapFilter.class.getConstructors()[0].newInstance(GaussianKernel.class.getConstructors()[0].newInstance(5, 1));
                int affected = heightMap.applyFilter(filter, iterations);
                BBC.VISITOR_BLOCK.send(player, affected);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/wea", "wea", "worldeditanywhere", "/worldeditanywhere", "/weanywhere"}, desc="Bypass region restrictions", help="Bypass region restrictions")
    @CommandPermissions(value={"fawe.admin"})
    public void wea(Player player) throws WorldEditException {
        FawePlayer fp = FawePlayer.wrap(player);
        if (fp.toggle("fawe.bypass")) {
            BBC.WORLDEDIT_BYPASSED.send(fp, new Object[0]);
        } else {
            BBC.WORLDEDIT_RESTRICTED.send(fp, new Object[0]);
        }
    }

    @Command(aliases={"/wer", "wer", "worldeditregion", "/worldeditregion", "select", "/select"}, desc="Select your current allowed region", help="Select your current allowed region")
    @CommandPermissions(value={"fawe.worldeditregion"})
    public void wer(Player player) throws WorldEditException {
        FawePlayer fp = FawePlayer.wrap(player);
        Region region = fp.getLargestRegion();
        if (region == null) {
            BBC.NO_REGION.send(fp, new Object[0]);
        } else {
            fp.setSelection(region);
            BBC.SET_REGION.send(fp, new Object[0]);
        }
    }

    @Command(aliases={"/move"}, usage="[count] [direction] [leave-id]", flags="s", desc="Move the contents of the selection", help="Moves the contents of the selection.\n  -s flag shifts the selection to the target location.\n  -b also copies biomes\n  -e ignores entities\n  -a ignores air\nOptionally fills the old location with <leave-id>.", min=0, max=3)
    @CommandPermissions(value={"worldedit.region.move"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public void move(FawePlayer player, LocalSession session, EditSession editSession, @Selection Region region, @Optional(value={"1"}) @Range(min=1.0) int count, @Optional(value={"me"}) @Direction Vector direction, @Optional(value={"air"}) Pattern replace, @Switch(value=98) boolean copyBiomes, @Switch(value=101) boolean skipEntities, @Switch(value=97) boolean skipAir, @Switch(value=115) boolean moveSelection, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.moveRegion(region, direction, count, !skipAir, !skipEntities, copyBiomes, replace);
            if (moveSelection) {
                try {
                    region.shift(direction.multiply(count));
                    session.getRegionSelector(player.getWorld()).learnChanges();
                    session.getRegionSelector(player.getWorld()).explainRegionAdjust(player.getPlayer(), session);
                }
                catch (RegionOperationException e) {
                    player.sendMessage(BBC.getPrefix() + e.getMessage());
                }
            }
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/fall"}, usage="[replace]", flags="m", desc="Have the blocks in the selection fall", help="Make the blocks in the selection fall\nThe -m flag will only fall within the vertical selection.", min=0, max=2)
    @CommandPermissions(value={"worldedit.region.fall"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public void fall(FawePlayer player, EditSession editSession, LocalSession session, @Selection Region region, @Optional(value={"air"}) BlockStateHolder replace, @Switch(value=109) boolean notFullHeight, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.fall(region, !notFullHeight, replace);
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/stack"}, usage="[count] [direction]", flags="sam", desc="Repeat the contents of the selection", help="Repeats the contents of the selection.\nFlags:\n  -s shifts the selection to the last stacked copy\n  -a skips air blocks", min=0, max=2)
    @CommandPermissions(value={"worldedit.region.stack"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public void stack(FawePlayer player, LocalSession session, EditSession editSession, @Selection Region region, @Optional(value={"1"}) @Range(min=1.0) int count, @Optional(value={"me"}) @Direction Vector direction, @Switch(value=115) boolean moveSelection, @Switch(value=98) boolean copyBiomes, @Switch(value=101) boolean skipEntities, @Switch(value=97) boolean ignoreAirBlocks, @Switch(value=109) Mask sourceMask, CommandContext context) throws WorldEditException {
        player.checkConfirmationStack(() -> {
            if (sourceMask != null) {
                editSession.addSourceMask(sourceMask);
            }
            int affected = editSession.stackCuboidRegion(region, direction, count, !ignoreAirBlocks, !skipEntities, copyBiomes);
            if (moveSelection) {
                try {
                    Vector size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
                    Vector shiftVector = new Vector(direction.getX() * size.getX() * (double)count, direction.getY() * size.getY() * (double)count, direction.getZ() * size.getZ() * (double)count);
                    region.shift(shiftVector);
                    session.getRegionSelector(player.getWorld()).learnChanges();
                    session.getRegionSelector(player.getWorld()).explainRegionAdjust(player.getPlayer(), session);
                }
                catch (RegionOperationException e) {
                    player.sendMessage(BBC.getPrefix() + e.getMessage());
                }
            }
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, count, context);
    }

    @Command(aliases={"/deform"}, usage="<expression>", desc="Deforms a selected region with an expression", help="Deforms a selected region with an expression\nThe expression is executed for each block and is expected\nto modify the variables x, y and z to point to a new block\nto fetch. See also tinyurl.com/wesyntax.", flags="ro", min=1, max=-1)
    @CommandPermissions(value={"worldedit.region.deform"})
    @Logging(value=Logging.LogMode.ALL)
    public void deform(FawePlayer fp, Player player, LocalSession session, EditSession editSession, @Selection Region region, @Text String expression, @Switch(value=114) boolean useRawCoords, @Switch(value=111) boolean offset, CommandContext context) throws WorldEditException {
        Vector unit;
        Vector zero;
        if (useRawCoords) {
            zero = Vector.ZERO;
            unit = Vector.ONE;
        } else if (offset) {
            zero = session.getPlacementPosition(player);
            unit = Vector.ONE;
        } else {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit.mutX(1);
            }
            if (unit.getY() == 0.0) {
                unit.mutY(1);
            }
            if (unit.getZ() == 0.0) {
                unit.mutZ(1);
            }
        }
        fp.checkConfirmationRegion(() -> {
            try {
                int affected = editSession.deformRegion(region, zero, unit, expression);
                player.findFreePosition();
                BBC.VISITOR_BLOCK.send(fp, affected);
            }
            catch (ExpressionException e) {
                fp.sendMessage(BBC.getPrefix() + e.getMessage());
            }
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/regen"}, usage="[biome] [seed]", desc="Regenerates the contents of the selection", help="Regenerates the contents of the current selection.\nThis command might affect things outside the selection,\nif they are within the same chunk.", min=0, max=2)
    @CommandPermissions(value={"worldedit.regen"})
    @Logging(value=Logging.LogMode.REGION)
    public void regenerateChunk(FawePlayer player, LocalSession session, EditSession editSession, @Selection Region region, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            Mask mask = session.getMask();
            Mask sourceMask = session.getSourceMask();
            session.setMask(null);
            session.setSourceMask(null);
            BaseBiome biome = null;
            if (context.argsLength() >= 1) {
                BiomeRegistry biomeRegistry = this.worldEdit.getPlatformManager().queryCapability(Capability.GAME_HOOKS).getRegistries().getBiomeRegistry();
                List<BaseBiome> knownBiomes = biomeRegistry.getBiomes();
                biome = Biomes.findBiomeByName(knownBiomes, context.getString(0), biomeRegistry);
            }
            Long seed = context.argsLength() != 2 || !MathMan.isInteger(context.getString(1)) ? null : Long.valueOf(Long.parseLong(context.getString(1)));
            editSession.regenerate(region, biome, seed);
            session.setMask(mask);
            session.setSourceMask(mask);
            if (!player.hasPermission("fawe.tips")) {
                BBC.COMMAND_REGEN_2.send(player, new Object[0]);
            } else if (biome == null) {
                BBC.COMMAND_REGEN_0.send(player, new Object[0]);
                if (!FawePlayer.wrap(player).hasPermission("fawe.tips")) {
                    BBC.TIP_REGEN_0.send(player, new Object[0]);
                }
            } else if (seed == null) {
                BBC.COMMAND_REGEN_1.send(player, new Object[0]);
                if (!FawePlayer.wrap(player).hasPermission("fawe.tips")) {
                    BBC.TIP_REGEN_1.send(player, new Object[0]);
                }
            } else {
                BBC.COMMAND_REGEN_2.send(player, new Object[0]);
            }
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/hollow"}, usage="[<thickness>[ <pattern>]]", desc="Hollows out the object contained in this selection", help="Hollows out the object contained in this selection.\nOptionally fills the hollowed out part with the given block.\nThickness is measured in manhattan distance.", min=0, max=2)
    @CommandPermissions(value={"worldedit.region.hollow"})
    @Logging(value=Logging.LogMode.REGION)
    public void hollow(FawePlayer player, EditSession editSession, @Selection Region region, @Optional(value={"0"}) @Range(min=0.0) int thickness, @Optional(value={"air"}) Pattern pattern, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            int affected = editSession.hollowOutRegion(region, thickness, pattern);
            BBC.VISITOR_BLOCK.send(player, affected);
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/forest"}, usage="[type] [density]", desc="Make a forest within the region", min=0, max=2)
    @CommandPermissions(value={"worldedit.region.forest"})
    @Logging(value=Logging.LogMode.REGION)
    public void forest(FawePlayer player, EditSession editSession, @Selection Region region, @Optional(value={"tree"}) TreeGenerator.TreeType type, @Optional(value={"5"}) @Range(min=0.0, max=100.0) double density, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            ForestGenerator generator = new ForestGenerator(editSession, type);
            GroundFunction ground = new GroundFunction(new ExistingBlockMask(editSession), generator);
            LayerVisitor visitor = new LayerVisitor(Regions.asFlatRegion(region), Regions.minimumBlockY(region), Regions.maximumBlockY(region), ground);
            visitor.setMask(new NoiseFilter2D(new RandomNoise(), density / 100.0));
            Operations.completeLegacy(visitor);
            BBC.COMMAND_TREE.send(player, ground.getAffected());
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/flora"}, usage="[density]", desc="Make flora within the region", min=0, max=1)
    @CommandPermissions(value={"worldedit.region.flora"})
    @Logging(value=Logging.LogMode.REGION)
    public void flora(FawePlayer player, EditSession editSession, @Selection Region region, @Optional(value={"10"}) @Range(min=0.0, max=100.0) double density, CommandContext context) throws WorldEditException {
        player.checkConfirmationRegion(() -> {
            FloraGenerator generator = new FloraGenerator(editSession);
            GroundFunction ground = new GroundFunction(new ExistingBlockMask(editSession), generator);
            LayerVisitor visitor = new LayerVisitor(Regions.asFlatRegion(region), Regions.minimumBlockY(region), Regions.maximumBlockY(region), ground);
            visitor.setMask(new NoiseFilter2D(new RandomNoise(), density / 100.0));
            Operations.completeLegacy(visitor);
            BBC.COMMAND_FLORA.send(player, ground.getAffected());
        }, this.getArguments(context), region, context);
    }
}

