/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.NotABlockException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitEntity;
import com.sk89q.worldedit.bukkit.BukkitItemStack;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public interface IBukkitAdapter {
    default public boolean equals(BlockType blockType, Material type) {
        return blockType == this.asItemType(type).getBlockType();
    }

    default public BukkitWorld asBukkitWorld(World world) {
        if (world instanceof BukkitWorld) {
            return (BukkitWorld)world;
        }
        BukkitWorld bukkitWorld = WorldEditPlugin.getInstance().getInternalPlatform().matchWorld(world);
        if (bukkitWorld == null) {
            throw new RuntimeException("World '" + world.getName() + "' has no matching version in Bukkit");
        }
        return bukkitWorld;
    }

    default public World adapt(org.bukkit.World world) {
        Preconditions.checkNotNull((Object)world);
        return new BukkitWorld(world);
    }

    default public org.bukkit.World adapt(World world) {
        Preconditions.checkNotNull((Object)world);
        if (world instanceof BukkitWorld) {
            return ((BukkitWorld)world).getWorld();
        }
        org.bukkit.World match = Bukkit.getServer().getWorld(world.getName());
        if (match != null) {
            return match;
        }
        throw new IllegalArgumentException("Can't find a Bukkit world for " + world);
    }

    default public com.sk89q.worldedit.util.Location adapt(Location location) {
        Preconditions.checkNotNull((Object)location);
        Vector position = this.asVector(location);
        return new com.sk89q.worldedit.util.Location((Extent)this.adapt(location.getWorld()), position, location.getYaw(), location.getPitch());
    }

    default public Location adapt(com.sk89q.worldedit.util.Location location) {
        Preconditions.checkNotNull((Object)location);
        Vector position = location.toVector();
        return new Location(this.adapt((World)location.getExtent()), position.getX(), position.getY(), position.getZ(), location.getYaw(), location.getPitch());
    }

    default public Location adapt(org.bukkit.World world, Vector position) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)position);
        return new Location(world, position.getX(), position.getY(), position.getZ());
    }

    default public Location adapt(org.bukkit.World world, com.sk89q.worldedit.util.Location location) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)location);
        return new Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    default public Vector asVector(Location location) {
        Preconditions.checkNotNull((Object)location);
        return new Vector(location.getX(), location.getY(), location.getZ());
    }

    default public Entity adapt(org.bukkit.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        return new BukkitEntity(entity);
    }

    default public Material adapt(ItemType itemType) {
        Preconditions.checkNotNull((Object)itemType);
        if (!itemType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports Minecraft items");
        }
        return Material.getMaterial((String)itemType.getId().substring(10).toUpperCase());
    }

    default public Material adapt(BlockType blockType) {
        Preconditions.checkNotNull((Object)blockType);
        if (!blockType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports Minecraft blocks");
        }
        String id = blockType.getId().substring(10).toUpperCase();
        return Material.getMaterial((String)id);
    }

    default public GameMode adapt(org.bukkit.GameMode gameMode) {
        Preconditions.checkNotNull((Object)gameMode);
        return GameModes.get(gameMode.name().toLowerCase());
    }

    default public com.sk89q.worldedit.world.entity.EntityType adapt(EntityType entityType) {
        return EntityTypes.get(entityType.getName().toLowerCase());
    }

    default public EntityType adapt(com.sk89q.worldedit.world.entity.EntityType entityType) {
        if (!entityType.getId().startsWith("minecraft:")) {
            throw new IllegalArgumentException("Bukkit only supports vanilla entities");
        }
        return EntityType.fromName((String)entityType.getId().substring(10).toLowerCase());
    }

    default public BlockType asBlockType(Material material) {
        Preconditions.checkNotNull((Object)material);
        if (!material.isBlock()) {
            throw new IllegalArgumentException(material.getKey().toString() + " is not a block!"){

                @Override
                public synchronized Throwable fillInStackTrace() {
                    return this;
                }
            };
        }
        return BlockTypes.get(material.getKey().toString());
    }

    public ItemType asItemType(Material var1);

    public BlockState adapt(BlockData var1);

    public BlockTypes adapt(Material var1);

    public BlockData adapt(BlockStateHolder var1);

    default public BlockData getBlockData(int combinedId) {
        return this.adapt(BlockState.getFromInternalId(combinedId));
    }

    default public BlockState asBlockState(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        if (itemStack.getType().isBlock()) {
            return this.adapt(itemStack.getType().createBlockData());
        }
        throw new NotABlockException();
    }

    default public BaseItemStack adapt(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack);
        return new BukkitItemStack(itemStack);
    }

    default public ItemStack adapt(BaseItemStack item) {
        Preconditions.checkNotNull((Object)item);
        if (item instanceof BukkitItemStack) {
            return ((BukkitItemStack)item).getBukkitItemStack();
        }
        return new ItemStack(this.adapt(item.getType()), item.getAmount());
    }

    default public BukkitPlayer adapt(org.bukkit.entity.Player player) {
        return WorldEditPlugin.getInstance().wrapPlayer(player);
    }

    default public org.bukkit.entity.Player adapt(Player player) {
        return ((BukkitPlayer)player).getPlayer();
    }
}

