/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.registry.LegacyMapper;
import java.util.Objects;
import javax.annotation.Nullable;

public class BaseBlock
extends BlockState {
    private final BlockState blockState;
    @Nullable
    protected CompoundTag nbtData;

    @Deprecated
    public BaseBlock() {
        this(BlockTypes.AIR.getDefaultState());
    }

    @Deprecated
    public BaseBlock(BlockStateHolder blockState) {
        this(blockState, blockState.getNbtData());
    }

    @Deprecated
    public BaseBlock(BlockTypes id) {
        this(id.getDefaultState());
    }

    @Deprecated
    public BaseBlock(BlockType blockType) {
        this(blockType.getDefaultState());
    }

    public BaseBlock(BlockStateHolder state, @Nullable CompoundTag nbtData) {
        this.blockState = state.toImmutableState();
        this.nbtData = nbtData;
    }

    @Deprecated
    public BaseBlock(int id, int data) {
        this(BaseBlock.getState(id, data));
    }

    private static final BlockState getState(int id, int data) {
        BlockState blockState = LegacyMapper.getInstance().getBlockFromLegacy(id, data);
        if (blockState == null) {
            blockState = BlockTypes.AIR.getDefaultState();
        }
        return blockState;
    }

    protected BaseBlock(int internalId, CompoundTag nbtData) {
        this(BlockState.getFromInternalId(internalId), nbtData);
    }

    @Deprecated
    public static BaseBlock getFromInternalId(int id, CompoundTag nbtData) {
        return new BaseBlock(id, nbtData);
    }

    @Deprecated
    public BaseBlock(BaseBlock other) {
        this(other.toImmutableState(), other.getNbtData());
    }

    @Override
    public BlockState toFuzzy() {
        return this.blockState;
    }

    @Override
    public String getNbtId() {
        CompoundTag nbtData = this.getNbtData();
        if (nbtData == null) {
            return "";
        }
        Tag idTag = (Tag)nbtData.getValue().get("id");
        if (idTag instanceof StringTag) {
            return ((StringTag)idTag).getValue();
        }
        return "";
    }

    @Override
    @Nullable
    public CompoundTag getNbtData() {
        return this.nbtData;
    }

    @Override
    public void setNbtData(@Nullable CompoundTag nbtData) {
        this.nbtData = nbtData;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BaseBlock)) {
            return false;
        }
        BaseBlock otherBlock = (BaseBlock)o;
        return this.equals(otherBlock) && Objects.equals(this.getNbtData(), otherBlock.getNbtData());
    }

    @Override
    public final BlockState toImmutableState() {
        return this.blockState;
    }

    @Override
    public int getInternalId() {
        return this.blockState.getInternalId();
    }

    @Override
    public BlockMaterial getMaterial() {
        return this.blockState.getMaterial();
    }

    @Override
    public BlockTypes getBlockType() {
        return this.blockState.getBlockType();
    }

    @Override
    public int getOrdinal() {
        return this.blockState.getOrdinal();
    }

    @Override
    public int hashCode() {
        return this.getOrdinal();
    }

    @Override
    public String toString() {
        if (this.getNbtData() != null) {
            return this.getAsString() + " {" + String.valueOf(this.getNbtData()) + "}";
        }
        return this.getAsString();
    }
}

