/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.boydti.fawe.jnbt.NBTStreamer;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.NamedData;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class NBTInputStream
implements Closeable {
    private final DataInputStream is;
    private byte[] buf;

    public NBTInputStream(InputStream is) throws IOException {
        this.is = new DataInputStream(is);
    }

    public NBTInputStream(DataInputStream dis) {
        this.is = dis;
    }

    public DataInputStream getInputStream() {
        return this.is;
    }

    public NamedTag readNamedTag() throws IOException {
        return this.readNamedTag(0);
    }

    public NamedData readNamedData() throws IOException {
        return this.readNamedData(0);
    }

    private NamedTag readNamedTag(int depth) throws IOException {
        int type = this.is.readByte() & 0xFF;
        return new NamedTag(this.readNamedTagName(type), this.readTagPayload(type, depth));
    }

    private NamedData readNamedData(int depth) throws IOException {
        byte type = this.is.readByte();
        return new NamedData<Object>(this.readNamedTagName(type), this.readDataPayload(type, depth));
    }

    public Tag readTag() throws IOException {
        byte type = this.is.readByte();
        return this.readTagPayload(type, 0);
    }

    public Object readData() throws IOException {
        byte type = this.is.readByte();
        return this.readDataPayload(type, 0);
    }

    public void readNamedTagLazy(Function<String, BiConsumer> getReader) throws IOException {
        byte type = this.is.readByte();
        String name = this.readNamedTagName(type);
        BiConsumer reader = getReader.apply(name);
        if (reader != null) {
            reader.accept(0, this.readTagPaylodRaw(type, 0));
            return;
        }
        this.readTagPaylodLazy(type, 0, name, getReader);
    }

    public String readNamedTagName(int type) throws IOException {
        if (type != 0) {
            int nameLength = this.is.readShort() & 0xFFFF;
            byte[] nameBytes = new byte[nameLength];
            this.is.readFully(nameBytes);
            return new String(nameBytes, NBTConstants.CHARSET);
        }
        return "";
    }

    public void readTagPaylodLazy(int type, int depth, String node, Function<String, BiConsumer> getReader) throws IOException {
        switch (type) {
            case 0: {
                return;
            }
            case 1: {
                this.is.skipBytes(1);
                return;
            }
            case 2: {
                this.is.skipBytes(2);
                return;
            }
            case 3: {
                this.is.skipBytes(4);
                return;
            }
            case 4: {
                this.is.skipBytes(8);
                return;
            }
            case 5: {
                this.is.skipBytes(4);
                return;
            }
            case 6: {
                this.is.skipBytes(8);
                return;
            }
            case 8: {
                short length = this.is.readShort();
                this.is.skipBytes(length);
                return;
            }
            case 7: {
                BiConsumer reader = getReader.apply(node + ".?");
                int length = this.is.readInt();
                if (reader != null) {
                    reader.accept(length, 1);
                }
                if ((reader = getReader.apply(node + ".#")) == null) {
                    this.is.skipBytes(length);
                    return;
                }
                if (reader instanceof NBTStreamer.ByteReader) {
                    NBTStreamer.ByteReader byteReader = (NBTStreamer.ByteReader)reader;
                    int i = 0;
                    if (this.is instanceof InputStream) {
                        DataInputStream dis = this.is;
                        if (length > 1024) {
                            if (this.buf == null) {
                                this.buf = new byte[1024];
                            }
                            for (int left = length; left > 1024; left -= 1024) {
                                dis.readFully(this.buf);
                                for (byte b : this.buf) {
                                    byteReader.run(i++, b & 0xFF);
                                }
                            }
                        }
                        while (i < length) {
                            byteReader.run(i, dis.read());
                            ++i;
                        }
                    } else {
                        if (length > 1024) {
                            if (this.buf == null) {
                                this.buf = new byte[1024];
                            }
                            for (int left = length; left > 1024; left -= 1024) {
                                this.is.readFully(this.buf);
                                for (byte b : this.buf) {
                                    byteReader.run(i++, b & 0xFF);
                                }
                            }
                        }
                        while (i < length) {
                            byteReader.run(i, this.is.readByte() & 0xFF);
                            ++i;
                        }
                    }
                } else if (reader instanceof NBTStreamer.LazyReader) {
                    reader.accept(length, this.is);
                } else {
                    for (int i = 0; i < length; ++i) {
                        reader.accept(i, this.is.readByte());
                    }
                }
                return;
            }
            case 9: {
                int childType = this.is.readByte();
                if (childType == 9) {
                    childType = 10;
                }
                int length = this.is.readInt();
                BiConsumer reader = getReader.apply(node + ".?");
                if (reader != null) {
                    reader.accept(length, childType);
                }
                node = node + ".#";
                reader = getReader.apply(node);
                ++depth;
                if (reader == null) {
                    for (int i = 0; i < length; ++i) {
                        this.readTagPaylodLazy(childType, depth, node, getReader);
                    }
                    return;
                }
                for (int i = 0; i < length; ++i) {
                    reader.accept(i, this.readTagPayload(childType, depth));
                }
                return;
            }
            case 10: {
                ++depth;
                int i = 0;
                while (true) {
                    byte childType;
                    if ((childType = this.is.readByte()) == 0) {
                        return;
                    }
                    String name = this.readNamedTagName(childType);
                    String childNode = node + "." + name;
                    BiConsumer reader = getReader.apply(childNode);
                    if (reader == null) {
                        this.readTagPaylodLazy(childType, depth, childNode, getReader);
                    } else {
                        reader.accept(i, this.readTagPaylodRaw(childType, depth));
                    }
                    ++i;
                }
            }
            case 11: {
                int length = this.is.readInt();
                BiConsumer reader = getReader.apply(node + ".?");
                if (reader != null) {
                    reader.accept(length, 3);
                }
                if ((reader = getReader.apply(node + ".#")) == null) {
                    this.is.skipBytes(length << 2);
                    return;
                }
                if (reader instanceof NBTStreamer.ByteReader) {
                    NBTStreamer.ByteReader byteReader = (NBTStreamer.ByteReader)reader;
                    for (int i = 0; i < length; ++i) {
                        byteReader.run(i, this.is.readInt());
                    }
                } else if (reader instanceof NBTStreamer.LazyReader) {
                    reader.accept(length, this.is);
                } else {
                    for (int i = 0; i < length; ++i) {
                        reader.accept(i, this.is.readInt());
                    }
                }
                return;
            }
            case 12: {
                int length = this.is.readInt();
                BiConsumer reader = getReader.apply(node + ".?");
                if (reader != null) {
                    reader.accept(length, 4);
                }
                if ((reader = getReader.apply(node + ".#")) == null) {
                    this.is.skipBytes(length << 3);
                    return;
                }
                if (reader instanceof NBTStreamer.LongReader) {
                    NBTStreamer.LongReader longReader = (NBTStreamer.LongReader)reader;
                    for (int i = 0; i < length; ++i) {
                        longReader.run(i, this.is.readLong());
                    }
                } else if (reader instanceof NBTStreamer.LazyReader) {
                    reader.accept(length, this.is);
                } else {
                    for (int i = 0; i < length; ++i) {
                        reader.accept(i, this.is.readLong());
                    }
                }
                return;
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    public static int getSize(int type) {
        switch (type) {
            default: {
                return 1;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return 2;
            }
            case 3: 
            case 5: {
                return 4;
            }
            case 4: 
            case 6: 
        }
        return 8;
    }

    private Object readTagPaylodRaw(int type, int depth) throws IOException {
        switch (type) {
            case 0: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return null;
            }
            case 1: {
                return this.is.readByte();
            }
            case 2: {
                return this.is.readShort();
            }
            case 3: {
                return this.is.readInt();
            }
            case 4: {
                return this.is.readLong();
            }
            case 5: {
                return Float.valueOf(this.is.readFloat());
            }
            case 6: {
                return this.is.readDouble();
            }
            case 7: {
                int length = this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return bytes;
            }
            case 8: {
                short length = this.is.readShort();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new String(bytes, NBTConstants.CHARSET);
            }
            case 9: {
                int childType = this.is.readByte();
                if (childType == 9) {
                    childType = 10;
                }
                int length = this.is.readInt();
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                for (int i = 0; i < length; ++i) {
                    Tag tag = this.readTagPayload(childType, depth + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    tagList.add(tag);
                }
                return tagList;
            }
            case 10: {
                NamedTag namedTag;
                Tag tag;
                HashMap<String, Tag> tagMap = new HashMap<String, Tag>();
                while (!((tag = (namedTag = this.readNamedTag(depth + 1)).getTag()) instanceof EndTag)) {
                    tagMap.put(namedTag.getName(), tag);
                }
                return tagMap;
            }
            case 11: {
                int length = this.is.readInt();
                int[] data = new int[length];
                if (this.buf == null) {
                    this.buf = new byte[1024];
                }
                int index = 0;
                while (length > 0) {
                    int toRead = Math.min(length << 2, this.buf.length);
                    this.is.readFully(this.buf, 0, toRead);
                    int i = 0;
                    while (i < toRead) {
                        data[index] = (this.buf[i] << 24) + (this.buf[i + 1] << 16) + (this.buf[i + 2] << 8) + this.buf[i + 3];
                        i += 4;
                        ++index;
                    }
                    length -= toRead;
                }
                return data;
            }
            case 12: {
                int length = this.is.readInt();
                long[] data = new long[length];
                if (this.buf == null) {
                    this.buf = new byte[1024];
                }
                int index = 0;
                while (length > 0) {
                    int toRead = Math.min(length << 3, this.buf.length);
                    this.is.readFully(this.buf, 0, toRead);
                    int i = 0;
                    while (i < toRead) {
                        data[index] = (long)this.buf[i] << 56 | (long)this.buf[i + 1] << 48 | (long)this.buf[i + 2] << 40 | (long)this.buf[i + 3] << 32 | (long)(this.buf[i + 4] << 24) | (long)(this.buf[i + 5] << 16) | (long)(this.buf[i + 6] << 8) | (long)this.buf[i + 7];
                        i += 8;
                        ++index;
                    }
                    length -= toRead;
                }
                return data;
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    public Object readDataPayload(int type, int depth) throws IOException {
        switch (type) {
            case 0: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return null;
            }
            case 1: {
                return this.is.readByte();
            }
            case 2: {
                return this.is.readShort();
            }
            case 3: {
                return this.is.readInt();
            }
            case 4: {
                return this.is.readLong();
            }
            case 5: {
                return Float.valueOf(this.is.readFloat());
            }
            case 6: {
                return this.is.readDouble();
            }
            case 7: {
                int length = this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return bytes;
            }
            case 8: {
                short length = this.is.readShort();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new String(bytes, NBTConstants.CHARSET);
            }
            case 9: {
                int childType = this.is.readByte();
                if (childType == 9) {
                    childType = 10;
                }
                int length = this.is.readInt();
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < length; ++i) {
                    Object obj = this.readDataPayload(childType, depth + 1);
                    if (obj == null) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    list.add(obj);
                }
                return list;
            }
            case 10: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                while (true) {
                    byte newType = this.is.readByte();
                    String name = this.readNamedTagName(newType);
                    Object data = this.readDataPayload(newType, depth + 1);
                    if (data == null) break;
                    map.put(name, data);
                }
                return map;
            }
            case 11: {
                int length = this.is.readInt();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.is.readInt();
                }
                return data;
            }
            case 12: {
                int length = this.is.readInt();
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.is.readLong();
                }
                return data;
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    public Tag readTagPayload(int type, int depth) throws IOException {
        switch (type) {
            case 0: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return EndTag.INSTANCE;
            }
            case 1: {
                return new ByteTag(this.is.readByte());
            }
            case 2: {
                return new ShortTag(this.is.readShort());
            }
            case 3: {
                return new IntTag(this.is.readInt());
            }
            case 4: {
                return new LongTag(this.is.readLong());
            }
            case 5: {
                return new FloatTag(this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(this.is.readDouble());
            }
            case 7: {
                int length = this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new ByteArrayTag(bytes);
            }
            case 8: {
                short length = this.is.readShort();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new StringTag(new String(bytes, NBTConstants.CHARSET));
            }
            case 9: {
                int childType = this.is.readByte();
                if (childType == 9) {
                    childType = 10;
                }
                int length = this.is.readInt();
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                for (int i = 0; i < length; ++i) {
                    Tag tag = this.readTagPayload(childType, depth + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    tagList.add(tag);
                }
                return new ListTag<Tag>(NBTUtils.getTypeClass(childType), tagList);
            }
            case 10: {
                NamedTag namedTag;
                Tag tag;
                HashMap<String, Tag> tagMap = new HashMap<String, Tag>();
                while (!((tag = (namedTag = this.readNamedTag(depth + 1)).getTag()) instanceof EndTag)) {
                    tagMap.put(namedTag.getName(), tag);
                }
                return new CompoundTag(tagMap);
            }
            case 11: {
                int length = this.is.readInt();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.is.readInt();
                }
                return new IntArrayTag(data);
            }
            case 12: {
                int length = this.is.readInt();
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.is.readLong();
                }
                return new LongArrayTag(data);
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    @Override
    public void close() throws IOException {
        if (this.is instanceof AutoCloseable) {
            try {
                this.is.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

