/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class StringMan {
    public static String replaceFromMap(String string, Map<String, String> replacements) {
        StringBuilder sb = new StringBuilder(string);
        int size = string.length();
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            if (size == 0) break;
            String key = entry.getKey();
            String value = entry.getValue();
            int start = sb.indexOf(key, 0);
            while (start > -1) {
                int end = start + key.length();
                int nextSearchStart = start + value.length();
                sb.replace(start, end, value);
                size -= end - start;
                start = sb.indexOf(key, nextSearchStart);
            }
        }
        return sb.toString();
    }

    public static boolean containsAny(CharSequence sequence, String any) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (any.indexOf(sequence.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static int findMatchingBracket(CharSequence sequence, int index) {
        char startC = sequence.charAt(index);
        char lookC = StringMan.getMatchingBracket(startC);
        if (lookC == startC) {
            return -1;
        }
        boolean forward = StringMan.isBracketForwards(startC);
        int increment = forward ? 1 : -1;
        int end = forward ? sequence.length() : -1;
        int count = 0;
        for (int i = index + increment; i != end; i += increment) {
            char c = sequence.charAt(i);
            if (c == startC) {
                ++count;
                continue;
            }
            if (c != lookC || count-- != 0) continue;
            return i;
        }
        return -1;
    }

    public static String prettyFormat(double d) {
        if (d == Double.MIN_VALUE) {
            return "-\u221e";
        }
        if (d == Double.MAX_VALUE) {
            return "\u221e";
        }
        if (d == (double)((long)d)) {
            return String.format("%d", (long)d);
        }
        return String.format("%s", d);
    }

    public static boolean isBracketForwards(char c) {
        switch (c) {
            case '(': 
            case '<': 
            case '[': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    public static char getMatchingBracket(char c) {
        switch (c) {
            case '[': {
                return ']';
            }
            case '(': {
                return ')';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
            case ']': {
                return '[';
            }
            case ')': {
                return '(';
            }
            case '}': {
                return '{';
            }
            case '>': {
                return '<';
            }
        }
        return c;
    }

    public static int parseInt(CharSequence string) {
        int val = 0;
        boolean neg = false;
        int numIndex = 1;
        int len = string.length();
        block3: for (int i = len - 1; i >= 0; --i) {
            char c = string.charAt(i);
            switch (c) {
                case '-': {
                    val = -val;
                    continue block3;
                }
                default: {
                    val += (c - 48) * numIndex;
                    numIndex *= 10;
                }
            }
        }
        return val;
    }

    public static String removeFromSet(String string, Collection<String> replacements) {
        StringBuilder sb = new StringBuilder(string);
        int size = string.length();
        for (String key : replacements) {
            if (size == 0) break;
            int start = sb.indexOf(key, 0);
            while (start > -1) {
                int end = start + key.length();
                int nextSearchStart = start + 0;
                sb.delete(start, end);
                size -= end - start;
                start = sb.indexOf(key, nextSearchStart);
            }
        }
        return sb.toString();
    }

    public static int indexOf(String input, int start, char ... values) {
        for (int i = start; i < input.length(); ++i) {
            for (char c : values) {
                if (c != input.charAt(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static List<String> split(String input, char delim) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int bracket = 0;
        boolean inQuotes = false;
        for (int current = 0; current < input.length(); ++current) {
            boolean atLastChar;
            char currentChar = input.charAt(current);
            boolean bl = atLastChar = current == input.length() - 1;
            if (!atLastChar && (bracket > 0 || currentChar == '{' && ++bracket > 0 || current == 125 && --bracket <= 0)) continue;
            if (currentChar == '\"') {
                boolean bl2 = inQuotes = !inQuotes;
            }
            if (atLastChar) {
                result.add(input.substring(start));
                continue;
            }
            if (currentChar != delim || inQuotes) continue;
            String toAdd = input.substring(start, current);
            if (toAdd.startsWith("\"")) {
                toAdd = toAdd.substring(1, toAdd.length() - 1);
            }
            result.add(toAdd);
            start = current + 1;
        }
        return result;
    }

    public static int intersection(Set<String> options, String[] toCheck) {
        int count = 0;
        for (String check : toCheck) {
            if (!options.contains(check)) continue;
            ++count;
        }
        return count;
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static String getString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        if (obj.getClass().isArray()) {
            String result = "";
            String prefix = "";
            for (int i = 0; i < Array.getLength(obj); ++i) {
                result = result + prefix + StringMan.getString(Array.get(obj, i));
                prefix = ",";
            }
            return "{ " + result + " }";
        }
        if (obj instanceof Collection) {
            String result = "";
            String prefix = "";
            for (Object element : (Collection)obj) {
                result = result + prefix + StringMan.getString(element);
                prefix = ",";
            }
            return "( " + result + " )";
        }
        return obj.toString();
    }

    public static String replaceFirst(char c, String s) {
        if (s == null) {
            return "";
        }
        if (s.isEmpty()) {
            return s;
        }
        char[] chars = s.toCharArray();
        char[] newChars = new char[chars.length];
        int used = 0;
        boolean found = false;
        for (char cc : chars) {
            if (!found && c == cc) {
                found = true;
                continue;
            }
            newChars[used++] = cc;
        }
        if (found) {
            chars = new char[newChars.length - 1];
            System.arraycopy(newChars, 0, chars, 0, chars.length);
            return String.valueOf(chars);
        }
        return s;
    }

    public static String replaceAll(String string, Object ... pairs) {
        StringBuilder sb = new StringBuilder(string);
        for (int i = 0; i < pairs.length; i += 2) {
            String key = pairs[i] + "";
            String value = pairs[i + 1] + "";
            int start = sb.indexOf(key, 0);
            while (start > -1) {
                int end = start + key.length();
                int nextSearchStart = start + value.length();
                sb.replace(start, end, value);
                start = sb.indexOf(key, nextSearchStart);
            }
        }
        return sb.toString();
    }

    public static boolean isAlphanumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!(c < '0' || c >= ':' && c <= '@' || c > 'Z' && c <= '`') && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericUnd(CharSequence str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!(c < '0' || c >= ':' && c <= '@' || c > 'Z' && c <= '`' || c > 'z') && c != '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c > '@' && (c <= 'Z' || c > '`') && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> collection, String delimiter) {
        return StringMan.join(collection.toArray(), delimiter);
    }

    public static String joinOrdered(Collection<?> collection, String delimiter) {
        Object[] array = collection.toArray();
        Arrays.sort(array, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return a.hashCode() - b.hashCode();
            }
        });
        return StringMan.join(array, delimiter);
    }

    public static String join(Collection<?> collection, char delimiter) {
        return StringMan.join(collection.toArray(), delimiter + "");
    }

    public static boolean isAsciiPrintable(char c) {
        return c >= ' ' && c < '\u007f';
    }

    public static boolean isAsciiPrintable(String s) {
        for (char c : s.toCharArray()) {
            if (StringMan.isAsciiPrintable(c)) continue;
            return false;
        }
        return true;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        if (n > m) {
            String tmp = s;
            s = t;
            t = tmp;
            n = m;
            m = t.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static <T> String join(Collection<T> arr, String delimiter, Function<T, String> funx) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (T obj : arr) {
            if (i > 0) {
                result.append(delimiter);
            }
            result.append(funx.apply(obj));
            ++i;
        }
        return result.toString();
    }

    public static String join(Object[] array, String delimiter) {
        switch (array.length) {
            case 0: {
                return "";
            }
            case 1: {
                return array[0].toString();
            }
        }
        StringBuilder result = new StringBuilder();
        int j = array.length;
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                result.append(delimiter);
            }
            result.append(array[i]);
        }
        return result.toString();
    }

    public static Integer toInteger(String string, int start, int end) {
        boolean negative;
        int value = 0;
        char char0 = string.charAt(0);
        if (char0 == '-') {
            negative = true;
            ++start;
        } else {
            negative = false;
        }
        block3: for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = value * 10 + c - 48;
                    continue block3;
                }
                default: {
                    return null;
                }
            }
        }
        return negative ? -value : value;
    }

    public static String join(int[] array, String delimiter) {
        Object[] wrapped = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            wrapped[i] = array[i];
        }
        return StringMan.join(wrapped, delimiter);
    }

    public static boolean isEqualToAny(String a, String ... args) {
        for (String arg : args) {
            if (!StringMan.isEqual(a, arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualIgnoreCaseToAny(String a, String ... args) {
        for (String arg : args) {
            if (!StringMan.isEqualIgnoreCase(a, arg)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqual(String a, String b) {
        return a == b || a != null && b != null && a.length() == b.length() && a.hashCode() == b.hashCode() && a.equals(b);
    }

    public static boolean isEqualIgnoreCase(String a, String b) {
        return a == b || a != null && b != null && a.length() == b.length() && a.equalsIgnoreCase(b);
    }

    public static String repeat(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }
}

