/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.util.DelegateTextureUtil;
import com.boydti.fawe.util.TextureUtil;
import com.sk89q.worldedit.world.block.BlockTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileNotFoundException;

public class CachedTextureUtil
extends DelegateTextureUtil {
    private final TextureUtil parent;
    private transient Int2ObjectOpenHashMap<BlockTypes> colorBlockMap;
    private transient Int2ObjectOpenHashMap<Integer> colorBiomeMap;
    private transient Int2ObjectOpenHashMap<BlockTypes[]> colorLayerMap;

    public CachedTextureUtil(TextureUtil parent) throws FileNotFoundException {
        super(parent);
        this.parent = parent;
        this.colorBlockMap = new Int2ObjectOpenHashMap();
        this.colorLayerMap = new Int2ObjectOpenHashMap();
        this.colorBiomeMap = new Int2ObjectOpenHashMap();
    }

    @Override
    public BlockTypes[] getNearestLayer(int color) {
        BlockTypes[] closest = this.colorLayerMap.get(color);
        if (closest != null) {
            return closest;
        }
        closest = this.parent.getNearestLayer(color);
        if (closest != null) {
            this.colorLayerMap.put(color, (BlockTypes[])closest.clone());
        }
        return closest;
    }

    @Override
    public TextureUtil.BiomeColor getNearestBiome(int color) {
        Integer value = this.colorBiomeMap.get(color);
        if (value != null) {
            return this.getBiome(value);
        }
        TextureUtil.BiomeColor result = this.parent.getNearestBiome(color);
        if (result != null) {
            this.colorBiomeMap.put(color, (Integer)result.id);
        }
        return result;
    }

    @Override
    public BlockTypes getNearestBlock(int color) {
        BlockTypes value = this.colorBlockMap.get(color);
        if (value != null) {
            return value;
        }
        BlockTypes result = this.parent.getNearestBlock(color);
        if (result != null) {
            this.colorBlockMap.put(color, result);
        }
        return result;
    }
}

