/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.schematic;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.FaweCache;
import com.boydti.fawe.util.ReflectionUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.storage.NBTConversions;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class StructureFormat
implements ClipboardReader,
ClipboardWriter {
    private static final int WARN_SIZE = 32;
    private NBTInputStream in;
    private NBTOutputStream out;

    public StructureFormat(NBTInputStream in) {
        this.in = in;
    }

    public StructureFormat(NBTOutputStream out) {
        this.out = out;
    }

    @Override
    public Clipboard read() throws IOException {
        return this.read(UUID.randomUUID());
    }

    @Override
    public Clipboard read(UUID clipboardId) throws IOException {
        ListTag entities;
        NamedTag rootTag = this.in.readNamedTag();
        if (!rootTag.getName().equals("")) {
            throw new IOException("Root tag does not exist or is not first");
        }
        Object tags = ((CompoundTag)rootTag.getTag()).getValue();
        ListTag size = (ListTag)tags.get("size");
        int width = size.getInt(0);
        int height = size.getInt(1);
        int length = size.getInt(2);
        Vector origin = new Vector(0, 0, 0);
        CuboidRegion region = new CuboidRegion(origin, origin.add(width, height, length).subtract(Vector.ONE));
        BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region, clipboardId);
        ListTag blocks = (ListTag)tags.get("blocks");
        if (blocks != null) {
            List palette = (List)((Tag)tags.get("palette")).getValue();
            BlockState[] combinedArray = new BlockState[palette.size()];
            for (int i = 0; i < palette.size(); ++i) {
                CompoundTag compound = (CompoundTag)palette.get(i);
                Object map = compound.getValue();
                String name = ((StringTag)map.get("Name")).getValue();
                BlockTypes type = BlockTypes.get(name);
                BlockStateHolder<BlockState> state = type.getDefaultState();
                if (type == null) {
                    Fawe.debug("Unknown block: " + name);
                    continue;
                }
                CompoundTag properties = (CompoundTag)map.get("Properties");
                if (properties != null) {
                    for (Map.Entry entry : properties.getValue().entrySet()) {
                        String key = (String)entry.getKey();
                        String value = ((StringTag)entry.getValue()).getValue();
                        Property property = type.getProperty(key);
                        state = state.with(property, property.getValueFor(value));
                    }
                }
                combinedArray[i] = state;
            }
            List blocksList = (List)((Tag)tags.get("blocks")).getValue();
            try {
                for (CompoundTag compound : blocksList) {
                    CompoundTag nbt;
                    Object blockMap = compound.getValue();
                    IntTag stateTag = (IntTag)blockMap.get("state");
                    ListTag posTag = (ListTag)blockMap.get("pos");
                    BlockState state = combinedArray[stateTag.getValue()];
                    int x = posTag.getInt(0);
                    int y = posTag.getInt(1);
                    int z = posTag.getInt(2);
                    if (state.getBlockType().getMaterial().hasContainer() && (nbt = (CompoundTag)blockMap.get("nbt")) != null) {
                        BaseBlock block = new BaseBlock(state, nbt);
                        clipboard.setBlock(x, y, z, block);
                        continue;
                    }
                    clipboard.setBlock(x, y, z, state);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((entities = (ListTag)tags.get("entities")) != null) {
            Object entityList = entities.getValue();
            Iterator iterator = entityList.iterator();
            while (iterator.hasNext()) {
                CompoundTag entityEntry = (CompoundTag)iterator.next();
                Object entityEntryMap = entityEntry.getValue();
                ListTag posTag = (ListTag)entityEntryMap.get("pos");
                CompoundTag nbtTag = (CompoundTag)entityEntryMap.get("nbt");
                String id = nbtTag.getString("Id");
                Location location = NBTConversions.toLocation(clipboard, posTag, nbtTag.getListTag("Rotation"));
                if (id.isEmpty()) continue;
                BaseEntity state = new BaseEntity(EntityTypes.get(id), nbtTag);
                clipboard.createEntity(location, state);
            }
        }
        return clipboard;
    }

    @Override
    public void write(Clipboard clipboard) throws IOException {
        this.write(clipboard, "FAWE");
    }

    public void write(Clipboard clipboard, String owner) throws IOException {
        Region region = clipboard.getRegion();
        int width = region.getWidth();
        int height = region.getHeight();
        int length = region.getLength();
        if (width > 32 || height > 32 || length > 32) {
            Fawe.debug("A structure longer than 32 is unsupported by minecraft (but probably still works)");
        }
        Map<String, Object> structure = FaweCache.asMap("version", 1, "author", owner);
        MutableBlockVector mutable = new MutableBlockVector(0, 0, 0);
        Int2ObjectArrayMap<Integer> indexes = new Int2ObjectArrayMap<Integer>();
        structure.put("size", Arrays.asList(width, height, length));
        ArrayList palette = new ArrayList();
        block6: for (Vector vector : region) {
            BlockState block = clipboard.getBlock(vector);
            int combined = block.getInternalId();
            BlockTypes type = block.getBlockType();
            switch (type) {
                case STRUCTURE_VOID: {
                    continue block6;
                }
            }
            if (indexes.containsKey(combined)) continue;
            indexes.put(combined, Integer.valueOf(palette.size()));
            HashMap<String, Object> paletteEntry = new HashMap<String, Object>();
            paletteEntry.put("Name", type.getId());
            if (block.getInternalId() != type.getInternalId()) {
                HashMap<String, String> properties = null;
                for (AbstractProperty abstractProperty : type.getProperties()) {
                    int propIndex = abstractProperty.getIndex(block.getInternalId());
                    if (propIndex == 0) continue;
                    if (properties == null) {
                        properties = new HashMap<String, String>();
                    }
                    Object value = abstractProperty.getValues().get(propIndex);
                    properties.put(abstractProperty.getName(), value.toString());
                }
                if (properties != null) {
                    paletteEntry.put("Properties", properties);
                }
            }
            palette.add(paletteEntry);
        }
        if (!palette.isEmpty()) {
            structure.put("palette", palette);
        }
        ArrayList<Map<String, Object>> blocks = new ArrayList<Map<String, Object>>();
        Vector min = region.getMinimumPoint();
        block8: for (Vector point : region) {
            BlockState block = clipboard.getBlock(point);
            switch (block.getBlockType()) {
                case STRUCTURE_VOID: {
                    continue block8;
                }
            }
            int combined = block.getInternalId();
            int index = (Integer)indexes.get(combined);
            List<Integer> pos = Arrays.asList((int)(point.getX() - min.getX()), (int)(point.getY() - min.getY()), (int)(point.getZ() - min.getZ()));
            if (!block.hasNbtData()) {
                blocks.add(FaweCache.asMap("state", index, "pos", pos));
                continue;
            }
            blocks.add(FaweCache.asMap("state", index, "pos", pos, "nbt", block.getNbtData()));
        }
        if (!blocks.isEmpty()) {
            structure.put("blocks", blocks);
        }
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        for (Entity entity : clipboard.getEntities()) {
            Location loc = entity.getLocation();
            List<Double> pos = Arrays.asList(loc.getX(), loc.getY(), loc.getZ());
            List<Integer> blockPos = Arrays.asList(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            BaseEntity state = entity.getState();
            if (state == null) continue;
            CompoundTag nbt = state.getNbtData();
            Map nbtMap = ReflectionUtils.getMap(nbt.getValue());
            nbtMap.put("Rotation", this.writeRotation(entity.getLocation(), "Rotation"));
            nbtMap.put("id", new StringTag(state.getType().getId()));
            Map<String, Object> map = FaweCache.asMap("pos", pos, "blockPos", blockPos, "nbt", nbt);
            entities.add(map);
        }
        if (!entities.isEmpty()) {
            structure.put("entities", entities);
        }
        this.out.writeNamedTag("", FaweCache.asTag(structure));
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    private Tag writeVector(Vector vector, String name) {
        ArrayList<DoubleTag> list = new ArrayList<DoubleTag>();
        list.add(new DoubleTag(vector.getX()));
        list.add(new DoubleTag(vector.getY()));
        list.add(new DoubleTag(vector.getZ()));
        return new ListTag<DoubleTag>(DoubleTag.class, list);
    }

    private Tag writeRotation(Location location, String name) {
        ArrayList<FloatTag> list = new ArrayList<FloatTag>();
        list.add(new FloatTag(location.getYaw()));
        list.add(new FloatTag(location.getPitch()));
        return new ListTag<FloatTag>(FloatTag.class, list);
    }
}

