/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.pattern;

import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.SplittableRandom;

public class RandomOffsetPattern
extends AbstractPattern {
    private final int dx;
    private final int dy;
    private final int dz;
    private final Pattern pattern;
    private transient int dx2;
    private transient int dy2;
    private transient int dz2;
    private transient MutableBlockVector mutable = new MutableBlockVector();
    private transient SplittableRandom r;

    public RandomOffsetPattern(Pattern pattern, int dx, int dy, int dz) {
        this.pattern = pattern;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.dx2 = dx * 2 + 1;
        this.dy2 = dy * 2 + 1;
        this.dz2 = dz * 2 + 1;
        this.r = new SplittableRandom();
    }

    @Override
    public BlockStateHolder apply(Vector position) {
        this.mutable.mutX(position.getX() + (double)this.r.nextInt(this.dx2) - (double)this.dx);
        this.mutable.mutY(position.getY() + (double)this.r.nextInt(this.dy2) - (double)this.dy);
        this.mutable.mutZ(position.getZ() + (double)this.r.nextInt(this.dz2) - (double)this.dz);
        return this.pattern.apply(this.mutable);
    }

    @Override
    public boolean apply(Extent extent, Vector set, Vector get) throws WorldEditException {
        this.mutable.mutX(get.getX() + (double)this.r.nextInt(this.dx2) - (double)this.dx);
        this.mutable.mutY(get.getY() + (double)this.r.nextInt(this.dy2) - (double)this.dy);
        this.mutable.mutZ(get.getZ() + (double)this.r.nextInt(this.dz2) - (double)this.dz);
        return this.pattern.apply(extent, set, this.mutable);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dx2 = this.dx * 2 + 1;
        this.dy2 = this.dy * 2 + 1;
        this.dz2 = this.dz * 2 + 1;
        this.r = new SplittableRandom();
        this.mutable = new MutableBlockVector();
    }
}

