/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.extent.TemporalExtent;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class SourceMaskExtent
extends TemporalExtent {
    private Mask mask;
    private MutableBlockVector mutable = new MutableBlockVector();

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    public SourceMaskExtent(Extent extent, Mask mask) {
        super(extent);
        Preconditions.checkNotNull((Object)mask);
        this.mask = mask;
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        this.set(location.getBlockX(), location.getBlockY(), location.getBlockZ(), block);
        return this.mask.test(location) && super.setBlock(location, block);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        this.set(x, y, z, block);
        this.mutable.mutX(x);
        this.mutable.mutY(y);
        this.mutable.mutZ(z);
        return this.mask.test(this.mutable) && super.setBlock(x, y, z, block);
    }
}

