/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.object.collection.RandomCollection;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.boydti.fawe.object.extent.SelectTransform;
import com.boydti.fawe.object.random.SimpleRandom;
import com.boydti.fawe.object.random.TrueRandom;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RandomTransform
extends SelectTransform {
    private SimpleRandom random;
    private Map<ResettableExtent, Double> weights = new HashMap<ResettableExtent, Double>();
    private transient RandomCollection<ResettableExtent> collection;
    private transient LinkedHashSet<ResettableExtent> extents = new LinkedHashSet();

    public RandomTransform() {
        this(new TrueRandom());
    }

    @Override
    public AbstractDelegateExtent getExtent(int x, int y, int z) {
        return this.collection.next(x, y, z);
    }

    @Override
    public AbstractDelegateExtent getExtent(int x, int z) {
        return this.collection.next(x, 0, z);
    }

    public RandomTransform(SimpleRandom random) {
        this.random = random;
    }

    @Override
    public ResettableExtent setExtent(Extent extent) {
        if (this.collection == null) {
            this.collection = RandomCollection.of(this.weights, this.random);
            this.extents = new LinkedHashSet<ResettableExtent>(this.weights.keySet());
        }
        for (AbstractDelegateExtent abstractDelegateExtent : this.extents) {
            if (!(abstractDelegateExtent instanceof ResettableExtent)) continue;
            ((ResettableExtent)abstractDelegateExtent).setExtent(extent);
        }
        return this;
    }

    public void add(ResettableExtent extent, double chance) {
        Preconditions.checkNotNull((Object)extent);
        this.weights.put(extent, chance);
        this.collection = RandomCollection.of(this.weights, this.random);
        this.extents.add(extent);
    }

    public Set<ResettableExtent> getExtents() {
        return this.extents;
    }

    public RandomCollection<ResettableExtent> getCollection() {
        return this.collection;
    }
}

