/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.extent;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.util.WEManager;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.List;

public class ProcessedWEExtent
extends AbstractDelegateExtent {
    private final FaweLimit limit;
    private final AbstractDelegateExtent extent;

    public ProcessedWEExtent(Extent parent, FaweLimit limit) {
        super(parent);
        this.limit = limit;
        this.extent = (AbstractDelegateExtent)parent;
    }

    public void setLimit(FaweLimit other) {
        this.limit.set(other);
    }

    @Override
    public Entity createEntity(Location location, BaseEntity entity) {
        if (entity == null) {
            return null;
        }
        if (!this.limit.MAX_ENTITIES()) {
            WEManager.IMP.cancelEditSafe(this, BBC.WORLDEDIT_CANCEL_REASON_MAX_ENTITIES);
            return null;
        }
        return super.createEntity(location, entity);
    }

    @Override
    public BaseBiome getBiome(Vector2D position) {
        return super.getBiome(position);
    }

    @Override
    public List<? extends Entity> getEntities() {
        return super.getEntities();
    }

    @Override
    public List<? extends Entity> getEntities(Region region) {
        return super.getEntities(region);
    }

    @Override
    public BlockState getLazyBlock(int x, int y, int z) {
        if (!this.limit.MAX_CHECKS()) {
            WEManager.IMP.cancelEditSafe(this, BBC.WORLDEDIT_CANCEL_REASON_MAX_CHECKS);
            return EditSession.nullBlock;
        }
        return this.extent.getLazyBlock(x, y, z);
    }

    @Override
    public boolean setBlock(Vector location, BlockStateHolder block) throws WorldEditException {
        return this.setBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ(), block);
    }

    @Override
    public BlockState getLazyBlock(Vector location) {
        return this.getLazyBlock(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        CompoundTag nbt = block.getNbtData();
        if (nbt != null) {
            if (!this.limit.MAX_BLOCKSTATES()) {
                WEManager.IMP.cancelEdit(this, BBC.WORLDEDIT_CANCEL_REASON_MAX_TILES);
                return false;
            }
            if (!this.limit.MAX_CHANGES()) {
                WEManager.IMP.cancelEdit(this, BBC.WORLDEDIT_CANCEL_REASON_MAX_CHANGES);
                return false;
            }
            return this.extent.setBlock(x, y, z, block);
        }
        if (!this.limit.MAX_CHANGES()) {
            WEManager.IMP.cancelEdit(this, BBC.WORLDEDIT_CANCEL_REASON_MAX_CHANGES);
            return false;
        }
        return this.extent.setBlock(x, y, z, block);
    }

    @Override
    public boolean setBiome(Vector2D position, BaseBiome biome) {
        if (!this.limit.MAX_CHANGES()) {
            WEManager.IMP.cancelEditSafe(this, BBC.WORLDEDIT_CANCEL_REASON_MAX_CHANGES);
            return false;
        }
        return super.setBiome(position, biome);
    }
}

