/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.object.clipboard.AbstractDelegateFaweClipboard;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class OffsetFaweClipboard
extends AbstractDelegateFaweClipboard {
    private final int ox;
    private final int oy;
    private final int oz;

    public OffsetFaweClipboard(FaweClipboard parent, int ox, int oy, int oz) {
        super(parent);
        this.ox = ox;
        this.oy = oy;
        this.oz = oz;
    }

    public OffsetFaweClipboard(FaweClipboard parent, int offset) {
        this(parent, offset, offset, offset);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return super.getBlock(x + this.ox, y + this.oy, z + this.oz);
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockStateHolder block) {
        return super.setBlock(this.ox + x, this.oy + y, this.oz + z, block);
    }

    @Override
    public boolean setBiome(int x, int z, int biome) {
        return super.setBiome(this.ox + x, this.oz + z, biome);
    }

    @Override
    public BaseBiome getBiome(int x, int z) {
        return super.getBiome(this.ox + x, this.oz + z);
    }

    @Override
    public boolean setTile(int x, int y, int z, CompoundTag tag) {
        return super.setTile(this.ox + x, this.oy + y, this.oz + z, tag);
    }

    @Override
    public void forEach(final FaweClipboard.BlockReader task, boolean air) {
        super.forEach(new FaweClipboard.BlockReader(){

            @Override
            public void run(int x, int y, int z, BlockState block) {
                task.run(x - OffsetFaweClipboard.this.ox, y - OffsetFaweClipboard.this.oy, z - OffsetFaweClipboard.this.oz, block);
            }
        }, air);
    }
}

