/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.clipboard;

import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.util.ReflectionUtils;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class FaweClipboard {
    public abstract BlockState getBlock(int var1, int var2, int var3);

    public abstract boolean setBlock(int var1, BlockStateHolder var2);

    public abstract boolean setBlock(int var1, int var2, int var3, BlockStateHolder var4);

    public abstract boolean hasBiomes();

    public abstract boolean setBiome(int var1, int var2, int var3);

    public abstract BaseBiome getBiome(int var1, int var2);

    public abstract BaseBiome getBiome(int var1);

    public abstract BlockState getBlock(int var1);

    public abstract void setBiome(int var1, int var2);

    public abstract boolean setTile(int var1, int var2, int var3, CompoundTag var4);

    public abstract Entity createEntity(Extent var1, double var2, double var4, double var6, float var8, float var9, BaseEntity var10);

    public abstract List<? extends Entity> getEntities();

    public abstract boolean remove(ClipboardEntity var1);

    public void setOrigin(Vector offset) {
    }

    public abstract void setDimensions(Vector var1);

    public abstract Vector getDimensions();

    public abstract void forEach(BlockReader var1, boolean var2);

    public abstract void streamBiomes(NBTStreamer.ByteReader var1);

    public void streamCombinedIds(final NBTStreamer.ByteReader task) {
        this.forEach(new BlockReader(){
            private int index = 0;

            @Override
            public void run(int x, int y, int z, BlockState block) {
                task.run(this.index++, block.getInternalId());
            }
        }, true);
    }

    public List<CompoundTag> getTileEntities() {
        final ArrayList<CompoundTag> tiles = new ArrayList<CompoundTag>();
        this.forEach(new BlockReader(){
            private int index = 0;

            @Override
            public void run(int x, int y, int z, BlockState block) {
                CompoundTag tag = block.getNbtData();
                if (tag != null) {
                    Map values = ReflectionUtils.getMap(tag.getValue());
                    values.put("x", new IntTag(x));
                    values.put("y", new IntTag(y));
                    values.put("z", new IntTag(z));
                    tiles.add(tag);
                }
            }
        }, false);
        return tiles;
    }

    public void close() {
    }

    public void flush() {
    }

    public class ClipboardEntity
    implements Entity {
        private final BaseEntity entity;
        private final Extent world;
        private final double x;
        private final double y;
        private final double z;
        private final float yaw;
        private final float pitch;

        public ClipboardEntity(Extent world, double x, double y, double z, float yaw, float pitch, BaseEntity entity) {
            Preconditions.checkNotNull((Object)entity);
            Preconditions.checkNotNull((Object)world);
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.entity = new BaseEntity(entity);
        }

        @Override
        public boolean remove() {
            return FaweClipboard.this.remove(this);
        }

        @Override
        @Nullable
        public <T> T getFacet(Class<? extends T> cls) {
            return null;
        }

        BaseEntity getEntity() {
            return this.entity;
        }

        @Override
        public BaseEntity getState() {
            return new BaseEntity(this.entity);
        }

        @Override
        public Location getLocation() {
            return new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
        }

        @Override
        public Extent getExtent() {
            return this.world;
        }
    }

    public static abstract class BlockReader {
        public abstract void run(int var1, int var2, int var3, BlockState var4);
    }
}

