/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.mask.IdMask;
import com.boydti.fawe.object.visitor.DFSRecursiveVisitor;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.interpolation.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SplineBrush
implements Brush,
ResettableTool {
    public static int MAX_POINTS = 15;
    private ArrayList<ArrayList<Vector>> positionSets;
    private int numSplines;
    private final LocalSession session;
    private final Player player;
    private Vector position;

    public SplineBrush(Player player, LocalSession session) {
        this.session = session;
        this.player = player;
        this.positionSets = new ArrayList();
    }

    @Override
    public boolean reset() {
        this.numSplines = 0;
        this.positionSets.clear();
        this.position = null;
        return true;
    }

    @Override
    public void build(EditSession editSession, Vector position, Pattern pattern, double size) throws WorldEditException {
        Mask mask = editSession.getMask();
        mask = mask == null ? new IdMask(editSession) : new MaskIntersection(mask, new IdMask(editSession));
        boolean visualization = editSession.getExtent() instanceof VisualExtent;
        if (visualization && this.positionSets.isEmpty()) {
            return;
        }
        int originalSize = this.numSplines;
        boolean newPos = this.position == null || !position.equals(this.position);
        this.position = position;
        if (newPos) {
            if (this.positionSets.size() >= MAX_POINTS) {
                throw new FaweException(BBC.WORLDEDIT_CANCEL_REASON_MAX_CHECKS);
            }
            final ArrayList<Vector> points = new ArrayList<Vector>();
            if (size > 0.0) {
                DFSRecursiveVisitor visitor = new DFSRecursiveVisitor(mask, new RegionFunction(){

                    @Override
                    public boolean apply(Vector p) {
                        points.add(new Vector(p));
                        return true;
                    }
                }, (int)size, 1);
                List<Vector> list = visitor.getDirections();
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            Vector pos;
                            if (x == 0 && y == 0 && z == 0 || list.contains(pos = new Vector(x, y, z))) continue;
                            list.add(pos);
                        }
                    }
                }
                Collections.sort(list, (o1, o2) -> (int)Math.signum(o1.lengthSq() - o2.lengthSq()));
                visitor.visit(position);
                Operations.completeBlindly(visitor);
                if (points.size() > this.numSplines) {
                    this.numSplines = points.size();
                }
            } else {
                points.add(position);
            }
            this.positionSets.add(points);
            this.player.print(BBC.getPrefix() + BBC.BRUSH_SPLINE_PRIMARY_2.s());
            if (!visualization) {
                return;
            }
        }
        if (this.positionSets.size() < 2) {
            this.player.print(BBC.getPrefix() + BBC.BRUSH_SPLINE_SECONDARY_ERROR.s());
            return;
        }
        ArrayList<Vector> centroids = new ArrayList<Vector>();
        for (List list : this.positionSets) {
            centroids.add(this.getCentroid(list));
        }
        double tension = 0.0;
        double bias = 0.0;
        double continuity = 0.0;
        double quality = 10.0;
        ArrayList<Node> nodes = new ArrayList<Node>(centroids.size());
        for (Vector nodevector : centroids) {
            Node n = new Node(nodevector);
            n.setTension(tension);
            n.setBias(bias);
            n.setContinuity(continuity);
            nodes.add(n);
        }
        int samples = this.numSplines;
        for (int i = 0; i < this.numSplines; ++i) {
            ArrayList<Vector> currentSpline = new ArrayList<Vector>();
            for (ArrayList<Vector> points : this.positionSets) {
                int listSize = points.size();
                int index = (int)((double)(i * listSize) / (double)this.numSplines);
                currentSpline.add(points.get(index));
            }
            editSession.drawSpline(pattern, currentSpline, 0.0, 0.0, 0.0, 10.0, 0.0, true);
        }
        this.player.print(BBC.getPrefix() + BBC.BRUSH_SPLINE_SECONDARY.s());
        if (visualization) {
            this.numSplines = originalSize;
            this.positionSets.remove(this.positionSets.size() - 1);
        } else {
            this.positionSets.clear();
            this.numSplines = 0;
        }
    }

    private Vector getCentroid(Collection<Vector> points) {
        Vector sum = new Vector();
        for (Vector p : points) {
            sum.mutX(sum.getX() + p.getX());
            sum.mutY(sum.getY() + p.getY());
            sum.mutZ(sum.getZ() + p.getZ());
        }
        return sum.multiply(1.0 / (double)points.size());
    }

    private Vector normal(Collection<Vector> points, Vector centroid) {
        Vector dir;
        int n = points.size();
        switch (n) {
            case 1: {
                return null;
            }
            case 2: {
                return null;
            }
        }
        double xx = 0.0;
        double xy = 0.0;
        double xz = 0.0;
        double yy = 0.0;
        double yz = 0.0;
        double zz = 0.0;
        Vector r = new Vector();
        for (Vector p : points) {
            r.mutX(p.getX() - centroid.getX());
            r.mutY(p.getY() - centroid.getY());
            r.mutZ(p.getZ() - centroid.getZ());
            xx += r.getX() * r.getX();
            xy += r.getX() * r.getY();
            xz += r.getX() * r.getZ();
            yy += r.getY() * r.getY();
            yz += r.getY() * r.getZ();
            zz += r.getZ() * r.getZ();
        }
        double det_x = yy * zz - yz * yz;
        double det_y = xx * zz - xz * xz;
        double det_z = xx * yy - xy * xy;
        double det_max = Math.max(Math.max(det_x, det_y), det_z);
        if (det_max <= 0.0) {
            return null;
        }
        if (det_max == det_x) {
            double a = (xz * yz - xy * zz) / det_x;
            double b = (xy * yz - xz * yy) / det_x;
            dir = new Vector(1.0, a, b);
        } else if (det_max == det_y) {
            double a = (yz * xz - xy * zz) / det_y;
            double b = (xy * xz - yz * xx) / det_y;
            dir = new Vector(a, 1.0, b);
        } else {
            double a = (yz * xy - xz * yy) / det_z;
            double b = (xz * xy - yz * xx) / det_z;
            dir = new Vector(a, b, 1.0);
        }
        return dir.normalize();
    }
}

