/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.object.PseudoRandom;
import com.boydti.fawe.object.brush.ScatterBrush;
import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.boydti.fawe.object.mask.SurfaceMask;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.BreadthFirstSearch;

public class ShatterBrush
extends ScatterBrush {
    private final MutableBlockVector mutable = new MutableBlockVector();

    public ShatterBrush(int count) {
        super(count, 1);
    }

    @Override
    public void apply(EditSession editSession, LocalBlockVectorSet placed, Vector position, Pattern p, double size) throws MaxChangedBlocksException {
    }

    @Override
    public void finish(final EditSession editSession, final LocalBlockVectorSet placed, final Vector position, final Pattern pattern, double size) {
        final int radius2 = (int)(size * size);
        LocalBlockVectorSet tmp = new LocalBlockVectorSet();
        LocalBlockVectorSet[] frontiers = new LocalBlockVectorSet[placed.size()];
        LocalBlockVectorSet[] frontiersVisited = new LocalBlockVectorSet[placed.size()];
        int i = 0;
        for (Vector pos : placed) {
            LocalBlockVectorSet set = new LocalBlockVectorSet();
            set.add(pos);
            frontiers[i] = set;
            frontiersVisited[i] = set.clone();
            ++i;
        }
        Mask mask = editSession.getMask();
        if (mask == null) {
            mask = Masks.alwaysTrue();
        }
        final Mask finalMask = mask;
        final SurfaceMask surfaceTest = new SurfaceMask(editSession);
        boolean notEmpty = true;
        while (notEmpty) {
            notEmpty = false;
            for (i = 0; i < frontiers.length; ++i) {
                LocalBlockVectorSet frontier = frontiers[i];
                notEmpty |= !frontier.isEmpty();
                final LocalBlockVectorSet frontierVisited = frontiersVisited[i];
                final LocalBlockVectorSet finalTmp = tmp;
                frontier.forEach(new LocalBlockVectorSet.BlockVectorSetVisitor(){

                    @Override
                    public void run(int x, int y, int z, int index) {
                        if (PseudoRandom.random.random(2) == 0) {
                            finalTmp.add(x, y, z);
                            return;
                        }
                        for (int i = 0; i < BreadthFirstSearch.DIAGONAL_DIRECTIONS.length; ++i) {
                            MutableBlockVector v;
                            int dz;
                            int dy;
                            Vector direction = BreadthFirstSearch.DIAGONAL_DIRECTIONS[i];
                            int x2 = x + direction.getBlockX();
                            int y2 = y + direction.getBlockY();
                            int z2 = z + direction.getBlockZ();
                            int dx = position.getBlockX() - x2;
                            int dSqr = dx * dx + (dy = position.getBlockY() - y2) * dy + (dz = position.getBlockZ() - z2) * dz;
                            if (dSqr > radius2 || !surfaceTest.test(v = ShatterBrush.this.mutable.setComponents(x2, y2, z2)) || !finalMask.test(v)) continue;
                            if (!placed.add(x2, y2, z2)) {
                                if (frontierVisited.contains(x2, y2, z2)) continue;
                                editSession.setBlock(x2, y2, z2, pattern);
                                continue;
                            }
                            finalTmp.add(x2, y2, z2);
                            frontierVisited.add(x2, y2, z2);
                        }
                    }
                });
                frontiers[i] = tmp;
                tmp = frontier;
                tmp.clear();
            }
        }
    }
}

