/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.object.random.SimplexNoise;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.transform.AffineTransform;
import java.util.concurrent.ThreadLocalRandom;

public class BlobBrush
implements Brush {
    private final double amplitude;
    private final double frequency;
    private final Vector radius;
    private final double sphericity;

    public BlobBrush(Vector radius, double frequency, double amplitude, double sphericity) {
        this.frequency = frequency;
        this.amplitude = amplitude;
        this.radius = radius;
        this.sphericity = sphericity;
    }

    @Override
    public void build(EditSession editSession, Vector position, Pattern pattern, double size) throws MaxChangedBlocksException {
        double seedX = ThreadLocalRandom.current().nextDouble();
        double seedY = ThreadLocalRandom.current().nextDouble();
        double seedZ = ThreadLocalRandom.current().nextDouble();
        int px = position.getBlockX();
        int py = position.getBlockY();
        int pz = position.getBlockZ();
        double distort = this.frequency / size;
        double modX = 1.0 / this.radius.getX();
        double modY = 1.0 / this.radius.getY();
        double modZ = 1.0 / this.radius.getZ();
        int radius = (int)size;
        int radiusSqr = (int)(size * size);
        int sizeInt = (int)size * 2;
        if (this.sphericity == 1.0) {
            for (int x = -sizeInt; x <= sizeInt; ++x) {
                double nx = seedX + (double)x * distort;
                double d1 = (double)(x * x) * modX;
                for (int y = -sizeInt; y <= sizeInt; ++y) {
                    double d2 = d1 + (double)(y * y) * modY;
                    double ny = seedY + (double)y * distort;
                    for (int z = -sizeInt; z <= sizeInt; ++z) {
                        double distance = d2 + (double)(z * z) * modZ;
                        double nz = seedZ + (double)z * distort;
                        double noise = this.amplitude * SimplexNoise.noise(nx, ny, nz);
                        if (!(distance + distance * noise < (double)radiusSqr)) continue;
                        editSession.setBlock(px + x, py + y, pz + z, pattern);
                    }
                }
            }
        } else {
            AffineTransform transform = new AffineTransform().rotateX(ThreadLocalRandom.current().nextInt(360)).rotateY(ThreadLocalRandom.current().nextInt(360)).rotateZ(ThreadLocalRandom.current().nextInt(360));
            double manScaleX = 1.25 + seedX * 0.5;
            double manScaleY = 1.25 + seedY * 0.5;
            double manScaleZ = 1.25 + seedZ * 0.5;
            MutableBlockVector mutable = new MutableBlockVector();
            double roughness = 1.0 - this.sphericity;
            for (int xr = -sizeInt; xr <= sizeInt; ++xr) {
                mutable.mutX(xr);
                for (int yr = -sizeInt; yr <= sizeInt; ++yr) {
                    mutable.mutY(yr);
                    for (int zr = -sizeInt; zr <= sizeInt; ++zr) {
                        mutable.mutZ(zr);
                        Vector pt = transform.apply(mutable);
                        int x = MathMan.roundInt(pt.getBlockX());
                        int y = MathMan.roundInt(pt.getBlockY());
                        int z = MathMan.roundInt(pt.getBlockZ());
                        double xScaled = (double)Math.abs(x) * modX;
                        double yScaled = (double)Math.abs(y) * modY;
                        double zScaled = (double)Math.abs(z) * modZ;
                        double manDist = xScaled + yScaled + zScaled;
                        double distSqr = (double)(x * x) * modX + (double)(z * z) * modZ + (double)(y * y) * modY;
                        double distance = Math.sqrt(distSqr) * this.sphericity + MathMan.max(manDist, xScaled * manScaleX, yScaled * manScaleY, zScaled * manScaleZ) * roughness;
                        double noise = this.amplitude * SimplexNoise.noise(seedX + (double)x * distort, seedZ + (double)z * distort, seedZ + (double)z * distort);
                        if (!(distance + distance * noise < (double)radius)) continue;
                        editSession.setBlock(px + xr, py + yr, pz + zr, pattern);
                    }
                }
            }
        }
    }
}

