/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.example.NullRelighter;
import com.boydti.fawe.example.Relighter;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.RunnableVal2;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.MemUtil;
import com.boydti.fawe.util.SetQueue;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;

public interface FaweQueue
extends HasFaweQueue,
Extent {
    default public Relighter getRelighter() {
        return NullRelighter.INSTANCE;
    }

    @Override
    default public Vector getMinimumPoint() {
        return new Vector(-30000000, 0, -30000000);
    }

    @Override
    default public Vector getMaximumPoint() {
        return new Vector(30000000, this.getMaxY(), 30000000);
    }

    @Override
    default public BlockState getLazyBlock(int x, int y, int z) {
        int combinedId4Data = this.getCachedCombinedId4Data(x, y, z, BlockTypes.AIR.getInternalId());
        try {
            CompoundTag tile;
            BlockState state = BlockState.getFromInternalId(combinedId4Data);
            if (state.getMaterial().hasContainer() && (tile = this.getTileEntity(x, y, z)) != null) {
                return BaseBlock.getFromInternalId(combinedId4Data, tile);
            }
            return state;
        }
        catch (Throwable e) {
            MainUtil.handleError(e);
            return BlockTypes.AIR.getDefaultState();
        }
    }

    @Override
    default public boolean setBlock(int x, int y, int z, BlockStateHolder block) throws WorldEditException {
        return this.setBlock(x, y, z, block.getInternalId(), block.getNbtData());
    }

    @Override
    default public BlockState getFullBlock(Vector position) {
        return this.getLazyBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    @Override
    default public BaseBiome getBiome(Vector2D position) {
        return null;
    }

    @Override
    default public boolean setBlock(Vector position, BlockStateHolder block) throws WorldEditException {
        return this.setBlock(position.getBlockX(), position.getBlockY(), position.getBlockZ(), block);
    }

    public boolean setBlock(int var1, int var2, int var3, int var4);

    default public boolean setBlock(int x, int y, int z, int combinedId, CompoundTag nbtData) {
        if (this.setBlock(x, y, z, combinedId)) {
            if (nbtData != null) {
                this.setTile(x, y, z, nbtData);
            }
            return true;
        }
        return false;
    }

    @Override
    default public boolean setBiome(Vector2D position, BaseBiome biome) {
        return this.setBiome(position.getBlockX(), position.getBlockZ(), biome);
    }

    @Override
    default public FaweQueue getQueue() {
        return this;
    }

    default public void addEditSession(EditSession session) {
        if (session == null) {
            return;
        }
        Collection<EditSession> sessions = this.getEditSessions();
        sessions.add(session);
    }

    default public void setProgressTracker(RunnableVal2<ProgressType, Integer> progressTask) {
        this.setProgressTask(progressTask);
    }

    default public Collection<EditSession> getEditSessions() {
        return Collections.emptySet();
    }

    default public boolean supports(Capability capability) {
        return false;
    }

    default public void optimize() {
    }

    default public int setBlocks(CuboidRegion cuboid, final int combinedId) {
        RegionWrapper current = new RegionWrapper(cuboid.getMinimumPoint(), cuboid.getMaximumPoint());
        final int minY = cuboid.getMinimumY();
        final int maxY = cuboid.getMaximumY();
        final FaweChunk fc = this.getFaweChunk(0, 0);
        fc.fillCuboid(0, 15, minY, maxY, 0, 15, combinedId);
        fc.optimize();
        int bcx = current.minX >> 4;
        int bcz = current.minZ >> 4;
        int tcx = current.maxX >> 4;
        int tcz = current.maxZ >> 4;
        MainUtil.chunkTaskSync(current, new RunnableVal<int[]>(){

            @Override
            public void run(int[] value) {
                FaweChunk newChunk;
                if (value[6] == 0) {
                    newChunk = fc.copy(true);
                    newChunk.setLoc(FaweQueue.this, value[0], value[1]);
                } else {
                    int bx = value[2] & 0xF;
                    int tx = value[4] & 0xF;
                    int bz = value[3] & 0xF;
                    int tz = value[5] & 0xF;
                    if (bx == 0 && tx == 15 && bz == 0 && tz == 15) {
                        newChunk = fc.copy(true);
                        newChunk.setLoc(FaweQueue.this, value[0], value[1]);
                    } else {
                        newChunk = FaweQueue.this.getFaweChunk(value[0], value[1]);
                        newChunk.fillCuboid(value[2] & 0xF, value[4] & 0xF, minY, maxY, value[3] & 0xF, value[5] & 0xF, combinedId);
                    }
                }
                newChunk.addToQueue();
            }
        });
        return cuboid.getArea();
    }

    public void setTile(int var1, int var2, int var3, CompoundTag var4);

    public void setEntity(int var1, int var2, int var3, CompoundTag var4);

    public void removeEntity(int var1, int var2, int var3, UUID var4);

    public boolean setBiome(int var1, int var2, BaseBiome var3);

    public FaweChunk getFaweChunk(int var1, int var2);

    public Collection<FaweChunk> getFaweChunks();

    default public boolean setMCA(int mcaX, int mcaZ, RegionWrapper region, Runnable whileLocked, boolean save, boolean load) {
        if (whileLocked != null) {
            whileLocked.run();
        }
        return true;
    }

    public void setChunk(FaweChunk var1);

    public File getSaveFolder();

    @Override
    default public int getMaxY() {
        World weWorld = this.getWEWorld();
        return weWorld == null ? 255 : weWorld.getMaxY();
    }

    default public Settings getSettings() {
        return Settings.IMP;
    }

    default public void setSettings(Settings settings) {
    }

    public void setWorld(String var1);

    public World getWEWorld();

    public String getWorldName();

    public long getModified();

    public void setModified(long var1);

    public RunnableVal2<ProgressType, Integer> getProgressTask();

    public void setProgressTask(RunnableVal2<ProgressType, Integer> var1);

    public void setChangeTask(RunnableVal2<FaweChunk, FaweChunk> var1);

    public RunnableVal2<FaweChunk, FaweChunk> getChangeTask();

    public SetQueue.QueueStage getStage();

    public void setStage(SetQueue.QueueStage var1);

    public void addNotifyTask(Runnable var1);

    public void runTasks();

    public void addTask(Runnable var1);

    default public void forEachBlockInChunk(int cx, int cz, RunnableVal2<Vector, BlockState> onEach) {
        int bx = cx << 4;
        int bz = cz << 4;
        MutableBlockVector mutable = new MutableBlockVector(0, 0, 0);
        for (int x = 0; x < 16; ++x) {
            int xx = x + bx;
            mutable.mutX(xx);
            for (int z = 0; z < 16; ++z) {
                int zz = z + bz;
                mutable.mutZ(zz);
                block5: for (int y = 0; y <= this.getMaxY(); ++y) {
                    int combined = this.getCombinedId4Data(xx, y, zz);
                    BlockState state = BlockState.getFromInternalId(combined);
                    BlockTypes type = state.getBlockType();
                    switch (type.getTypeEnum()) {
                        case AIR: 
                        case VOID_AIR: 
                        case CAVE_AIR: {
                            continue block5;
                        }
                        default: {
                            mutable.mutY(y);
                            CompoundTag tile = this.getTileEntity(x, y, z);
                            if (tile != null) {
                                BaseBlock block = BaseBlock.getFromInternalId(combined, tile);
                                onEach.run(mutable, block);
                                continue block5;
                            }
                            onEach.run(mutable, state);
                        }
                    }
                }
            }
        }
    }

    default public void forEachTileInChunk(int cx, int cz, RunnableVal2<Vector, BlockState> onEach) {
        int bx = cx << 4;
        int bz = cz << 4;
        MutableBlockVector mutable = new MutableBlockVector(0, 0, 0);
        for (int x = 0; x < 16; ++x) {
            int xx = x + bx;
            for (int z = 0; z < 16; ++z) {
                int zz = z + bz;
                for (int y = 0; y < this.getMaxY(); ++y) {
                    CompoundTag tile;
                    BlockTypes type;
                    int combined = this.getCombinedId4Data(xx, y, zz);
                    if (combined == 0 || !(type = BlockTypes.getFromStateId(combined)).getMaterial().hasContainer() || (tile = this.getTileEntity(x, y, z)) == null) continue;
                    mutable.mutX(xx);
                    mutable.mutZ(zz);
                    mutable.mutY(y);
                    BaseBlock block = BaseBlock.getFromInternalId(combined, tile);
                    onEach.run(mutable, block);
                }
            }
        }
    }

    @Deprecated
    default public boolean regenerateChunk(int x, int z) {
        return this.regenerateChunk(x, z, null, null);
    }

    public boolean regenerateChunk(int var1, int var2, @Nullable BaseBiome var3, @Nullable Long var4);

    default public void startSet(boolean parallel) {
    }

    default public void endSet(boolean parallel) {
    }

    default public int cancel() {
        this.clear();
        int count = 0;
        for (EditSession session : this.getEditSessions()) {
            if (!session.cancel()) continue;
            ++count;
        }
        return count;
    }

    public void sendBlockUpdate(FaweChunk var1, FawePlayer ... var2);

    default public void sendChunkUpdate(FaweChunk chunk, FawePlayer ... players) {
        this.sendBlockUpdate(chunk, players);
    }

    @Deprecated
    default public boolean next() {
        int amount = Settings.IMP.QUEUE.PARALLEL_THREADS;
        long time = 20L;
        return this.next(amount, time);
    }

    public boolean next(int var1, long var2);

    default public void saveMemory() {
        MainUtil.sendAdmin(BBC.OOM.s());
        MemUtil.memoryLimitedTask();
        this.clear();
        Fawe.get().getWorldEdit().getSessionManager().clear();
        System.gc();
        System.gc();
    }

    public void sendChunk(FaweChunk var1);

    public void sendChunk(int var1, int var2, int var3);

    public void clear();

    public void addNotifyTask(int var1, int var2, Runnable var3);

    default public boolean hasBlock(int x, int y, int z) throws FaweException.FaweChunkLoadException {
        return this.getCombinedId4Data(x, y, z) != 0;
    }

    public int getBiomeId(int var1, int var2) throws FaweException.FaweChunkLoadException;

    public int getCombinedId4Data(int var1, int var2, int var3) throws FaweException.FaweChunkLoadException;

    public int getCachedCombinedId4Data(int var1, int var2, int var3) throws FaweException.FaweChunkLoadException;

    default public int getAdjacentLight(int x, int y, int z) {
        int light = 0;
        if ((light = Math.max(light, this.getSkyLight(x - 1, y, z))) == 15) {
            return light;
        }
        if ((light = Math.max(light, this.getSkyLight(x + 1, y, z))) == 15) {
            return light;
        }
        if ((light = Math.max(light, this.getSkyLight(x, y, z - 1))) == 15) {
            return light;
        }
        return Math.max(light, this.getSkyLight(x, y, z + 1));
    }

    public boolean hasSky();

    public int getSkyLight(int var1, int var2, int var3);

    default public int getLight(int x, int y, int z) {
        if (!this.hasSky()) {
            return this.getEmmittedLight(x, y, z);
        }
        return Math.max(this.getSkyLight(x, y, z), this.getEmmittedLight(x, y, z));
    }

    public int getEmmittedLight(int var1, int var2, int var3);

    public CompoundTag getTileEntity(int var1, int var2, int var3) throws FaweException.FaweChunkLoadException;

    default public int getCombinedId4Data(int x, int y, int z, int def) {
        try {
            return this.getCombinedId4Data(x, y, z);
        }
        catch (FaweException ignore) {
            return def;
        }
    }

    default public int getCachedCombinedId4Data(int x, int y, int z, int def) {
        try {
            return this.getCachedCombinedId4Data(x, y, z);
        }
        catch (FaweException ignore) {
            return def;
        }
    }

    default public int getCombinedId4DataDebug(int x, int y, int z, int def, EditSession session) {
        try {
            return this.getCombinedId4Data(x, y, z);
        }
        catch (FaweException ignore) {
            session.debug(BBC.WORLDEDIT_FAILED_LOAD_CHUNK, x >> 4, z >> 4);
            return def;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return BlockTypes.AIR.getInternalId();
        }
    }

    default public int getBrightness(int x, int y, int z) {
        int combined = this.getCombinedId4Data(x, y, z);
        if (combined == 0) {
            return 0;
        }
        return BlockTypes.getFromStateId(combined).getMaterial().getLightValue();
    }

    default public int getOpacityBrightnessPair(int x, int y, int z) {
        return MathMan.pair16(Math.min(15, this.getOpacity(x, y, z)), this.getBrightness(x, y, z));
    }

    default public int getOpacity(int x, int y, int z) {
        int combined = this.getCombinedId4Data(x, y, z);
        if (combined == 0) {
            return 0;
        }
        return BlockTypes.getFromStateId(combined).getMaterial().getLightOpacity();
    }

    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public void flush() {
        this.flush(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void flush(int time) {
        if (this.size() > 0) {
            if (Fawe.isMainThread()) {
                SetQueue.IMP.flush(this);
            } else if (this.enqueue()) {
                while (!this.isEmpty() && this.getStage() == SetQueue.QueueStage.ACTIVE) {
                    FaweQueue faweQueue = this;
                    synchronized (faweQueue) {
                        try {
                            this.wait(time);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    default public boolean enqueue() {
        return SetQueue.IMP.enqueue(this);
    }

    default public void dequeue() {
        SetQueue.IMP.dequeue(this);
    }

    public static enum Capability {
        CHANGE_TASKS,
        CHUNK_PACKETS;

    }

    public static enum RelightMode {
        NONE,
        OPTIMAL,
        ALL;

    }

    public static enum ProgressType {
        QUEUE,
        DISPATCH,
        DONE;

    }
}

