/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.command;

import com.boydti.fawe.command.SuggestInputParseException;
import com.boydti.fawe.util.StringMan;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.internal.registry.InputParser;
import com.sk89q.worldedit.util.command.Dispatcher;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class FaweParser<T>
extends InputParser<T> {
    protected FaweParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    public T catchSuggestion(String currentInput, String nextInput, ParserContext context) throws InputParseException {
        try {
            return (T)this.parseFromInput(nextInput, context);
        }
        catch (SuggestInputParseException e) {
            e.prepend(currentInput.substring(0, currentInput.length() - nextInput.length()));
            throw e;
        }
    }

    public abstract Dispatcher getDispatcher();

    public static List<Map.Entry<ParseEntry, List<String>>> parse(String toParse) throws InputParseException {
        int i;
        ArrayList<Map.Entry<ParseEntry, List<String>>> keys = new ArrayList<Map.Entry<ParseEntry, List<String>>>();
        ArrayList<String> inputs = new ArrayList<String>();
        ArrayList<Boolean> and = new ArrayList<Boolean>();
        int last = 0;
        block3: for (i = 0; i < toParse.length(); ++i) {
            char c = toParse.charAt(i);
            switch (c) {
                case '&': 
                case ',': {
                    String result = toParse.substring(last, i);
                    if (result.isEmpty()) {
                        throw new InputParseException("Invalid dangling character " + c);
                    }
                    inputs.add(result);
                    and.add(c == '&');
                    last = i + 1;
                    continue block3;
                }
                default: {
                    if (c != '[' || StringMan.getMatchingBracket(c) == c) continue block3;
                    int next = StringMan.findMatchingBracket(toParse, i);
                    if (next != -1) {
                        i = next;
                        continue block3;
                    }
                    toParse = toParse + "]";
                    i = toParse.length();
                    continue block3;
                }
            }
        }
        inputs.add(toParse.substring(last, toParse.length()));
        for (i = 0; i < inputs.size(); ++i) {
            int startPos;
            String full;
            String command = full = (String)inputs.get(i);
            ArrayList<String> args = new ArrayList<String>();
            while (!command.isEmpty() && command.charAt(command.length() - 1) == ']' && (startPos = StringMan.findMatchingBracket(command, command.length() - 1)) != -1) {
                String arg = command.substring(startPos + 1, command.length() - 1);
                args.add(arg);
                command = full.substring(0, startPos);
            }
            Collections.reverse(args);
            ParseEntry entry = new ParseEntry(full, command, i > 0 ? (Boolean)and.get(i - 1) : false);
            keys.add(new AbstractMap.SimpleEntry(entry, args));
        }
        return keys;
    }

    protected static class ParseEntry {
        public boolean and;
        public String input;
        public String full;

        public ParseEntry(String full, String input, boolean type) {
            this.full = full;
            this.input = input;
            this.and = type;
        }

        public String toString() {
            return this.input + " | " + this.and;
        }
    }
}

