/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.regions;

import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.filter.WorldGuardFilter;
import com.boydti.fawe.bukkit.regions.BukkitMaskManager;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.regions.general.RegionFilter;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class WorldguardFlag
extends BukkitMaskManager
implements Listener {
    private WorldGuardPlugin worldguard;
    FaweBukkit plugin;

    public WorldguardFlag(Plugin p2, FaweBukkit p3) {
        super("worldguardflag");
        this.worldguard = (WorldGuardPlugin)p2;
        this.plugin = p3;
    }

    @Override
    public FaweMask getMask(FawePlayer<Player> fp, FaweMaskManager.MaskType type) {
        Player player = (Player)fp.parent;
        LocalPlayer localplayer = this.worldguard.wrapPlayer(player);
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(fp.getWorld());
        return new FaweMask(new ManagerRegion(manager, localplayer), null){

            @Override
            public boolean isValid(FawePlayer player, FaweMaskManager.MaskType type) {
                return true;
            }
        };
    }

    @Override
    public RegionFilter getFilter(String world) {
        return new WorldGuardFilter(Bukkit.getWorld((String)world));
    }

    private static class ManagerRegion
    extends AbstractRegion {
        private final RegionManager manager;
        private final LocalPlayer localplayer;

        ManagerRegion(RegionManager manager, LocalPlayer localplayer) {
            super(null);
            this.manager = manager;
            this.localplayer = localplayer;
        }

        @Override
        public Vector getMinimumPoint() {
            Vector point = null;
            for (Map.Entry entry : this.manager.getRegions().entrySet()) {
                BlockVector p = ((ProtectedRegion)entry.getValue()).getMinimumPoint();
                if (point == null) {
                    point = p;
                    continue;
                }
                point = Vector.getMinimum(point, p);
            }
            return point;
        }

        @Override
        public Vector getMaximumPoint() {
            Vector point = null;
            for (Map.Entry entry : this.manager.getRegions().entrySet()) {
                BlockVector p = ((ProtectedRegion)entry.getValue()).getMaximumPoint();
                if (point == null) {
                    point = p;
                    continue;
                }
                point = Vector.getMaximum(point, p);
            }
            return point;
        }

        @Override
        public void expand(Vector ... changes) {
            throw new UnsupportedOperationException("Region is immutable");
        }

        @Override
        public void contract(Vector ... changes) {
            throw new UnsupportedOperationException("Region is immutable");
        }

        @Override
        public boolean contains(Vector position) {
            return this.manager.getApplicableRegions(position).testState((RegionAssociable)this.localplayer, new StateFlag[]{Flags.BUILD, Flags.BLOCK_PLACE, Flags.BLOCK_BREAK});
        }
    }
}

