/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.io.IOException;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4StreamHelper;

public class LZ4OutputStream
extends OutputStream {
    private static final LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
    private final LZ4Compressor compressor;
    private static final int ONE_MEGABYTE = 0x100000;
    private final byte[] compressionInputBuffer;
    private final byte[] compressionOutputBuffer;
    private final OutputStream underlyingOutputStream;
    private int bytesRemainingInCompressionInputBuffer = 0;
    private int currentCompressionInputBufferPosition = 0;

    public LZ4OutputStream(OutputStream os) throws IOException {
        this(os, 0x100000, lz4Factory.fastCompressor());
    }

    public LZ4OutputStream(OutputStream os, int size) throws IOException {
        this(os, size, lz4Factory.fastCompressor());
    }

    public LZ4OutputStream(OutputStream underlyingOutputStream, int blocksize, LZ4Compressor compressor) throws IOException {
        this.compressionInputBuffer = new byte[blocksize];
        this.compressor = compressor;
        this.underlyingOutputStream = underlyingOutputStream;
        this.bytesRemainingInCompressionInputBuffer = blocksize;
        this.currentCompressionInputBufferPosition = 0;
        this.compressionOutputBuffer = new byte[compressor.maxCompressedLength(blocksize)];
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= this.bytesRemainingInCompressionInputBuffer) {
            System.arraycopy(b, off, this.compressionInputBuffer, this.currentCompressionInputBufferPosition, len);
            this.currentCompressionInputBufferPosition += len;
            this.bytesRemainingInCompressionInputBuffer -= len;
        } else {
            while (len > 0) {
                int bytesToCopy = Math.min(this.bytesRemainingInCompressionInputBuffer, len);
                System.arraycopy(b, off, this.compressionInputBuffer, this.currentCompressionInputBufferPosition, bytesToCopy);
                this.currentCompressionInputBufferPosition += bytesToCopy;
                this.bytesRemainingInCompressionInputBuffer -= bytesToCopy;
                this.flush();
                len -= bytesToCopy;
                off += bytesToCopy;
            }
        }
    }

    @Override
    public void write(int i) throws IOException {
        byte b = (byte)i;
        if (0 == this.bytesRemainingInCompressionInputBuffer) {
            this.flush();
        }
        this.compressionInputBuffer[this.currentCompressionInputBufferPosition] = b;
        --this.bytesRemainingInCompressionInputBuffer;
        ++this.currentCompressionInputBufferPosition;
    }

    @Override
    public void flush() throws IOException {
        if (this.currentCompressionInputBufferPosition > 0) {
            LZ4StreamHelper.writeLength(this.currentCompressionInputBufferPosition, this.underlyingOutputStream);
            int bytesCompressed = this.compressor.compress(this.compressionInputBuffer, 0, this.currentCompressionInputBufferPosition, this.compressionOutputBuffer, 0, this.compressionOutputBuffer.length);
            LZ4StreamHelper.writeLength(bytesCompressed, this.underlyingOutputStream);
            this.underlyingOutputStream.write(this.compressionOutputBuffer, 0, bytesCompressed);
            this.bytesRemainingInCompressionInputBuffer = this.compressionInputBuffer.length;
            this.currentCompressionInputBufferPosition = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.underlyingOutputStream.close();
    }
}

