/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.storage;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.storage.ChunkStore;
import com.sk89q.worldedit.world.storage.ChunkStoreException;
import com.sk89q.worldedit.world.storage.McRegionReader;
import java.io.IOException;
import java.io.InputStream;

public abstract class McRegionChunkStore
extends ChunkStore {
    protected String curFilename = null;
    protected McRegionReader cachedReader = null;

    public static String getFilename(Vector2D position) {
        int x = position.getBlockX();
        int z = position.getBlockZ();
        return "r." + (x >> 5) + "." + (z >> 5) + ".mca";
    }

    protected McRegionReader getReader(Vector2D pos, String worldname) throws DataException, IOException {
        String filename = McRegionChunkStore.getFilename(pos);
        if (this.curFilename != null) {
            if (this.curFilename.equals(filename)) {
                return this.cachedReader;
            }
            try {
                this.cachedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        InputStream stream = this.getInputStream(filename, worldname);
        this.cachedReader = new McRegionReader(stream);
        return this.cachedReader;
    }

    @Override
    public CompoundTag getChunkTag(Vector2D position, World world) throws DataException, IOException {
        McRegionReader reader = this.getReader(position, world.getName());
        InputStream stream = reader.getChunkInputStream(position);
        try (NBTInputStream nbt = new NBTInputStream(stream);){
            Tag tag = nbt.readNamedTag().getTag();
            if (!(tag instanceof CompoundTag)) {
                throw new ChunkStoreException("CompoundTag expected for chunk; got " + tag.getClass().getName());
            }
            CompoundTag compoundTag = (CompoundTag)tag;
            return compoundTag;
        }
    }

    protected abstract InputStream getInputStream(String var1, String var2) throws IOException, DataException;

    @Override
    public void close() throws IOException {
        if (this.cachedReader != null) {
            this.cachedReader.close();
        }
    }
}

