/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypeSwitch;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.function.Predicate;

public class BlockTypeSwitchBuilder<T> {
    private final Object[] runnables = new Object[BlockTypes.size()];
    private T defaultTask;

    public BlockTypeSwitchBuilder(T defaultTask) {
        this.defaultTask = defaultTask;
    }

    public BlockTypeSwitchBuilder<T> add(BlockType type, T task) {
        this.runnables[type.getInternalId()] = task;
        return this;
    }

    public BlockTypeSwitchBuilder<T> add(Predicate<BlockType> predicate, T task) {
        for (BlockTypes type : BlockTypes.values) {
            if (!predicate.test(type)) continue;
            this.runnables[type.getInternalId()] = task;
        }
        return this;
    }

    public BlockTypeSwitchBuilder<T> setDefaultTask(T defaultTask) {
        this.defaultTask = defaultTask;
        return this;
    }

    public BlockTypeSwitch<T> build() {
        for (int i = 0; i < this.runnables.length; ++i) {
            if (this.runnables[i] != null) continue;
            this.runnables[i] = this.defaultTask;
        }
        return new BlockTypeSwitch<Object>(this.runnables);
    }
}

