/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.pattern;

import com.boydti.fawe.object.collection.RandomCollection;
import com.boydti.fawe.object.random.SimpleRandom;
import com.boydti.fawe.object.random.TrueRandom;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.AbstractPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RandomPattern
extends AbstractPattern {
    private final SimpleRandom random;
    private Map<Pattern, Double> weights = new HashMap<Pattern, Double>();
    private RandomCollection<Pattern> collection;
    private LinkedHashSet<Pattern> patterns = new LinkedHashSet();

    public RandomPattern() {
        this(new TrueRandom());
    }

    public RandomPattern(SimpleRandom random) {
        this.random = random;
    }

    public void add(Pattern pattern, double chance) {
        Preconditions.checkNotNull((Object)pattern);
        Double existingWeight = this.weights.get(pattern);
        if (existingWeight != null) {
            chance += existingWeight.doubleValue();
        }
        this.weights.put(pattern, chance);
        this.collection = RandomCollection.of(this.weights, this.random);
        this.patterns.add(pattern);
    }

    public Set<Pattern> getPatterns() {
        return this.patterns;
    }

    public RandomCollection<Pattern> getCollection() {
        return this.collection;
    }

    @Override
    public BlockStateHolder apply(Vector get) {
        return this.collection.next(get.getBlockX(), get.getBlockY(), get.getBlockZ()).apply(get);
    }

    @Override
    public boolean apply(Extent extent, Vector set, Vector get) throws WorldEditException {
        return this.collection.next(get.getBlockX(), get.getBlockY(), get.getBlockZ()).apply(extent, set, get);
    }
}

