/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory;

import com.boydti.fawe.command.FaweParser;
import com.boydti.fawe.object.extent.MultiTransform;
import com.boydti.fawe.object.extent.RandomTransform;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.boydti.fawe.object.random.TrueRandom;
import com.boydti.fawe.util.StringMan;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.command.TransformCommands;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.ActorAuthorizer;
import com.sk89q.worldedit.internal.command.WorldEditBinding;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.util.command.Dispatcher;
import com.sk89q.worldedit.util.command.SimpleDispatcher;
import com.sk89q.worldedit.util.command.parametric.ParametricBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DefaultTransformParser
extends FaweParser<ResettableExtent> {
    private final Pattern INTERSECTION_PATTERN = Pattern.compile("[&|;]+(?![^\\[]*\\])");
    private final Dispatcher dispatcher = new SimpleDispatcher();

    public DefaultTransformParser(WorldEdit worldEdit) {
        super(worldEdit);
        this.register(new TransformCommands(worldEdit));
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void register(Object clazz) {
        ParametricBuilder builder = new ParametricBuilder();
        builder.setAuthorizer(new ActorAuthorizer());
        builder.addBinding(new WorldEditBinding(this.worldEdit), new Type[0]);
        builder.registerMethodsAsCommands(this.dispatcher, clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResettableExtent parseFromInput(String input, ParserContext context) throws InputParseException {
        Actor actor;
        if (input.isEmpty()) {
            return null;
        }
        ArrayList<Double> unionChances = new ArrayList<Double>();
        ArrayList<Double> intersectionChances = new ArrayList<Double>();
        ArrayList<ResettableExtent> intersection = new ArrayList<ResettableExtent>();
        ArrayList<ResettableExtent> union = new ArrayList<ResettableExtent>();
        CommandLocals locals = new CommandLocals();
        Actor actor2 = actor = context != null ? context.getActor() : null;
        if (actor != null) {
            locals.put(Actor.class, actor);
        }
        try {
            List<Map.Entry<FaweParser.ParseEntry, List<String>>> parsed = DefaultTransformParser.parse(input);
            for (Map.Entry<FaweParser.ParseEntry, List<String>> entry : parsed) {
                FaweParser.ParseEntry pe = entry.getKey();
                String command = pe.input;
                ResettableExtent transform = null;
                double chance = 1.0;
                if (command.isEmpty()) {
                    transform = this.parseFromInput(StringMan.join((Collection)entry.getValue(), ','), context);
                } else if (this.dispatcher.get(command) == null) {
                    int percentIndex = command.indexOf(37);
                    if (percentIndex == -1) throw new NoMatchException("See: //transforms");
                    chance = Expression.compile(command.substring(0, percentIndex), new String[0]).evaluate(new double[0]);
                    command = command.substring(percentIndex + 1);
                    if (!entry.getValue().isEmpty()) {
                        if (!command.isEmpty()) {
                            command = command + " ";
                        }
                        command = command + StringMan.join((Collection)entry.getValue(), " ");
                    }
                    transform = this.parseFromInput(command, context);
                } else {
                    List<String> args = entry.getValue();
                    if (!args.isEmpty()) {
                        command = command + " " + StringMan.join(args, " ");
                    }
                    transform = (ResettableExtent)this.dispatcher.call(command, locals, new String[0]);
                }
                if (pe.and) {
                    intersectionChances.add(chance);
                    intersection.add(transform);
                    continue;
                }
                if (!intersection.isEmpty()) {
                    if (intersection.size() == 1) {
                        throw new InputParseException("Error, floating &");
                    }
                    MultiTransform multi = new MultiTransform();
                    double total = 0.0;
                    for (int i = 0; i < intersection.size(); ++i) {
                        Double value = (Double)intersectionChances.get(i);
                        total += value.doubleValue();
                        multi.add((ResettableExtent)intersection.get(i), value);
                    }
                    union.add(multi);
                    unionChances.add(total);
                    intersection.clear();
                    intersectionChances.clear();
                }
                unionChances.add(chance);
                union.add(transform);
            }
        }
        catch (Throwable e) {
            throw new InputParseException(e.getMessage(), e);
        }
        if (!intersection.isEmpty()) {
            if (intersection.size() == 1) {
                throw new InputParseException("Error, floating &");
            }
            MultiTransform multi = new MultiTransform();
            double total = 0.0;
            for (int i = 0; i < intersection.size(); ++i) {
                Double value = (Double)intersectionChances.get(i);
                total += value.doubleValue();
                multi.add((ResettableExtent)intersection.get(i), value);
            }
            union.add(multi);
            unionChances.add(total);
            intersection.clear();
            intersectionChances.clear();
        }
        if (union.isEmpty()) {
            throw new NoMatchException("See: //transforms");
        }
        if (union.size() == 1) {
            return (ResettableExtent)union.get(0);
        }
        RandomTransform random = new RandomTransform(new TrueRandom());
        for (int i = 0; i < union.size(); ++i) {
            random.add((ResettableExtent)union.get(i), (Double)unionChances.get(i));
        }
        return random;
    }
}

