/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool.brush;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.block.BlockState;

public class GravityBrush
implements Brush {
    private final boolean fullHeight;

    public GravityBrush(boolean fullHeight) {
        this.fullHeight = fullHeight;
    }

    @Override
    public void build(EditSession editSession, Vector position, Pattern pattern, double sizeDouble) throws MaxChangedBlocksException {
        Mask mask = editSession.getMask();
        if (mask == Masks.alwaysTrue() || mask == Masks.alwaysTrue2D()) {
            mask = null;
        }
        int size = (int)sizeDouble;
        int endY = position.getBlockY() + size;
        int startPerformY = Math.max(0, position.getBlockY() - size);
        int startCheckY = this.fullHeight ? 0 : startPerformY;
        Vector mutablePos = new Vector(0, 0, 0);
        for (int x = position.getBlockX() + size; x > position.getBlockX() - size; --x) {
            for (int z = position.getBlockZ() + size; z > position.getBlockZ() - size; --z) {
                int freeSpot = startCheckY;
                for (int y = startCheckY; y <= endY; ++y) {
                    BlockState block = editSession.getLazyBlock(x, y, z);
                    if (block.getBlockType().getMaterial().isAir()) continue;
                    if (y != freeSpot) {
                        editSession.setBlock(x, y, z, EditSession.nullBlock);
                        editSession.setBlock(x, freeSpot, z, block);
                    }
                    freeSpot = y + 1;
                }
            }
        }
    }
}

