/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.composition;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FaweChunk;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.extent.FaweRegionExtent;
import com.boydti.fawe.util.MainUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.Contextual;
import com.sk89q.worldedit.function.EditContext;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.block.BlockReplace;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.command.argument.CommandArgs;
import com.sk89q.worldedit.util.command.composition.CommandExecutor;
import com.sk89q.worldedit.util.command.composition.SimpleCommand;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class SelectionCommand
extends SimpleCommand<Operation> {
    private final CommandExecutor<Contextual<? extends Operation>> delegate;
    private final String permission;

    public SelectionCommand(CommandExecutor<Contextual<? extends Operation>> delegate, String permission) {
        Preconditions.checkNotNull(delegate, (Object)"delegate");
        Preconditions.checkNotNull((Object)permission, (Object)"permission");
        this.delegate = delegate;
        this.permission = permission;
        this.addParameter(delegate);
    }

    @Override
    public Operation call(CommandArgs args, CommandLocals locals) throws CommandException {
        if (!this.testPermission(locals)) {
            throw new CommandPermissionsException();
        }
        Contextual<? extends Operation> operationFactory = this.delegate.call(args, locals);
        Actor actor = locals.get(Actor.class);
        if (actor instanceof Player) {
            try {
                Player player = (Player)actor;
                LocalSession session = WorldEdit.getInstance().getSessionManager().get(player);
                Region selection = session.getSelection(player.getWorld());
                EditSession editSession = session.createEditSession(player);
                editSession.enableQueue();
                locals.put(EditSession.class, editSession);
                session.tellVersion(player);
                EditContext editContext = new EditContext();
                editContext.setDestination(locals.get(EditSession.class));
                editContext.setRegion(selection);
                Operation operation = operationFactory.createFromContext(editContext);
                if (selection instanceof CuboidRegion && editSession.hasFastMode() && operation instanceof RegionVisitor) {
                    CuboidRegion cuboid = (CuboidRegion)selection;
                    RegionFunction function = ((RegionVisitor)operation).function;
                    RegionWrapper current = new RegionWrapper(cuboid.getMinimumPoint(), cuboid.getMaximumPoint());
                    FawePlayer fp = FawePlayer.wrap(player);
                    FaweRegionExtent regionExtent = editSession.getRegionExtent();
                    if (function instanceof BlockReplace && regionExtent == null || regionExtent.isGlobal()) {
                        try {
                            BlockReplace replace = (BlockReplace)function;
                            Field field = replace.getClass().getDeclaredField("pattern");
                            field.setAccessible(true);
                            Pattern pattern = (Pattern)field.get(replace);
                            if (pattern instanceof BlockStateHolder) {
                                final BlockStateHolder block = (BlockStateHolder)pattern;
                                final FaweQueue queue = editSession.getQueue();
                                final int minY = cuboid.getMinimumY();
                                final int maxY = cuboid.getMaximumY();
                                final FaweChunk fc = queue.getFaweChunk(0, 0);
                                fc.fillCuboid(0, 15, minY, maxY, 0, 15, block.getInternalId());
                                fc.optimize();
                                int bcx = current.minX >> 4;
                                int bcz = current.minZ >> 4;
                                int tcx = current.maxX >> 4;
                                int tcz = current.maxZ >> 4;
                                MainUtil.chunkTaskSync(current, new RunnableVal<int[]>(){

                                    @Override
                                    public void run(int[] value) {
                                        FaweChunk newChunk;
                                        if (value[6] == 0) {
                                            newChunk = fc.copy(true);
                                            newChunk.setLoc(queue, value[0], value[1]);
                                        } else {
                                            int bx = value[2] & 0xF;
                                            int tx = value[4] & 0xF;
                                            int bz = value[3] & 0xF;
                                            int tz = value[5] & 0xF;
                                            if (bx == 0 && tx == 15 && bz == 0 && tz == 15) {
                                                newChunk = fc.copy(true);
                                                newChunk.setLoc(queue, value[0], value[1]);
                                            } else {
                                                newChunk = queue.getFaweChunk(value[0], value[1]);
                                                newChunk.fillCuboid(value[2] & 0xF, value[4] & 0xF, minY, maxY, value[3] & 0xF, value[5] & 0xF, block.getInternalId());
                                            }
                                        }
                                        newChunk.addToQueue();
                                    }
                                });
                                queue.enqueue();
                                BBC.OPERATION.send(actor, BBC.VISITOR_BLOCK.format(cuboid.getArea()));
                                queue.flush();
                                return null;
                            }
                        }
                        catch (Throwable e) {
                            MainUtil.handleError(e);
                        }
                    }
                }
                Operations.completeBlindly(operation);
                ArrayList messages = Lists.newArrayList();
                operation.addStatusMessages(messages);
                if (messages.isEmpty()) {
                    BBC.OPERATION.send(actor, 0);
                } else {
                    BBC.OPERATION.send(actor, Joiner.on((String)", ").join((Iterable)messages));
                }
                return operation;
            }
            catch (IncompleteRegionException e) {
                WorldEdit.getInstance().getPlatformManager().getCommandManager().getExceptionConverter().convert(e);
                return null;
            }
        }
        throw new CommandException("This command can only be used by players.");
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public boolean testPermission0(CommandLocals locals) {
        return locals.get(Actor.class).hasPermission(this.permission);
    }
}

