/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.jnbt.anvil.generator.CavesGen;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.TextureUtil;
import com.boydti.fawe.util.image.ImageUtil;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.internal.annotation.Selection;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.command.binding.Range;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.binding.Text;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.util.command.parametric.ParameterException;
import com.sk89q.worldedit.world.biome.BaseBiome;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

@Command(aliases={}, desc="Create structures and features: [More Info](https://goo.gl/KuLFRW)")
public class GenerationCommands
extends MethodCommands {
    public GenerationCommands(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Command(aliases={"/caves"}, usage="[size=8] [freq=40] [rarity=7] [minY=8] [maxY=127] [sysFreq=1] [sysRarity=25] [pocketRarity=0] [pocketMin=0] [pocketMax=3]", desc="Generates caves", help="Generates a cave network")
    @CommandPermissions(value={"worldedit.generation.caves"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void caves(FawePlayer fp, LocalSession session, EditSession editSession, @Selection Region region, @Optional(value={"8"}) int size, @Optional(value={"40"}) int frequency, @Optional(value={"7"}) int rarity, @Optional(value={"8"}) int minY, @Optional(value={"127"}) int maxY, @Optional(value={"1"}) int systemFrequency, @Optional(value={"25"}) int individualRarity, @Optional(value={"0"}) int pocketChance, @Optional(value={"0"}) int pocketMin, @Optional(value={"3"}) int pocketMax, CommandContext context) throws WorldEditException, ParameterException {
        fp.checkConfirmationRegion(() -> {
            CavesGen gen = new CavesGen(size, frequency, rarity, minY, maxY, systemFrequency, individualRarity, pocketChance, pocketMin, pocketMax);
            editSession.generate(region, gen);
            BBC.VISITOR_BLOCK.send(fp, editSession.getBlockChangeCount());
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/ores"}, desc="Generates ores", help="Generates ores", min=1, max=1)
    @CommandPermissions(value={"worldedit.generation.ore"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void ores(FawePlayer player, LocalSession session, EditSession editSession, @Selection Region region, Mask mask, CommandContext context) throws WorldEditException, ParameterException {
        player.checkConfirmationRegion(() -> {
            editSession.addOres(region, mask);
            BBC.VISITOR_BLOCK.send(player, editSession.getBlockChangeCount());
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/image", "/img"}, desc="Generate an image", usage="<imgur> [randomize=true] [complexity=100] [dimensions=100,100]", min=1, max=4)
    @CommandPermissions(value={"worldedit.generation.image"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void image(Player player, LocalSession session, final EditSession editSession, String arg, @Optional(value={"true"}) boolean randomize, @Optional(value={"100"}) int threshold, @Optional Vector2D dimensions) throws WorldEditException, ParameterException, IOException {
        final TextureUtil tu = Fawe.get().getCachedTextureUtil(randomize, 0, threshold);
        URL url = new URL(arg);
        if (!url.getHost().equalsIgnoreCase("i.imgur.com") && !url.getHost().equalsIgnoreCase("empcraft.com")) {
            throw new IOException("Only i.imgur.com or empcraft.com/ui links are allowed!");
        }
        FawePlayer fp = FawePlayer.wrap(player);
        BufferedImage image = MainUtil.readImage(url);
        if (dimensions != null) {
            image = ImageUtil.getScaledInstance(image, dimensions.getBlockX(), dimensions.getBlockZ(), RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
        }
        final MutableBlockVector pos1 = new MutableBlockVector(player.getLocation().toVector());
        MutableBlockVector pos2 = new MutableBlockVector(pos1.add(image.getWidth() - 1, 0, image.getHeight() - 1));
        CuboidRegion region = new CuboidRegion(pos1, pos2);
        final int[] count = new int[1];
        final BufferedImage finalImage = image;
        RegionVisitor visitor = new RegionVisitor((Region)region, new RegionFunction(){

            @Override
            public boolean apply(Vector pos) throws WorldEditException {
                try {
                    int x = pos.getBlockX() - pos1.getBlockX();
                    int z = pos.getBlockZ() - pos1.getBlockZ();
                    int color = finalImage.getRGB(x, z);
                    BlockTypes block = tu.getNearestBlock(color);
                    count[0] = count[0] + 1;
                    if (block != null) {
                        return editSession.setBlock(pos, block.getDefaultState());
                    }
                    return false;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }, editSession);
        Operations.completeBlindly(visitor);
        BBC.VISITOR_BLOCK.send(player, editSession.getBlockChangeCount());
    }

    @Command(aliases={"/ore"}, usage="<mask> <pattern> <size> <freq> <rarity> <minY> <maxY>", desc="Generates ores", help="Generates ores", min=7, max=7)
    @CommandPermissions(value={"worldedit.generation.ore"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void ore(FawePlayer player, LocalSession session, EditSession editSession, @Selection Region region, Mask mask, Pattern material, @Range(min=0.0) int size, int freq, @Range(min=0.0, max=100.0) int rarity, @Range(min=0.0, max=255.0) int minY, @Range(min=0.0, max=255.0) int maxY, CommandContext context) throws WorldEditException, ParameterException {
        player.checkConfirmationRegion(() -> {
            editSession.addOre(region, mask, material, size, freq, rarity, minY, maxY);
            BBC.VISITOR_BLOCK.send(player, editSession.getBlockChangeCount());
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/hcyl"}, usage="<pattern> <radius>[,<radius>] [height]", desc="Generates a hollow cylinder.", help="Generates a hollow cylinder.\nBy specifying 2 radii, separated by a comma,\nyou can generate elliptical cylinders.\nThe 1st radius is north/south, the 2nd radius is east/west.", min=2, max=4)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hcyl(FawePlayer fp, Player player, LocalSession session, EditSession editSession, Pattern pattern, Vector2D radius, @Optional(value={"1"}) int height, @Range(min=1.0) @Optional(value={"1"}) double thickness, CommandContext context) throws WorldEditException, ParameterException {
        double max = MathMan.max(radius.getBlockX(), radius.getBlockZ());
        this.worldEdit.checkMaxRadius(max);
        Vector pos = session.getPlacementPosition(player);
        fp.checkConfirmationRadius(() -> {
            int affected = editSession.makeHollowCylinder(pos, pattern, radius.getX(), radius.getZ(), Math.min(256, height), thickness - 1.0);
            BBC.VISITOR_BLOCK.send(fp, affected);
        }, this.getArguments(context), (int)max, context);
    }

    @Command(aliases={"/cyl"}, usage="<pattern> <radius>[,<radius>] [height]", flags="h", desc="Generates a cylinder.", help="Generates a cylinder.\nBy specifying 2 radii, separated by a comma,\nyou can generate elliptical cylinders.\nThe 1st radius is north/south, the 2nd radius is east/west.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void cyl(FawePlayer fp, Player player, LocalSession session, EditSession editSession, Pattern pattern, Vector2D radius, @Optional(value={"1"}) int height, @Switch(value=104) boolean hollow, CommandContext context) throws WorldEditException, ParameterException {
        double max = MathMan.max(radius.getBlockX(), radius.getBlockZ());
        this.worldEdit.checkMaxRadius(max);
        Vector pos = session.getPlacementPosition(player);
        fp.checkConfirmationRadius(() -> {
            int affected = editSession.makeCylinder(pos, pattern, radius.getX(), radius.getZ(), Math.min(256, height), !hollow);
            BBC.VISITOR_BLOCK.send(fp, affected);
        }, this.getArguments(context), (int)max, context);
    }

    @Command(aliases={"/hsphere"}, usage="<pattern> <radius>[,<radius>,<radius>] [raised?]", desc="Generates a hollow sphere.", help="Generates a hollow sphere.\nBy specifying 3 radii, separated by commas,\nyou can generate an ellipsoid. The order of the ellipsoid radii\nis north/south, up/down, east/west.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hsphere(FawePlayer fp, Player player, LocalSession session, EditSession editSession, Pattern pattern, Vector radius, @Optional(value={"false"}) boolean raised, CommandContext context) throws WorldEditException, ParameterException {
        this.sphere(fp, player, session, editSession, pattern, radius, raised, true, context);
    }

    @Command(aliases={"/sphere"}, usage="<pattern> <radius>[,<radius>,<radius>] [raised?]", flags="h", desc="Generates a filled sphere.", help="Generates a filled sphere.\nBy specifying 3 radii, separated by commas,\nyou can generate an ellipsoid. The order of the ellipsoid radii\nis north/south, up/down, east/west.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void sphere(FawePlayer fp, Player player, LocalSession session, EditSession editSession, Pattern pattern, Vector radius, @Optional(value={"false"}) boolean raised, @Switch(value=104) boolean hollow, CommandContext context) throws WorldEditException, ParameterException {
        double max = MathMan.max(radius.getBlockX(), radius.getBlockY(), radius.getBlockZ());
        this.worldEdit.checkMaxRadius(max);
        Vector pos = session.getPlacementPosition(player);
        Vector finalPos = raised ? pos.add(0.0, radius.getY(), 0.0) : pos;
        fp.checkConfirmationRadius(() -> {
            int affected = editSession.makeSphere(finalPos, pattern, radius.getX(), radius.getY(), radius.getZ(), !hollow);
            player.findFreePosition();
            BBC.VISITOR_BLOCK.send(fp, affected);
        }, this.getArguments(context), (int)max, context);
    }

    @Command(aliases={"forestgen"}, usage="[size] [tree-type] [density]", desc="Generate a forest", min=0, max=3)
    @CommandPermissions(value={"worldedit.generation.forest"})
    @Logging(value=Logging.LogMode.POSITION)
    public void forestGen(Player player, LocalSession session, EditSession editSession, @Optional(value={"10"}) int size, @Optional(value={"tree"}) TreeGenerator.TreeType type, @Optional(value={"5"}) double density) throws WorldEditException, ParameterException {
        int affected = editSession.makeForest(session.getPlacementPosition(player), size, density /= 100.0, type);
        player.print(BBC.getPrefix() + affected + " trees created.");
    }

    @Command(aliases={"pumpkins"}, usage="[size=10] [density=0.02]", desc="Generate pumpkin patches", min=0, max=2)
    @CommandPermissions(value={"worldedit.generation.pumpkins"})
    @Logging(value=Logging.LogMode.POSITION)
    public void pumpkins(Player player, LocalSession session, EditSession editSession, @Optional(value={"10"}) int apothem, @Optional(value={"0.02"}) double density) throws WorldEditException, ParameterException {
        int affected = editSession.makePumpkinPatches(session.getPlacementPosition(player), apothem, density);
        BBC.COMMAND_PUMPKIN.send(player, affected);
    }

    @Command(aliases={"/hpyramid"}, usage="<pattern> <size>", desc="Generate a hollow pyramid", min=2, max=2)
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hollowPyramid(FawePlayer fp, Player player, LocalSession session, EditSession editSession, Pattern pattern, @Range(min=1.0) int size, CommandContext context) throws WorldEditException, ParameterException {
        this.pyramid(fp, player, session, editSession, pattern, size, true, context);
    }

    @Command(aliases={"/pyramid"}, usage="<pattern> <size>", flags="h", desc="Generate a filled pyramid", min=2, max=2)
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void pyramid(FawePlayer fp, Player player, LocalSession session, EditSession editSession, Pattern pattern, @Range(min=1.0) int size, @Switch(value=104) boolean hollow, CommandContext context) throws WorldEditException, ParameterException {
        this.worldEdit.checkMaxRadius(size);
        Vector pos = session.getPlacementPosition(player);
        fp.checkConfirmationRadius(() -> {
            int affected = editSession.makePyramid(pos, pattern, size, !hollow);
            player.findFreePosition();
            BBC.VISITOR_BLOCK.send(fp, affected);
        }, this.getArguments(context), size, context);
    }

    @Command(aliases={"/generate", "/gen", "/g"}, usage="<pattern> <expression>", desc="Generates a shape according to a formula.", help="Generates a shape according to a formula that is expected to\nreturn positive numbers (true) if the point is inside the shape\nOptionally set type/data to the desired block.\nFlags:\n  -h to generate a hollow shape\n  -r to use raw minecraft coordinates\n  -o is like -r, except offset from placement.\n  -c is like -r, except offset selection center.\nIf neither -r nor -o is given, the selection is mapped to -1..1\nSee also tinyurl.com/wesyntax.", flags="hroc", min=2, max=-1)
    @CommandPermissions(value={"worldedit.generation.shape"})
    @Logging(value=Logging.LogMode.ALL)
    public void generate(FawePlayer fp, Player player, LocalSession session, EditSession editSession, @Selection Region region, Pattern pattern, @Text String expression, @Switch(value=104) boolean hollow, @Switch(value=114) boolean useRawCoords, @Switch(value=111) boolean offset, @Switch(value=99) boolean offsetCenter, CommandContext context) throws WorldEditException, ParameterException {
        Vector unit;
        Vector zero;
        if (useRawCoords) {
            zero = Vector.ZERO;
            unit = Vector.ONE;
        } else if (offset) {
            zero = session.getPlacementPosition(player);
            unit = Vector.ONE;
        } else if (offsetCenter) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            zero = max.add(min).multiply(0.5);
            unit = Vector.ONE;
        } else {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit.mutX(1);
            }
            if (unit.getY() == 0.0) {
                unit.mutY(1);
            }
            if (unit.getZ() == 0.0) {
                unit.mutZ(1);
            }
        }
        fp.checkConfirmationRegion(() -> {
            try {
                int affected = editSession.makeShape(region, zero, unit, pattern, expression, hollow);
                player.findFreePosition();
                BBC.VISITOR_BLOCK.send(fp, affected);
            }
            catch (ExpressionException e) {
                fp.sendMessage(BBC.getPrefix() + e.getMessage());
            }
        }, this.getArguments(context), region, context);
    }

    @Command(aliases={"/generatebiome", "/genbiome", "/gb"}, usage="<biome> <expression>", desc="Sets biome according to a formula.", help="Generates a shape according to a formula that is expected to\nreturn positive numbers (true) if the point is inside the shape\nSets the biome of blocks in that shape.\nFlags:\n  -h to generate a hollow shape\n  -r to use raw minecraft coordinates\n  -o is like -r, except offset from placement.\n  -c is like -r, except offset selection center.\nIf neither -r nor -o is given, the selection is mapped to -1..1\nSee also tinyurl.com/wesyntax.", flags="hroc", min=2, max=-1)
    @CommandPermissions(value={"worldedit.generation.shape", "worldedit.biome.set"})
    @Logging(value=Logging.LogMode.ALL)
    public void generateBiome(FawePlayer fp, Player player, LocalSession session, EditSession editSession, @Selection Region region, BaseBiome target, @Text String expression, @Switch(value=104) boolean hollow, @Switch(value=114) boolean useRawCoords, @Switch(value=111) boolean offset, @Switch(value=99) boolean offsetCenter, CommandContext context) throws WorldEditException, ParameterException {
        Vector unit;
        Vector zero;
        if (useRawCoords) {
            zero = Vector.ZERO;
            unit = Vector.ONE;
        } else if (offset) {
            zero = session.getPlacementPosition(player);
            unit = Vector.ONE;
        } else if (offsetCenter) {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            zero = max.add(min).multiply(0.5);
            unit = Vector.ONE;
        } else {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit.mutX(1);
            }
            if (unit.getY() == 0.0) {
                unit.mutY(1);
            }
            if (unit.getZ() == 0.0) {
                unit.mutZ(1);
            }
        }
        fp.checkConfirmationRegion(() -> {
            try {
                int affected = editSession.makeBiomeShape(region, zero, unit, target, expression, hollow);
                player.findFreePosition();
                BBC.VISITOR_FLAT.send(fp, affected);
            }
            catch (ExpressionException e) {
                fp.sendMessage(BBC.getPrefix() + e.getMessage());
            }
        }, this.getArguments(context), region, context);
    }
}

