/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.transform.BlockTransformExtent;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.CombinedTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;

public class FlattenedClipboardTransform {
    private final Clipboard original;
    private final Transform transform;

    private FlattenedClipboardTransform(Clipboard original, Transform transform) {
        Preconditions.checkNotNull((Object)original);
        Preconditions.checkNotNull((Object)transform);
        this.original = original;
        this.transform = transform;
    }

    public Region getTransformedRegion() {
        Region region = this.original.getRegion();
        Vector minimum = region.getMinimumPoint();
        Vector maximum = region.getMaximumPoint();
        CombinedTransform transformAround = new CombinedTransform(new AffineTransform().translate(this.original.getOrigin().multiply(-1)), this.transform, new AffineTransform().translate(this.original.getOrigin()));
        Vector[] corners = new Vector[]{minimum, maximum, new Vector(maximum.getX(), minimum.getY(), minimum.getZ()), new Vector(minimum.getX(), maximum.getY(), minimum.getZ()), new Vector(minimum.getX(), minimum.getY(), maximum.getZ()), new Vector(minimum.getX(), maximum.getY(), maximum.getZ()), new Vector(maximum.getX(), minimum.getY(), maximum.getZ()), new Vector(maximum.getX(), maximum.getY(), minimum.getZ())};
        for (int i = 0; i < corners.length; ++i) {
            corners[i] = transformAround.apply(new Vector(corners[i]));
        }
        Vector newMinimum = corners[0];
        Vector newMaximum = corners[0];
        for (int i = 1; i < corners.length; ++i) {
            newMinimum = Vector.getMinimum(newMinimum, corners[i]);
            newMaximum = Vector.getMaximum(newMaximum, corners[i]);
        }
        newMinimum.mutX(Math.ceil(Math.floor(newMinimum.getX())));
        newMinimum.mutY(Math.ceil(Math.floor(newMinimum.getY())));
        newMinimum.mutZ(Math.ceil(Math.floor(newMinimum.getZ())));
        return new CuboidRegion(newMinimum, newMaximum);
    }

    public Operation copyTo(Extent target) {
        Extent extent = this.original;
        if (this.transform != null && !this.transform.isIdentity()) {
            extent = new BlockTransformExtent(this.original, this.transform);
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(extent, this.original.getRegion(), this.original.getOrigin(), target, this.original.getOrigin());
        copy.setTransform(this.transform);
        return copy;
    }

    public static FlattenedClipboardTransform transform(Clipboard original, Transform transform) {
        return new FlattenedClipboardTransform(original, transform);
    }
}

