/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util.task;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.Metadatable;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.boydti.fawe.util.task.DelayedTask;
import com.boydti.fawe.util.task.ReceiveTask;
import com.boydti.fawe.util.task.ReturnTask;
import com.boydti.fawe.util.task.Task;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;

public class TaskBuilder
extends Metadatable {
    private final ForkJoinPool pool = new ForkJoinPool();
    private final ArrayDeque<RunnableTask> tasks;
    private Object result = null;
    private Thread.UncaughtExceptionHandler handler;
    private FaweQueue queue;
    private long last;
    private long start;
    private Object asyncWaitLock = new Object();
    private Object syncWaitLock = new Object();
    private boolean finished;

    public TaskBuilder() {
        this(null);
    }

    public TaskBuilder(Thread.UncaughtExceptionHandler handler) {
        this.tasks = new ArrayDeque();
        this.handler = handler;
    }

    public TaskBuilder async(Task task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.ASYNC));
        return this;
    }

    public TaskBuilder async(ReceiveTask task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.ASYNC));
        return this;
    }

    public TaskBuilder async(ReturnTask task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.ASYNC));
        return this;
    }

    public TaskBuilder async(Runnable task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.ASYNC));
        return this;
    }

    public TaskBuilder sync(Task task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.SYNC));
        return this;
    }

    public TaskBuilder sync(ReceiveTask task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.SYNC));
        return this;
    }

    public TaskBuilder sync(ReturnTask task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.SYNC));
        return this;
    }

    public TaskBuilder sync(Runnable task) {
        this.tasks.add(RunnableTask.adapt(task, TaskType.SYNC));
        return this;
    }

    public TaskBuilder delay(int ticks) {
        this.tasks.add(RunnableDelayedTask.adapt(ticks));
        return this;
    }

    public TaskBuilder delay(DelayedTask task) {
        this.tasks.add(RunnableDelayedTask.adapt(task));
        return this;
    }

    public TaskBuilder syncParallel(Runnable run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.SYNC_PARALLEL));
        return this;
    }

    public TaskBuilder syncParallel(Task run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.SYNC_PARALLEL));
        return this;
    }

    public TaskBuilder syncParallel(ReceiveTask run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.SYNC_PARALLEL));
        return this;
    }

    public TaskBuilder syncParallel(ReturnTask run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.SYNC_PARALLEL));
        return this;
    }

    public TaskBuilder asyncParallel(Runnable run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.ASYNC_PARALLEL));
        return this;
    }

    public TaskBuilder asyncParallel(Task run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.ASYNC_PARALLEL));
        return this;
    }

    public TaskBuilder asyncParallel(ReceiveTask run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.ASYNC_PARALLEL));
        return this;
    }

    public TaskBuilder asyncParallel(ReturnTask run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.ASYNC_PARALLEL));
        return this;
    }

    public TaskBuilder syncWhenFree(SplitTask run) {
        this.tasks.add(run);
        return this;
    }

    public TaskBuilder syncWhenFree(Task run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.SYNC_WHEN_FREE));
        return this;
    }

    public TaskBuilder syncWhenFree(ReceiveTask run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.SYNC_WHEN_FREE));
        return this;
    }

    public TaskBuilder syncWhenFree(ReturnTask run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.SYNC_WHEN_FREE));
        return this;
    }

    public TaskBuilder abortIfTrue(Task<Boolean, Object> run) {
        this.tasks.add(RunnableTask.adapt(run, TaskType.ABORT));
        return this;
    }

    public TaskBuilder abortIfTrue(final Runnable run) {
        this.tasks.add(RunnableTask.adapt(new Task<Boolean, Boolean>(){

            @Override
            public Boolean run(Boolean previous) {
                if (previous == Boolean.TRUE) {
                    run.run();
                }
                return previous == Boolean.TRUE;
            }
        }, TaskType.ABORT));
        return this;
    }

    public TaskBuilder abortIfNull(final Runnable run) {
        this.tasks.add(RunnableTask.adapt(new Task<Boolean, Object>(){

            @Override
            public Boolean run(Object previous) {
                if (previous == null) {
                    run.run();
                }
                return previous == null;
            }
        }, TaskType.ABORT));
        return this;
    }

    public TaskBuilder abortIfEqual(final Runnable run, final Object other) {
        this.tasks.add(RunnableTask.adapt(new Task<Boolean, Object>(){

            @Override
            public Boolean run(Object previous) {
                if (Objects.equals(previous, other)) {
                    run.run();
                }
                return Objects.equals(previous, other);
            }
        }, TaskType.ABORT));
        return this;
    }

    public TaskBuilder abortIfNotEqual(final Runnable run, final Object other) {
        this.tasks.add(RunnableTask.adapt(new Task<Boolean, Object>(){

            @Override
            public Boolean run(Object previous) {
                if (!Objects.equals(previous, other)) {
                    run.run();
                }
                return !Objects.equals(previous, other);
            }
        }, TaskType.ABORT));
        return this;
    }

    public void buildAsync() {
        TaskManager.IMP.async(new Runnable(){

            @Override
            public void run() {
                TaskBuilder.this.build();
            }
        });
    }

    public void build() {
        RunnableTask peek;
        block20: while ((peek = this.tasks.peek()) != null) {
            try {
                Object task;
                switch (peek.type) {
                    case DELAY: {
                        task = (DelayedTask)((Object)this.tasks.poll());
                        RunnableTask next = this.tasks.peek();
                        if (next != null) {
                            switch (next.type) {
                                case SYNC: 
                                case ABORT: 
                                case SYNC_PARALLEL: {
                                    TaskManager.IMP.later(new Runnable(){

                                        @Override
                                        public void run() {
                                            TaskBuilder.this.build();
                                        }
                                    }, task.getDelay(this.result));
                                    return;
                                }
                            }
                            TaskManager.IMP.laterAsync(new Runnable(){

                                @Override
                                public void run() {
                                    TaskBuilder.this.build();
                                }
                            }, task.getDelay(this.result));
                            return;
                        }
                        return;
                    }
                    case SYNC: 
                    case SYNC_PARALLEL: {
                        if (Fawe.isMainThread()) break;
                        TaskManager.IMP.sync(new RunnableVal(){

                            public void run(Object value) {
                                TaskBuilder.this.build();
                            }
                        });
                        return;
                    }
                    case SYNC_WHEN_FREE: 
                    case ASYNC: 
                    case ASYNC_PARALLEL: {
                        if (!Fawe.isMainThread()) break;
                        TaskManager.IMP.async(new Runnable(){

                            @Override
                            public void run() {
                                TaskBuilder.this.build();
                            }
                        });
                        return;
                    }
                }
                task = this.tasks.poll();
                ((RunnableTask)task).value = this.result;
                switch (((RunnableTask)task).type) {
                    case ABORT: {
                        if (!((Boolean)((Task)task).run(this.result)).booleanValue()) break;
                        return;
                    }
                    case SYNC: {
                        this.result = ((RunnableTask)task).exec(this.result);
                        break;
                    }
                    case SYNC_WHEN_FREE: {
                        if (task instanceof SplitTask) {
                            SplitTask splitTask = (SplitTask)task;
                            this.result = splitTask.execSplit(this.result);
                            break;
                        }
                        this.result = TaskManager.IMP.syncWhenFree(task);
                        break;
                    }
                    case ASYNC: {
                        this.result = ((RunnableTask)task).exec(this.result);
                        continue block20;
                    }
                    case SYNC_PARALLEL: 
                    case ASYNC_PARALLEL: {
                        ArrayList<Object> parallel = new ArrayList<Object>();
                        parallel.add(task);
                        RunnableTask next = this.tasks.peek();
                        while (next != null && next.type == ((RunnableTask)task).type) {
                            parallel.add(next);
                            this.tasks.poll();
                            next = this.tasks.peek();
                        }
                        for (RunnableTask runnableTask : parallel) {
                            this.pool.submit(runnableTask);
                        }
                        this.pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                        this.result = null;
                        for (RunnableTask runnableTask : parallel) {
                            if (runnableTask.value == null) continue;
                            this.result = runnableTask.value;
                        }
                        break;
                    }
                }
                if (!((RunnableTask)task).isAborted()) continue;
                return;
            }
            catch (TaskAbortException abort) {
                return;
            }
            catch (Throwable e1) {
                if (this.handler != null) {
                    try {
                        this.handler.uncaughtException(Thread.currentThread(), e1);
                    }
                    catch (Throwable e2) {
                        e1.printStackTrace();
                        e2.printStackTrace();
                    }
                }
                return;
            }
        }
    }

    private static enum TaskType {
        SYNC,
        ASYNC,
        SYNC_PARALLEL,
        ASYNC_PARALLEL,
        SYNC_WHEN_FREE,
        DELAY,
        ABORT;

    }

    public static abstract class SplitTask
    extends RunnableTask {
        private final long allocation;
        private final FaweQueue queue;
        private long last;
        private long start;
        private Object asyncWaitLock = new Object();
        private Object syncWaitLock = new Object();
        private boolean finished;
        private boolean waitingAsync = true;
        private boolean waitingSync = false;

        public SplitTask() {
            this(20L);
        }

        public SplitTask(long allocation) {
            super(TaskType.SYNC_WHEN_FREE);
            this.allocation = allocation;
            this.queue = SetQueue.IMP.getNewQueue((String)null, true, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execSplit(final Object previous) {
            this.value = previous;
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    try {
                        object = asyncWaitLock;
                        synchronized (object) {
                            asyncWaitLock.notifyAll();
                            asyncWaitLock.wait(Long.MAX_VALUE);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.exec(previous);
                    finished = true;
                    waitingAsync = true;
                    waitingSync = false;
                    object = syncWaitLock;
                    synchronized (object) {
                        syncWaitLock.notifyAll();
                    }
                }
            });
            try {
                Object object = this.asyncWaitLock;
                synchronized (object) {
                    thread.start();
                    this.asyncWaitLock.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (thread.isAlive()) {
                TaskManager.IMP.syncWhenFree(new RunnableVal(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(Object ignore) {
                        block9: {
                            queue.startSet(true);
                            start = System.currentTimeMillis();
                            try {
                                if (finished) break block9;
                                Object object = asyncWaitLock;
                                synchronized (object) {
                                    while (!waitingAsync) {
                                        asyncWaitLock.wait(1L);
                                    }
                                    asyncWaitLock.notifyAll();
                                }
                                waitingSync = true;
                                object = syncWaitLock;
                                synchronized (object) {
                                    syncWaitLock.notifyAll();
                                    syncWaitLock.wait();
                                }
                                waitingSync = false;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        queue.endSet(true);
                    }
                });
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void split() {
            long now = System.currentTimeMillis();
            if (now - this.start > this.allocation) {
                try {
                    Object object = this.syncWaitLock;
                    synchronized (object) {
                        while (!this.waitingSync) {
                            this.syncWaitLock.wait(1L);
                        }
                        this.syncWaitLock.notifyAll();
                    }
                    this.waitingAsync = true;
                    object = this.asyncWaitLock;
                    synchronized (object) {
                        this.asyncWaitLock.notifyAll();
                        this.asyncWaitLock.wait();
                    }
                    this.waitingAsync = false;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static abstract class RunnableDelayedTask
    extends RunnableTask {
        public RunnableDelayedTask(TaskType type) {
            super(type);
        }

        public Object exec(Object previous) {
            return previous;
        }

        public abstract int delay(Object var1);

        public static RunnableDelayedTask adapt(final DelayedTask task) {
            return new RunnableDelayedTask(TaskType.DELAY){

                @Override
                public int delay(Object previous) {
                    return task.getDelay(previous);
                }
            };
        }

        public static RunnableDelayedTask adapt(final int time) {
            return new RunnableDelayedTask(TaskType.DELAY){

                @Override
                public int delay(Object previous) {
                    return time;
                }
            };
        }
    }

    private static abstract class RunnableTask<T>
    extends RunnableVal<T> {
        public final TaskType type;
        private boolean aborted;

        public RunnableTask(TaskType type) {
            this.type = type;
        }

        public void abortNextTasks() {
            this.aborted = true;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public static RunnableTask adapt(final Task task, TaskType type) {
            return new RunnableTask(type){

                public Object exec(Object previous) {
                    return task.run(previous);
                }
            };
        }

        public static RunnableTask adapt(final ReturnTask task, TaskType type) {
            return new RunnableTask(type){

                public Object exec(Object previous) {
                    return task.run();
                }
            };
        }

        public static RunnableTask adapt(final ReceiveTask task, TaskType type) {
            return new RunnableTask(type){

                public Object exec(Object previous) {
                    task.run(previous);
                    return null;
                }
            };
        }

        public static RunnableTask adapt(final Runnable run, TaskType type) {
            return new RunnableTask(type){

                public Object exec(Object previous) {
                    if (run instanceof RunnableVal) {
                        ((RunnableVal)run).value = this.value;
                        this.value = ((RunnableVal)run).runAndGet();
                        return this.value;
                    }
                    run.run();
                    return null;
                }
            };
        }

        public abstract T exec(Object var1);

        @Override
        public final void run(T value) {
            this.value = this.exec(value);
        }
    }

    public static final class TaskAbortException
    extends RuntimeException {
        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

